/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.providers;

import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.ui.editor.editor.figures.PriorityFigure;
import com.yakindu.sct.ui.editor.editparts.TransitionEditPart;
import com.yakindu.sct.ui.editor.providers.AbstractPriorityDecorationProvider;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class TransitionPriorityDecorationProvider
extends AbstractPriorityDecorationProvider {
    public static final int DISTANCE_TO_SOURCE = 6;

    public void createDecorators(IDecoratorTarget decoratorTarget) {
        EditPart editPart = (EditPart)decoratorTarget.getAdapter(EditPart.class);
        if (editPart instanceof GraphicalEditPart || editPart instanceof AbstractConnectionEditPart) {
            EditDomain ed = editPart.getViewer().getEditDomain();
            if (!(ed instanceof DiagramEditDomain)) {
                return;
            }
            if (this.shouldInstall(((DiagramEditDomain)ed).getEditorPart()) && editPart instanceof TransitionEditPart) {
                IDecorator decorator = this.createStatusDecorator(decoratorTarget);
                this.decorators.add(decorator);
                decoratorTarget.installDecorator(this.getDecoratorKey(), decorator);
            }
        }
    }

    protected IDecorator createStatusDecorator(IDecoratorTarget decoratorTarget) {
        return new TransitionPriorityDecorator(decoratorTarget);
    }

    public static class TransitionPriorityDecorator
    extends AbstractPriorityDecorationProvider.AbstractPriorityDecorator {
        public TransitionPriorityDecorator(IDecoratorTarget decoratorTarget) {
            super(decoratorTarget, SGraphPackage.Literals.VERTEX__OUTGOING_TRANSITIONS);
        }

        @Override
        public void activate() {
            if (!(this.semanticElement instanceof Transition) || !(((Transition)this.semanticElement).eContainer() instanceof Vertex)) {
                return;
            }
            if (((Transition)this.semanticElement).eContainer() != null) {
                this.owningElement = (Vertex)((Transition)this.semanticElement).eContainer();
            }
            super.activate();
        }

        @Override
        public void deactivate() {
            if (!(this.semanticElement instanceof Transition)) {
                return;
            }
            this.owningElement = null;
            super.deactivate();
        }

        @Override
        public boolean needsDecoration(IGraphicalEditPart editPart) {
            Transition transition = (Transition)editPart.resolveSemanticElement();
            if (transition.eContainer() instanceof Vertex) {
                Vertex container = (Vertex)transition.eContainer();
                return container.getOutgoingTransitions().size() > 1;
            }
            return false;
        }

        @Override
        public void createDecorators(IGraphicalEditPart editPart) {
            PriorityFigure figure = new PriorityFigure(MapModeUtil.getMapMode(), this.getPriority(editPart));
            figure.setSize(12, 13);
            this.setDecoration(this.getDecoratorTarget().addDecoration((IFigure)figure, (Locator)new ConnectionLocator((Connection)editPart.getFigure(), 3){

                protected Point getLocation(PointList points) {
                    Point p = PointListUtilities.pointOn((PointList)PointListUtilities.copyPoints((PointList)points), (long)6L, (LineSeg.KeyPoint)LineSeg.KeyPoint.ORIGIN, (Point)new Point());
                    return p;
                }
            }, false));
            figure.setToolTip((IFigure)new Label("Transition Priority " + this.getPriority(editPart)));
        }

        @Override
        public int getPriority(IGraphicalEditPart editPart) {
            Transition transition = (Transition)editPart.resolveSemanticElement();
            Vertex container = (Vertex)transition.eContainer();
            int indexOf = container.getOutgoingTransitions().indexOf((Object)transition);
            return indexOf + 1;
        }
    }
}

