/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.validation;

import com.yakindu.sct.model.sgraph.resource.AbstractSCTResource;
import com.yakindu.sct.ui.editor.validation.ValidationJob;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class DefaultValidationJob
extends ValidationJob {
    @Override
    protected IStatus runInternal(final IProgressMonitor monitor) {
        try {
            if (!this.resource.isLoaded()) {
                return Status.CANCEL_STATUS;
            }
            if (this.resource instanceof AbstractSCTResource) {
                this.relinkModel(monitor, (AbstractSCTResource)this.resource);
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            TransactionalValidationRunner runner = new TransactionalValidationRunner(this.validator, this.resource, CheckMode.FAST_ONLY, new CancelIndicator(){

                public boolean isCanceled() {
                    return monitor.isCanceled();
                }
            });
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)this.resource);
            if (editingDomain == null) {
                return Status.CANCEL_STATUS;
            }
            try {
                editingDomain.runExclusive((Runnable)((Object)runner));
            }
            catch (Throwable ex) {
                return Status.CANCEL_STATUS;
            }
            List issues = (List)runner.getResult();
            if (issues == null) {
                return Status.CANCEL_STATUS;
            }
            this.validationIssueProcessor.processIssues(issues, monitor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new Status(4, "com.yakindu.sct.ui.editor", ex.getMessage());
        }
        return Status.OK_STATUS;
    }

    protected void relinkModel(IProgressMonitor monitor, final AbstractSCTResource eResource) throws ExecutionException {
        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(TransactionUtil.getEditingDomain((Resource)eResource), "", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                eResource.linkSpecificationElements();
                return CommandResult.newOKCommandResult();
            }
        };
        cmd.execute(monitor, null);
    }

    public static class TransactionalValidationRunner
    extends RunnableWithResult.Impl<List<Issue>> {
        private IResourceValidator validator;
        private Resource resource;
        private CheckMode checkMode;
        private CancelIndicator indicator;

        public TransactionalValidationRunner(IResourceValidator validator, Resource resource, CheckMode checkMode, CancelIndicator indicator) {
            this.validator = validator;
            this.resource = resource;
            this.checkMode = checkMode;
            this.indicator = indicator;
        }

        public void run() {
            try {
                List result = this.validator.validate(this.resource, this.checkMode, this.indicator);
                this.setResult(result);
                this.setStatus(Status.OK_STATUS);
            }
            catch (OperationCanceledException ex) {
                this.setStatus(Status.CANCEL_STATUS);
            }
        }
    }
}

