/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.wizards;

import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.ui.editor.DiagramActivator;
import com.yakindu.sct.ui.editor.wizards.CreationWizard;
import com.yakindu.sct.ui.editor.wizards.IModelCreator;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;

public class DiagramCreator {
    protected PreferencesHint preferencesHint = DiagramActivator.DIAGRAM_PREFERENCES_HINT;

    public Resource createDiagram(final CreationWizard.DiagramCreationDesccription create, IProgressMonitor progressMonitor) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        progressMonitor.beginTask("Creating diagram file ...", 3);
        final Resource resource = editingDomain.getResourceSet().createResource(create.getModelURI());
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Creating diagram file ...", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                IModelCreator creator = (IModelCreator)DomainRegistry.getDomain((String)create.getDomainID()).getInjector("com.yakindu.sct.editor", new String[0]).getInstance(IModelCreator.class);
                creator.createStatechartModel(resource, DiagramCreator.this.preferencesHint);
                Statechart statechart = (Statechart)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SGraphPackage.Literals.STATECHART);
                statechart.setDomainID(create.getDomainID());
                try {
                    resource.save(DiagramCreator.this.getSaveOptions());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            command.execute(progressMonitor, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        this.setCharset(WorkspaceSynchronizer.getFile((Resource)resource));
        editingDomain.dispose();
        return resource;
    }

    protected void setCharset(IFile file) {
        if (file == null) {
            return;
        }
        try {
            file.setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected Map<String, String> getSaveOptions() {
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        return saveOptions;
    }
}

