/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LogicalOperator implements Enumerator
{
    AND(0, "and", "&&"),
    OR(1, "or", "||"),
    NOT(2, "not", "!");

    public static final int AND_VALUE = 0;
    public static final int OR_VALUE = 1;
    public static final int NOT_VALUE = 2;
    private static final LogicalOperator[] VALUES_ARRAY;
    public static final List<LogicalOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LogicalOperator[]{AND, OR, NOT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LogicalOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LogicalOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LogicalOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LogicalOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LogicalOperator get(int value) {
        switch (value) {
            case 0: {
                return AND;
            }
            case 1: {
                return OR;
            }
            case 2: {
                return NOT;
            }
        }
        return null;
    }

    private LogicalOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

