/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.inferrer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.expressions.AssignmentExpression;
import com.yakindu.base.expressions.expressions.BitwiseAndExpression;
import com.yakindu.base.expressions.expressions.BitwiseOrExpression;
import com.yakindu.base.expressions.expressions.BitwiseXorExpression;
import com.yakindu.base.expressions.expressions.BlockExpression;
import com.yakindu.base.expressions.expressions.BoolLiteral;
import com.yakindu.base.expressions.expressions.ConditionalExpression;
import com.yakindu.base.expressions.expressions.DeclarationExpression;
import com.yakindu.base.expressions.expressions.DoubleLiteral;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.EventRaisingExpression;
import com.yakindu.base.expressions.expressions.EventValueReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.expressions.FloatLiteral;
import com.yakindu.base.expressions.expressions.HexLiteral;
import com.yakindu.base.expressions.expressions.IfExpression;
import com.yakindu.base.expressions.expressions.InitializationExpression;
import com.yakindu.base.expressions.expressions.IntLiteral;
import com.yakindu.base.expressions.expressions.LogicalAndExpression;
import com.yakindu.base.expressions.expressions.LogicalNotExpression;
import com.yakindu.base.expressions.expressions.LogicalOrExpression;
import com.yakindu.base.expressions.expressions.LogicalRelationExpression;
import com.yakindu.base.expressions.expressions.NullLiteral;
import com.yakindu.base.expressions.expressions.NumericalAddSubtractExpression;
import com.yakindu.base.expressions.expressions.NumericalMultiplyDivideExpression;
import com.yakindu.base.expressions.expressions.NumericalUnaryExpression;
import com.yakindu.base.expressions.expressions.ParenthesizedExpression;
import com.yakindu.base.expressions.expressions.PostFixUnaryExpression;
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression;
import com.yakindu.base.expressions.expressions.ReturnExpression;
import com.yakindu.base.expressions.expressions.ShiftExpression;
import com.yakindu.base.expressions.expressions.StringLiteral;
import com.yakindu.base.expressions.expressions.SwitchCase;
import com.yakindu.base.expressions.expressions.SwitchExpression;
import com.yakindu.base.expressions.expressions.TypeCastExpression;
import com.yakindu.base.expressions.expressions.UnaryOperator;
import com.yakindu.base.expressions.inferrer.ExpressionsTypeInferrerMessages;
import com.yakindu.base.expressions.inferrer.TypeParameterInferrer;
import com.yakindu.base.expressions.util.ExpressionExtensions;
import com.yakindu.base.types.Annotation;
import com.yakindu.base.types.AnnotationType;
import com.yakindu.base.types.Argument;
import com.yakindu.base.types.ArrayTypeSpecifier;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.EnumerationType;
import com.yakindu.base.types.Enumerator;
import com.yakindu.base.types.Event;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.GenericElement;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.Parameter;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeAlias;
import com.yakindu.base.types.TypeParameter;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.TypedDeclaration;
import com.yakindu.base.types.TypesUtil;
import com.yakindu.base.types.inferrer.AbstractTypeSystemInferrer;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.EventValueMetaFeature;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.base.types.util.ArgumentSorter;
import com.yakindu.base.types.validation.IValidationIssueAcceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class ExpressionsTypeInferrer
extends AbstractTypeSystemInferrer
implements ExpressionsTypeInferrerMessages {
    public static final String ISSUE_CODE_MISSING_INITIALIZATION_ARGUMENT = "InitializationExpression.MissingArgument";
    public static final String ISSUE_MESSAGE_MISSING_INITIALIZATION_ARGUMENT = "Missing initialization argument. Expected %d arguments instead of %d for type %s.";
    public static final String ISSUE_CODE_FEATURE_CALL_IS_NOT_AN_OPERATION_CALL = "FeatureCall.NotOperationCall";
    public static final String ISSUE_MESSAGE_FEATURE_CALL_IS_NOT_AN_OPERATION_CALL = "Feature call is not an operation call. \"%s\" is a Property, not an Operation";
    public static final String ISSUE_CODE_SURPLUS_INITIALIZATION_ARGUMENT = "InitializationExpression.SurplusArgument";
    public static final String ISSUE_MESSAGE_SURPLUS_INITIALIZATION_ARGUMENT = "Surplus initialization argument. Expected %d arguments instead of %d for type %s.";
    public static final String ISSUE_CODE_INITIALIZATION_UNSUPPORTED_TYPE = "InitializationExpression.UnsupportedType";
    public static final String ISSUE_MESSAGE_INITIALIZATION_UNSUPPORTED_TYPE = "Initialization expression is not applicable for type %s.";
    public static final String ISSUE_MESSAGE_UNDEFINED_TYPE = "Undefined type for initialization expression.";
    public static final String ISSUE_MISSING_KEY_MSG = "Missing key in map initialization.";
    public static final String ISSUE_MISSING_KEY_CODE = "MissingKey";
    public static final String MISSING_VALUE = "Need to assign a value to an event of type %s.";
    public static final String EVENT_DEFINITION = "Cannot assign a value of type %s to an event of type %s.";
    @Inject
    protected TypeParameterInferrer typeParameterInferrer;
    @Inject
    @Extension
    protected ExpressionExtensions utils;
    @Inject
    @Extension
    protected EventValueMetaFeature _eventValueMetaFeature;
    @Inject
    protected ITypeSystem typeSystem;
    @Inject
    @Extension
    protected TypesUtil _typesUtil;

    public ITypeSystemInferrer.InferenceResult doInfer(AssignmentExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch((EObject)e.getVarRef());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch((EObject)e.getExpression());
        this.assertAssignable(result1, result2, String.format("Assignment operator '%s' may only be applied on compatible types, not on %s and %s.", new Object[]{e.getOperator(), result1, result2}));
        return this.inferTypeDispatch((EObject)e.getVarRef());
    }

    protected TypedDeclaration parameterForArgument(Argument it) {
        boolean _tripleNotEquals;
        Parameter _xblockexpression = null;
        TypedDeclaration _parameter = it.getParameter();
        boolean bl = _tripleNotEquals = _parameter != null;
        if (_tripleNotEquals) {
            return it.getParameter();
        }
        EObject _eContainer = it.eContainer();
        ArgumentExpression exp = (ArgumentExpression)_eContainer;
        EObject feature = this.utils.featureOrReference(exp);
        Parameter _switchResult = null;
        boolean _matched = false;
        if (feature instanceof Operation) {
            int _size;
            boolean _lessThan;
            int _indexOf = exp.getArguments().indexOf((Object)it);
            boolean bl2 = _lessThan = _indexOf < (_size = ((Operation)feature).getParameters().size());
            if (_lessThan) {
                _matched = true;
                _switchResult = (Parameter)((Operation)feature).getParameters().get(exp.getArguments().indexOf((Object)it));
            }
        }
        if (!_matched) {
            _switchResult = null;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ConditionalExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch((EObject)e.getTrueCase());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch((EObject)e.getFalseCase());
        this.assertCompatible(result1, result2, String.format("Could not determine a common type for %s and %s.", result1, result2));
        this.assertIsSubType(this.inferTypeDispatch((EObject)e.getCondition()), this.getResultFor("boolean"), "conditional expression must be of type boolean.");
        return this.getCommonType(result1, result2);
    }

    public ITypeSystemInferrer.InferenceResult doInfer(LogicalOrExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch((EObject)e.getLeftOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch((EObject)e.getRightOperand());
        this.assertIsSubType(result1, this.getResultFor("boolean"), String.format("Logical operator '%s' may only be applied on boolean types, not on %s and %s.", "||", result1, result2));
        this.assertIsSubType(result2, this.getResultFor("boolean"), String.format("Logical operator '%s' may only be applied on boolean types, not on %s and %s.", "||", result1, result2));
        return this.getResultFor("boolean");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(LogicalAndExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch((EObject)e.getLeftOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch((EObject)e.getRightOperand());
        this.assertIsSubType(result1, this.getResultFor("boolean"), String.format("Logical operator '%s' may only be applied on boolean types, not on %s and %s.", "&&", result1, result2));
        this.assertIsSubType(result2, this.getResultFor("boolean"), String.format("Logical operator '%s' may only be applied on boolean types, not on %s and %s.", "&&", result1, result2));
        return this.getResultFor("boolean");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(LogicalNotExpression e) {
        ITypeSystemInferrer.InferenceResult type = this.inferTypeDispatch((EObject)e.getOperand());
        this.assertIsSubType(type, this.getResultFor("boolean"), String.format("Logical operator '%s' may only be applied on boolean types, not on %s.", "!", type));
        return this.getResultFor("boolean");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(BitwiseXorExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch((EObject)e.getLeftOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch((EObject)e.getRightOperand());
        this.assertIsSubType(result1, this.getResultFor("integer"), String.format("Bitwise operator '%s' may only be applied on integer types, not on %s and %s.", "^", result1, result2));
        this.assertIsSubType(result2, this.getResultFor("integer"), String.format("Bitwise operator '%s' may only be applied on integer types, not on %s and %s.", "^", result1, result2));
        return this.getResultFor("integer");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(BitwiseOrExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch((EObject)e.getLeftOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch((EObject)e.getRightOperand());
        this.assertIsSubType(result1, this.getResultFor("integer"), String.format("Bitwise operator '%s' may only be applied on integer types, not on %s and %s.", "|", result1, result2));
        this.assertIsSubType(result2, this.getResultFor("integer"), String.format("Bitwise operator '%s' may only be applied on integer types, not on %s and %s.", "|", result1, result2));
        return this.getResultFor("integer");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(BitwiseAndExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch((EObject)e.getLeftOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch((EObject)e.getRightOperand());
        this.assertIsSubType(result1, this.getResultFor("integer"), String.format("Bitwise operator '%s' may only be applied on integer types, not on %s and %s.", "&", result1, result2));
        this.assertIsSubType(result2, this.getResultFor("integer"), String.format("Bitwise operator '%s' may only be applied on integer types, not on %s and %s.", "&", result1, result2));
        return this.getResultFor("integer");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ShiftExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch((EObject)e.getLeftOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch((EObject)e.getRightOperand());
        this.assertIsSubType(result1, this.getResultFor("integer"), String.format("Bitwise operator '%s' may only be applied on integer types, not on %s and %s.", new Object[]{e.getOperator(), result1, result2}));
        this.assertIsSubType(result2, this.getResultFor("integer"), String.format("Bitwise operator '%s' may only be applied on integer types, not on %s and %s.", new Object[]{e.getOperator(), result1, result2}));
        return this.getResultFor("integer");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(LogicalRelationExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch((EObject)e.getLeftOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch((EObject)e.getRightOperand());
        this.assertCompatible(result1, result2, String.format("Comparison operator '%s' may only be applied on compatible types, not on %s and %s.", new Object[]{e.getOperator(), result1, result2}));
        return this.getResultFor("boolean");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(NumericalAddSubtractExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch((EObject)e.getLeftOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch((EObject)e.getRightOperand());
        this.assertCompatible(result1, result2, String.format("Arithmetic operator '%s' may only be applied on numeric types, not on %s and %s.", new Object[]{e.getOperator(), result1, result2}));
        this.assertIsSubType(result1, this.getResultFor("real"), String.format("Arithmetic operator '%s' may only be applied on numeric types, not on %s and %s.", new Object[]{e.getOperator(), result1, result2}));
        return this.getCommonType(result1, result2);
    }

    public ITypeSystemInferrer.InferenceResult doInfer(NumericalMultiplyDivideExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch((EObject)e.getLeftOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch((EObject)e.getRightOperand());
        this.assertCompatible(result1, result2, String.format("Arithmetic operator '%s' may only be applied on numeric types, not on %s and %s.", new Object[]{e.getOperator(), result1, result2}));
        this.assertIsSubType(result1, this.getResultFor("real"), String.format("Arithmetic operator '%s' may only be applied on numeric types, not on %s and %s.", new Object[]{e.getOperator(), result1, result2}));
        return this.getCommonType(result1, result2);
    }

    public ITypeSystemInferrer.InferenceResult doInfer(NumericalUnaryExpression e) {
        boolean _tripleEquals;
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch((EObject)e.getOperand());
        UnaryOperator _operator = e.getOperator();
        boolean bl = _tripleEquals = _operator == UnaryOperator.COMPLEMENT;
        if (_tripleEquals) {
            this.assertIsSubType(result1, this.getResultFor("integer"), String.format("Bitwise operator '%s' may only be applied on integer types, not on %s.", Character.valueOf(Character.valueOf('~').charValue()), result1));
        } else {
            this.assertIsSubType(result1, this.getResultFor("real"), String.format("Arithmetic operator '%s' may only be applied on numeric types, not on %s.", new Object[]{e.getOperator(), result1}));
        }
        return result1;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(PostFixUnaryExpression expression) {
        ITypeSystemInferrer.InferenceResult result = this.inferTypeDispatch((EObject)expression.getOperand());
        this.assertIsSubType(result, this.getResultFor("real"), null);
        return result;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(TypeCastExpression e) {
        ITypeSystemInferrer.InferenceResult result1 = this.inferTypeDispatch((EObject)e.getOperand());
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch((EObject)e.getTypeSpecifier());
        this.assertCompatible(result1, result2, String.format("Cannot cast from %s to %s.", result1, result2));
        return result2;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(IfExpression it) {
        boolean _tripleNotEquals;
        ITypeSystemInferrer.InferenceResult condition = this.inferTypeDispatch((EObject)it.getCondition());
        this.assertIsSubType(condition, this.getResultFor("boolean"), "conditional expression must be of type boolean.");
        Expression _else = it.getElse();
        boolean bl = _tripleNotEquals = _else != null;
        if (_tripleNotEquals) {
            ITypeSystemInferrer.InferenceResult thenResult = this.inferTypeDispatch((EObject)it.getThen());
            ITypeSystemInferrer.InferenceResult elseResult = this.inferTypeDispatch((EObject)it.getElse());
            if (this.registry.isVoid(thenResult.getType()) || this.registry.isVoid(elseResult.getType())) {
                return this.getResultFor("void");
            }
            this.assertCompatible(thenResult, elseResult, null);
            return this.getCommonType(thenResult, elseResult);
        }
        return this.getResultFor("void");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(SwitchExpression it) {
        boolean _tripleNotEquals;
        ITypeSystemInferrer.InferenceResult _xblockexpression = null;
        ITypeSystemInferrer.InferenceResult condition = this.inferTypeDispatch((EObject)it.getSwitch());
        Consumer<SwitchCase> _function = c -> {
            ITypeSystemInferrer.InferenceResult caseType = this.inferTypeDispatch((EObject)c.getCase());
            this.assertIsSubType(caseType, condition, null);
        };
        it.getCases().forEach(_function);
        Functions.Function1 _function_1 = it_1 -> this.inferTypeDispatch((EObject)it_1.getThen());
        Functions.Function2 _function_2 = (p1, p2) -> this.getCommonType((ITypeSystemInferrer.InferenceResult)p1, (ITypeSystemInferrer.InferenceResult)p2);
        ITypeSystemInferrer.InferenceResult result = (ITypeSystemInferrer.InferenceResult)IterableExtensions.reduce((Iterable)ListExtensions.map(it.getCases(), (Functions.Function1)_function_1), (Functions.Function2)_function_2);
        Expression _default = it.getDefault();
        boolean bl = _tripleNotEquals = _default != null;
        if (_tripleNotEquals) {
            ITypeSystemInferrer.InferenceResult defType = this.inferTypeDispatch((EObject)it.getDefault());
            return this.getCommonType(defType, result);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(BlockExpression it) {
        ITypeSystemInferrer.InferenceResult result = this.getResultFor("void");
        EList<Expression> expressions = it.getExpressions();
        for (Expression expression : expressions) {
            result = this.inferTypeDispatch((EObject)expression);
        }
        return result;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ReturnExpression exp) {
        boolean _tripleEquals;
        Expression _expression = exp.getExpression();
        boolean bl = _tripleEquals = _expression == null;
        if (_tripleEquals) {
            return this.getResultFor("void");
        }
        return this.inferTypeDispatch((EObject)exp.getExpression());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(EventRaisingExpression e) {
        boolean _tripleEquals;
        ITypeSystemInferrer.InferenceResult _resultFor;
        Event _xifexpression = null;
        EObject _featureOrReference = this.utils.featureOrReference(e.getEvent());
        if (_featureOrReference instanceof Event) {
            EObject _featureOrReference_1 = this.utils.featureOrReference(e.getEvent());
            _xifexpression = (Event)_featureOrReference_1;
        } else {
            _xifexpression = null;
        }
        Event event = _xifexpression;
        ITypeSystemInferrer.InferenceResult _xifexpression_1 = null;
        _xifexpression_1 = event != null ? this.inferTypeDispatch((EObject)event.getTypeSpecifier()) : null;
        ITypeSystemInferrer.InferenceResult eventType = _xifexpression_1;
        ITypeSystemInferrer.InferenceResult _elvis = null;
        _elvis = eventType != null ? eventType : (_resultFor = this.getResultFor("void"));
        eventType = _elvis;
        Expression _value = e.getValue();
        boolean bl = _tripleEquals = _value == null;
        if (_tripleEquals) {
            this.assertSame(eventType, this.getResultFor("void"), String.format(MISSING_VALUE, eventType));
            return this.getResultFor("void");
        }
        ITypeSystemInferrer.InferenceResult valueType = this.inferTypeDispatch((EObject)e.getValue());
        this.assertAssignable(eventType, valueType, String.format(EVENT_DEFINITION, valueType, eventType));
        return valueType;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(EventValueReferenceExpression e) {
        EObject definition = this.utils.featureOrReference(e.getValue());
        ITypeSystemInferrer.InferenceResult result = this.inferEventValue(definition);
        ITypeSystemInferrer.InferenceResult _xifexpression = null;
        _xifexpression = result != null ? result : this.inferTypeDispatch((EObject)e.getValue());
        return _xifexpression;
    }

    public ITypeSystemInferrer.InferenceResult inferEventValue(EObject declaration) {
        if (declaration != null && declaration instanceof Event) {
            Event event = (Event)declaration;
            ITypeSystemInferrer.InferenceResult _xifexpression = null;
            TypeSpecifier _typeSpecifier = event.getTypeSpecifier();
            boolean _tripleEquals = _typeSpecifier == null;
            _xifexpression = _tripleEquals ? this.getResultFor("void") : this.inferTypeDispatch((EObject)event.getTypeSpecifier());
            return _xifexpression;
        }
        return null;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(DeclarationExpression it) {
        return this.getResultFor("void");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(EnumerationType enumType) {
        return ITypeSystemInferrer.InferenceResult.from((Type)enumType);
    }

    public ITypeSystemInferrer.InferenceResult doInfer(Enumerator enumerator) {
        return ITypeSystemInferrer.InferenceResult.from((Type)((Type)EcoreUtil2.getContainerOfType((EObject)enumerator, Type.class)));
    }

    public ITypeSystemInferrer.InferenceResult doInfer(Type type) {
        return ITypeSystemInferrer.InferenceResult.from((Type)type.getOriginType());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(Package pkg) {
        return null;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(TypeAlias typeAlias) {
        return this.inferTypeDispatch((EObject)typeAlias.getTypeSpecifier());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(FeatureCall e) {
        ITypeSystemInferrer.InferenceResult result_1;
        boolean _isOperationCall;
        ITypeSystemInferrer.InferenceResult result;
        EObject feature = e.getFeature();
        Expression owner = e.getOwner();
        if (feature == null) {
            return this.getAnyType();
        }
        if (this._eventValueMetaFeature.isEventValueProperty(e.getFeature()) && owner != null && (result = this.inferEventValue(this.utils.featureOrReference(e.getOwner()))) != null) {
            return result;
        }
        HashMap inferredTypeParameterTypes = Maps.newHashMap();
        if (owner != null) {
            this.typeParameterInferrer.inferTypeParametersFromOwner(this.inferTypeDispatch((EObject)e.getOwner()), inferredTypeParameterTypes);
        }
        if (_isOperationCall = e.isOperationCall()) {
            boolean _not;
            boolean _eIsProxy = feature.eIsProxy();
            boolean bl = _not = !_eIsProxy;
            if (_not) {
                if (feature instanceof Operation) {
                    return this.inferOperation(e, (Operation)feature, inferredTypeParameterTypes);
                }
                this.error(String.format(ISSUE_MESSAGE_FEATURE_CALL_IS_NOT_AN_OPERATION_CALL, this.featureName(feature)), ISSUE_CODE_FEATURE_CALL_IS_NOT_AN_OPERATION_CALL);
            }
        }
        if ((result_1 = this.inferWithoutErrors(e.getFeature())) != null) {
            result_1 = this.typeParameterInferrer.buildInferenceResult(result_1, inferredTypeParameterTypes, this.acceptor);
        }
        if (result_1 == null) {
            return this.getAnyType();
        }
        boolean _and = false;
        boolean _isArrayAccess = e.isArrayAccess();
        if (!_isArrayAccess) {
            _and = false;
        } else {
            boolean _equals;
            Type _type = null;
            if (result_1 != null) {
                _type = result_1.getType();
            }
            String _name = _type.getName();
            _and = _equals = Objects.equals(_name, "array");
        }
        if (_and) {
            return this.getResult(result_1, e.getArraySelector().size());
        }
        return result_1;
    }

    protected String _featureName(EObject it) {
        return "";
    }

    protected String _featureName(NamedElement it) {
        return it.getName();
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ElementReferenceExpression e) {
        ITypeSystemInferrer.InferenceResult _xblockexpression = null;
        boolean _isOperationCall = e.isOperationCall();
        if (_isOperationCall) {
            if (e.getReference() != null && !e.getReference().eIsProxy()) {
                EObject _reference = e.getReference();
                return this.inferOperation(e, (Operation)_reference, Maps.newHashMap());
            }
            return this.getAnyType();
        }
        ITypeSystemInferrer.InferenceResult result = this.inferWithoutErrors(e.getReference());
        boolean _and = false;
        boolean _isArrayAccess = e.isArrayAccess();
        if (!_isArrayAccess) {
            _and = false;
        } else {
            boolean _isArray;
            Type _type = null;
            if (result != null) {
                _type = result.getType();
            }
            _and = _isArray = this.typeSystem.isArray(_type);
        }
        if (_and) {
            ITypeSystemInferrer.InferenceResult indexType = this.inferTypeDispatch((EObject)this._typesUtil.lastOrNull(e.getArraySelector()));
            this.assertAssignable(ITypeSystemInferrer.InferenceResult.from((Type)this.typeSystem.getType("integer")), indexType, String.format("Incompatible types %s and %s.", indexType, "integer"));
            return this.getResult(result, e.getArraySelector().size());
        }
        boolean _and_1 = false;
        boolean _isArrayAccess_1 = e.isArrayAccess();
        if (!_isArrayAccess_1) {
            _and_1 = false;
        } else {
            boolean _isMap;
            Type _type_1 = null;
            if (result != null) {
                _type_1 = result.getType();
            }
            _and_1 = _isMap = this.typeSystem.isMap(_type_1);
        }
        if (_and_1) {
            ITypeSystemInferrer.InferenceResult indexType_1 = this.inferTypeDispatch((EObject)this._typesUtil.lastOrNull(e.getArraySelector()));
            this.assertAssignable((ITypeSystemInferrer.InferenceResult)IterableExtensions.head((Iterable)result.getBindings()), indexType_1, String.format("Incompatible types %s and %s.", indexType_1, ((ITypeSystemInferrer.InferenceResult)IterableExtensions.head((Iterable)result.getBindings())).getType().getName()));
            return (ITypeSystemInferrer.InferenceResult)this._typesUtil.lastOrNull((Iterable)result.getBindings());
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    protected ITypeSystemInferrer.InferenceResult inferOperation(ArgumentExpression e, Operation op, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> typeParameterMapping) {
        List<ITypeSystemInferrer.InferenceResult> argumentTypes = this.getArgumentTypes((List<Expression>)e.getExpressions());
        EList parameters = op.getParameters();
        ArrayList<ITypeSystemInferrer.InferenceResult> argumentsToInfer = new ArrayList<ITypeSystemInferrer.InferenceResult>();
        ArrayList<TypedDeclaration> parametersToInfer = new ArrayList<TypedDeclaration>();
        int i = 0;
        while (i < parameters.size()) {
            boolean _not;
            boolean _containsKey = typeParameterMapping.containsKey(((Parameter)parameters.get(i)).getType());
            boolean bl = _not = !_containsKey;
            if (_not) {
                boolean _lessThan;
                parametersToInfer.add((TypedDeclaration)parameters.get(i));
                int _size = argumentTypes.size();
                boolean bl2 = _lessThan = i < _size;
                if (_lessThan) {
                    argumentsToInfer.add(argumentTypes.get(i));
                }
            }
            ++i;
        }
        this.typeParameterInferrer.inferTypeParametersFromOperationArguments(parametersToInfer, argumentsToInfer, typeParameterMapping, this.acceptor);
        this.validateParameters(typeParameterMapping, op, (List<Argument>)e.getArguments(), this.acceptor);
        return this.inferReturnType(e, op, typeParameterMapping);
    }

    protected ITypeSystemInferrer.InferenceResult getTargetType(ArgumentExpression exp) {
        ITypeSystemInferrer.InferenceResult result = this.getTargetTypeForAssignment(exp);
        if (result != null) {
            return result;
        }
        result = this.getTargetTypeForVariableInit(exp);
        if (result != null) {
            return result;
        }
        result = this.getTargetTypeForOperationArgument(exp);
        if (result != null) {
            return result;
        }
        return null;
    }

    protected ITypeSystemInferrer.InferenceResult getTargetTypeForAssignment(ArgumentExpression exp) {
        EObject container = exp.eContainer();
        if (container instanceof AssignmentExpression) {
            boolean _tripleEquals;
            AssignmentExpression assignment = (AssignmentExpression)container;
            Expression _expression = assignment.getExpression();
            boolean bl = _tripleEquals = _expression == exp;
            if (_tripleEquals) {
                Expression varRef = ((AssignmentExpression)container).getVarRef();
                return this.inferTypeDispatch((EObject)varRef);
            }
        }
        return null;
    }

    protected ITypeSystemInferrer.InferenceResult getTargetTypeForVariableInit(ArgumentExpression exp) {
        EObject container = exp.eContainer();
        if (container instanceof Property) {
            boolean _tripleEquals;
            Property property = (Property)container;
            Expression _initialValue = property.getInitialValue();
            boolean bl = _tripleEquals = _initialValue == exp;
            if (_tripleEquals) {
                return this.inferTypeDispatch((EObject)property.getTypeSpecifier());
            }
        }
        return null;
    }

    protected ITypeSystemInferrer.InferenceResult getTargetTypeForOperationArgument(ArgumentExpression exp) {
        EObject container = exp.eContainer();
        if (container instanceof Argument) {
            boolean _tripleEquals;
            Argument argument = (Argument)container;
            Expression _value = argument.getValue();
            boolean bl = _tripleEquals = _value == exp;
            if (_tripleEquals) {
                EObject _eContainer = argument.eContainer();
                ArgumentExpression argumentExpression = (ArgumentExpression)_eContainer;
                int index = argumentExpression.getExpressions().indexOf((Object)argument.getValue());
                EObject _featureOrReference = this.utils.featureOrReference(argumentExpression);
                Operation op = (Operation)_featureOrReference;
                Parameter param = (Parameter)op.getParameters().get(index);
                return this.inferTypeDispatch((EObject)param);
            }
        }
        return null;
    }

    protected List<ITypeSystemInferrer.InferenceResult> getArgumentTypes(List<Expression> args) {
        ArrayList<ITypeSystemInferrer.InferenceResult> argumentTypes = new ArrayList<ITypeSystemInferrer.InferenceResult>();
        for (Expression arg : args) {
            argumentTypes.add(this.inferTypeDispatch((EObject)arg));
        }
        return argumentTypes;
    }

    protected ITypeSystemInferrer.InferenceResult inferReturnType(ArgumentExpression e, Operation operation, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes) {
        Type type;
        ITypeSystemInferrer.InferenceResult returnType = this.inferTypeDispatch((EObject)operation);
        if (!(returnType == null || (type = returnType.getType()) instanceof TypeParameter || type instanceof GenericElement && !((GenericElement)type).getTypeParameters().isEmpty())) {
            return returnType;
        }
        this.inferByTargetType(e, operation, inferredTypeParameterTypes);
        returnType = this.typeParameterInferrer.buildInferenceResult(returnType, inferredTypeParameterTypes, this.acceptor);
        if (returnType == null) {
            return this.getAnyType();
        }
        return returnType;
    }

    private void inferByTargetType(ArgumentExpression e, Operation operation, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes) {
        ITypeSystemInferrer.InferenceResult targetType = this.getTargetType(e);
        if (targetType != null && targetType.getType() != null && !(targetType.getType() instanceof TypeParameter)) {
            this.typeParameterInferrer.inferTypeParametersFromTargetType(targetType, operation, inferredTypeParameterTypes, this.acceptor);
        }
    }

    protected ITypeSystemInferrer.InferenceResult getAnyType() {
        return ITypeSystemInferrer.InferenceResult.from((Type)this.registry.getType("any"));
    }

    public Map<TypeParameter, ITypeSystemInferrer.InferenceResult> validateParameters(Map<TypeParameter, ITypeSystemInferrer.InferenceResult> typeParameterMapping, Operation operation, List<Argument> args, IValidationIssueAcceptor acceptor) {
        ITypeSystemInferrer.InferenceResult argumentType;
        EList parameters = operation.getParameters();
        List argumentOrders = ArgumentSorter.getArgumentOrders(args, (List)parameters);
        int i = 0;
        while (i < parameters.size()) {
            int index = i;
            Functions.Function1 _function = it -> {
                int _order = it.getOrder();
                return _order == index;
            };
            ArgumentSorter.ArgumentOrder _findFirst = (ArgumentSorter.ArgumentOrder)IterableExtensions.findFirst((Iterable)argumentOrders, (Functions.Function1)_function);
            Argument _argument = null;
            if (_findFirst != null) {
                _argument = _findFirst.getArgument();
            }
            Expression _value = null;
            if (_argument != null) {
                _value = _argument.getValue();
            }
            Expression expression = _value;
            Parameter parameter = (Parameter)parameters.get(i);
            ITypeSystemInferrer.InferenceResult parameterType = this.inferTypeDispatch((EObject)parameter);
            argumentType = this.inferTypeDispatch((EObject)expression);
            parameterType = this.typeParameterInferrer.buildInferenceResult(parameterType, typeParameterMapping, acceptor);
            this.assertAssignable(parameterType, argumentType, String.format("Incompatible types %s and %s for parameter '%s'.", argumentType, parameterType, parameter.getName()));
            ++i;
        }
        if (operation.isVariadic() && args.size() - 1 >= operation.getVarArgIndex()) {
            EList expressions = ArgumentSorter.getOrderedExpressions(args, (List)parameters);
            Parameter parameter = (Parameter)operation.getParameters().get(operation.getVarArgIndex());
            int _varArgIndex = operation.getVarArgIndex();
            int _size = args.size();
            int _minus = _size - 1;
            List varArgs = expressions.subList(_varArgIndex, _minus);
            ITypeSystemInferrer.InferenceResult parameterType = this.inferTypeDispatch((EObject)parameter);
            for (Expression expression : varArgs) {
                parameterType = this.typeParameterInferrer.buildInferenceResult(parameterType, typeParameterMapping, acceptor);
                argumentType = this.inferTypeDispatch((EObject)expression);
                this.assertAssignable(parameterType, argumentType, String.format("Incompatible types %s and %s.", argumentType, parameterType));
            }
        }
        return typeParameterMapping;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ParenthesizedExpression e) {
        return this.inferTypeDispatch((EObject)e.getExpression());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(PrimitiveValueExpression e) {
        return this.inferTypeDispatch(e.getValue());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(BoolLiteral literal) {
        return this.getResultFor("boolean");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(IntLiteral literal) {
        return this.getResultFor("integer");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(HexLiteral literal) {
        return this.getResultFor("integer");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(DoubleLiteral literal) {
        return this.getResultFor("real");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(FloatLiteral literal) {
        return this.getResultFor("real");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(StringLiteral literal) {
        return this.getResultFor("string:literal");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(NullLiteral literal) {
        return this.getResultFor("null");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(Property e) {
        boolean _tripleEquals;
        ITypeSystemInferrer.InferenceResult result = this.inferTypeDispatch((EObject)e.getTypeSpecifier());
        this.assertNotType(result, "'void' is an invalid type for variables", new ITypeSystemInferrer.InferenceResult[]{this.getResultFor("void")});
        Expression _initialValue = e.getInitialValue();
        boolean bl = _tripleEquals = _initialValue == null;
        if (_tripleEquals) {
            return result;
        }
        ITypeSystemInferrer.InferenceResult result2 = this.inferTypeDispatch((EObject)e.getInitialValue());
        this.assertAssignable(result, result2, String.format("Cannot assign a value of type %s to a variable of type %s.", result2, result));
        return result;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(Operation e) {
        ITypeSystemInferrer.InferenceResult _xifexpression = null;
        TypeSpecifier _typeSpecifier = e.getTypeSpecifier();
        boolean _tripleEquals = _typeSpecifier == null;
        _xifexpression = _tripleEquals ? this.getResultFor("void") : this.inferTypeDispatch((EObject)e.getTypeSpecifier());
        return _xifexpression;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(Parameter e) {
        return this.inferTypeDispatch((EObject)e.getTypeSpecifier());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(TypeSpecifier specifier) {
        if (specifier.getType() instanceof GenericElement && ((GenericElement)specifier.getType()).getTypeParameters().size() > 0) {
            ArrayList<ITypeSystemInferrer.InferenceResult> bindings = new ArrayList<ITypeSystemInferrer.InferenceResult>();
            EList arguments = specifier.getTypeArguments();
            for (TypeSpecifier typeSpecifier : arguments) {
                ITypeSystemInferrer.InferenceResult binding = this.inferTypeDispatch((EObject)typeSpecifier);
                if (binding == null) continue;
                bindings.add(binding);
            }
            Type type = this.inferTypeDispatch((EObject)specifier.getType()).getType();
            boolean _isArray = this.typeSystem.isArray(type);
            if (_isArray) {
                int arraySize = 0;
                if (specifier instanceof ArrayTypeSpecifier) {
                    arraySize = ((ArrayTypeSpecifier)specifier).getSize();
                }
                return ITypeSystemInferrer.InferenceResult.from((Type)type, bindings, (int)arraySize);
            }
            boolean _isMap = this.typeSystem.isMap(type);
            if (_isMap) {
                return ITypeSystemInferrer.InferenceResult.from((Type)type, bindings);
            }
            return ITypeSystemInferrer.InferenceResult.from((Type)type, bindings);
        }
        return this.inferTypeDispatch((EObject)specifier.getType());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(Annotation ad) {
        this.validateParameters(CollectionLiterals.newHashMap(), (Operation)ad.getType(), (List<Argument>)ad.getArguments(), this.acceptor);
        return this.getResultFor("void");
    }

    protected void inferAnnotationProperty(AnnotationType type, EList<Argument> arguments) {
        int _size_1;
        boolean _tripleEquals;
        EList properties = type.getParameters();
        int _size = properties.size();
        boolean bl = _tripleEquals = _size == (_size_1 = arguments.size());
        if (_tripleEquals) {
            int i = 0;
            while (i < properties.size()) {
                ITypeSystemInferrer.InferenceResult type1 = this.inferTypeDispatch((EObject)properties.get(i));
                ITypeSystemInferrer.InferenceResult type2 = this.inferTypeDispatch((EObject)arguments.get(i));
                this.assertCompatible(type1, type2, String.format("Incompatible types %s and %s.", type1, type2));
                ++i;
            }
        }
    }

    public ITypeSystemInferrer.InferenceResult doInfer(InitializationExpression e) {
        ITypeSystemInferrer.InferenceResult targetResult = this.inferByContext((EObject)e, e.eContainer());
        if (targetResult == null) {
            return null;
        }
        Type targetType = targetResult.getType();
        boolean _isUndefined = this.typeSystem.isUndefined(targetType);
        if (_isUndefined) {
            this.error(ISSUE_MESSAGE_UNDEFINED_TYPE, "UndefinedType");
        } else {
            boolean _isArray = this.typeSystem.isArray(targetType);
            if (_isArray) {
                Functions.Function1 _function = it -> it.getValue();
                List expressions = ListExtensions.map(e.getArguments(), (Functions.Function1)_function);
                Consumer<Expression> _function_1 = exp -> {
                    ITypeSystemInferrer.InferenceResult argumentType = this.inferTypeDispatch((EObject)exp);
                    this.assertAssignable((ITypeSystemInferrer.InferenceResult)IterableExtensions.head((Iterable)targetResult.getBindings()), argumentType, String.format("Incompatible types %s and %s.", argumentType, IterableExtensions.head((Iterable)targetResult.getBindings())));
                };
                expressions.forEach(_function_1);
            } else {
                boolean _isMap = this.typeSystem.isMap(targetType);
                if (_isMap) {
                    Functions.Function1 _function_2 = it -> it.getKey();
                    List keys = ListExtensions.map(e.getArguments(), (Functions.Function1)_function_2);
                    Consumer<Expression> _function_3 = exp -> {
                        if (exp == null) {
                            this.error(ISSUE_MISSING_KEY_MSG, ISSUE_MISSING_KEY_CODE);
                            return;
                        }
                        ITypeSystemInferrer.InferenceResult argumentType = this.inferTypeDispatch((EObject)exp);
                        this.assertAssignable((ITypeSystemInferrer.InferenceResult)IterableExtensions.head((Iterable)targetResult.getBindings()), argumentType, String.format("Incompatible types %s and %s.", argumentType, IterableExtensions.head((Iterable)targetResult.getBindings())));
                    };
                    keys.forEach(_function_3);
                    Functions.Function1 _function_4 = it -> it.getValue();
                    List values = ListExtensions.map(e.getArguments(), (Functions.Function1)_function_4);
                    Consumer<Expression> _function_5 = exp -> {
                        ITypeSystemInferrer.InferenceResult argumentType = this.inferTypeDispatch((EObject)exp);
                        this.assertAssignable((ITypeSystemInferrer.InferenceResult)this._typesUtil.lastOrNull((Iterable)targetResult.getBindings()), argumentType, String.format("Incompatible types %s and %s.", argumentType, this._typesUtil.lastOrNull((Iterable)targetResult.getBindings())));
                    };
                    values.forEach(_function_5);
                } else if (targetType instanceof ComplexType) {
                    int _size_3;
                    int _size_2;
                    boolean _lessThan;
                    int _size_1;
                    boolean _greaterThan;
                    List<Property> initFeatures = this.initializableFeatures((ComplexType)targetType);
                    EList expressions_1 = ArgumentSorter.getOrderedExpressions(e.getArguments(), initFeatures);
                    int i = 0;
                    while (i < initFeatures.size()) {
                        int _size = expressions_1.size();
                        boolean bl = _greaterThan = _size > i;
                        if (_greaterThan) {
                            ITypeSystemInferrer.InferenceResult parameterType = this.inferTypeDispatch((EObject)((ComplexType)targetType).getAllFeatures().get(i));
                            ITypeSystemInferrer.InferenceResult argumentType = this.inferTypeDispatch((EObject)expressions_1.get(i));
                            this.assertAssignable(parameterType, argumentType, String.format("Incompatible types %s and %s.", argumentType, parameterType));
                        }
                        ++i;
                    }
                    int _size = initFeatures.size();
                    boolean bl = _greaterThan = _size > (_size_1 = expressions_1.size());
                    if (_greaterThan) {
                        this.error(String.format(ISSUE_MESSAGE_MISSING_INITIALIZATION_ARGUMENT, initFeatures.size(), expressions_1.size(), ((ComplexType)targetType).getName()), ISSUE_CODE_MISSING_INITIALIZATION_ARGUMENT);
                    }
                    boolean bl2 = _lessThan = (_size_2 = initFeatures.size()) < (_size_3 = expressions_1.size());
                    if (_lessThan) {
                        this.error(String.format(ISSUE_MESSAGE_SURPLUS_INITIALIZATION_ARGUMENT, initFeatures.size(), expressions_1.size(), ((ComplexType)targetType).getName()), ISSUE_CODE_SURPLUS_INITIALIZATION_ARGUMENT);
                    }
                } else {
                    this.error(String.format(ISSUE_MESSAGE_INITIALIZATION_UNSUPPORTED_TYPE, targetType.getName()), ISSUE_CODE_INITIALIZATION_UNSUPPORTED_TYPE);
                }
            }
        }
        return targetResult;
    }

    protected ITypeSystemInferrer.InferenceResult _inferByContext(EObject e, EObject context) {
        return this.getResultFor("__undefined__");
    }

    protected ITypeSystemInferrer.InferenceResult _inferByContext(InitializationExpression e, AssignmentExpression context) {
        return this.inferTypeDispatch((EObject)context.getVarRef());
    }

    protected ITypeSystemInferrer.InferenceResult _inferByContext(InitializationExpression e, EventRaisingExpression context) {
        ITypeSystemInferrer.InferenceResult result = this.inferEventValue(this.utils.featureOrReference(context.getEvent()));
        ITypeSystemInferrer.InferenceResult _xifexpression = null;
        _xifexpression = result != null ? result : this.getResultFor("__undefined__");
        return _xifexpression;
    }

    protected ITypeSystemInferrer.InferenceResult _inferByContext(InitializationExpression e, Argument argument) {
        ITypeSystemInferrer.InferenceResult _xifexpression = null;
        TypedDeclaration _parameter = argument.getParameter();
        boolean _tripleNotEquals = _parameter != null;
        _xifexpression = _tripleNotEquals ? this.inferTypeDispatch((EObject)argument.getParameter().getType()) : this.inferByContext((EObject)argument, argument.eContainer());
        ITypeSystemInferrer.InferenceResult result = _xifexpression;
        ITypeSystemInferrer.InferenceResult _xifexpression_1 = null;
        _xifexpression_1 = result != null ? result : this.getResultFor("__undefined__");
        return _xifexpression_1;
    }

    protected ITypeSystemInferrer.InferenceResult _inferByContext(InitializationExpression e, Property context) {
        return this.inferTypeDispatch((EObject)context);
    }

    protected ITypeSystemInferrer.InferenceResult _inferByContext(Argument e, ArgumentExpression context) {
        ITypeSystemInferrer.InferenceResult _xblockexpression = null;
        TypedDeclaration param = this.parameterForArgument(e);
        ITypeSystemInferrer.InferenceResult _xifexpression = null;
        _xifexpression = param != null ? this.inferTypeDispatch((EObject)this.parameterForArgument(e).getTypeSpecifier()) : this.getResultFor("__undefined__");
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ITypeSystemInferrer.InferenceResult _inferByContext(Argument e, InitializationExpression context) {
        boolean _isMap;
        ITypeSystemInferrer.InferenceResult _xblockexpression = null;
        ITypeSystemInferrer.InferenceResult argumentResult = this.inferByContext((EObject)context, context.eContainer());
        Type contextType = argumentResult.getType();
        ITypeSystemInferrer.InferenceResult _switchResult = null;
        boolean _matched = false;
        boolean _isArray = this.typeSystem.isArray(contextType);
        if (_isArray) {
            _matched = true;
            _switchResult = (ITypeSystemInferrer.InferenceResult)IterableExtensions.head((Iterable)argumentResult.getBindings());
        }
        if (!_matched && (_isMap = this.typeSystem.isMap(contextType))) {
            _matched = true;
            _switchResult = (ITypeSystemInferrer.InferenceResult)this._typesUtil.lastOrNull((Iterable)argumentResult.getBindings());
        }
        if (!_matched && contextType instanceof ComplexType) {
            int _size;
            boolean _lessThan;
            int _indexOf = context.getArguments().indexOf((Object)e);
            boolean bl = _lessThan = _indexOf < (_size = this.initializableFeatures((ComplexType)contextType).size());
            if (_lessThan) {
                _matched = true;
                _switchResult = this.inferTypeDispatch((EObject)this.initializableFeatures((ComplexType)contextType).get(context.getArguments().indexOf((Object)e)));
            }
        }
        if (!_matched) {
            _switchResult = this.getResultFor("__undefined__");
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected ITypeSystemInferrer.InferenceResult _inferByContext(InitializationExpression e, ReturnExpression context) {
        return this.inferTypeDispatch((EObject)((Operation)IterableExtensions.head((Iterable)Iterables.filter((Iterable)EcoreUtil2.getAllContainers((EObject)context), Operation.class))).getTypeSpecifier());
    }

    protected ITypeSystemInferrer.InferenceResult _inferByContext(InitializationExpression e, Expression context) {
        return this.inferTypeDispatch((EObject)context);
    }

    protected List<Property> initializableFeatures(ComplexType it) {
        return IterableExtensions.toList((Iterable)Iterables.filter((Iterable)it.getAllFeatures(), Property.class));
    }

    protected ITypeSystemInferrer.InferenceResult getResult(ITypeSystemInferrer.InferenceResult result, int i) {
        if (i == 1) {
            return (ITypeSystemInferrer.InferenceResult)IterableExtensions.head((Iterable)result.getBindings());
        }
        int j = i - 1;
        return this.getResult((ITypeSystemInferrer.InferenceResult)IterableExtensions.head((Iterable)result.getBindings()), j);
    }

    protected ITypeSystemInferrer.InferenceResult inferWithoutErrors(EObject obj) {
        ITypeSystemInferrer.InferenceResult _xblockexpression = null;
        IValidationIssueAcceptor tmp = this.acceptor;
        ITypeSystemInferrer.InferenceResult _xtrycatchfinallyexpression = null;
        try {
            ITypeSystemInferrer.InferenceResult result;
            ITypeSystemInferrer.InferenceResult _xblockexpression_1 = null;
            IValidationIssueAcceptor.ListBasedValidationIssueAcceptor _listBasedValidationIssueAcceptor = new IValidationIssueAcceptor.ListBasedValidationIssueAcceptor();
            this.acceptor = _listBasedValidationIssueAcceptor;
            _xtrycatchfinallyexpression = _xblockexpression_1 = (result = this.inferTypeDispatch(obj));
        }
        finally {
            this.acceptor = tmp;
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    @XbaseGenerated
    protected String featureName(EObject it) {
        if (it instanceof NamedElement) {
            return this._featureName((NamedElement)it);
        }
        if (it != null) {
            return this._featureName(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public ITypeSystemInferrer.InferenceResult inferByContext(EObject e, EObject context) {
        if (e instanceof InitializationExpression && context instanceof Property) {
            return this._inferByContext((InitializationExpression)e, (Property)context);
        }
        if (e instanceof InitializationExpression && context instanceof AssignmentExpression) {
            return this._inferByContext((InitializationExpression)e, (AssignmentExpression)context);
        }
        if (e instanceof InitializationExpression && context instanceof EventRaisingExpression) {
            return this._inferByContext((InitializationExpression)e, (EventRaisingExpression)context);
        }
        if (e instanceof InitializationExpression && context instanceof ReturnExpression) {
            return this._inferByContext((InitializationExpression)e, (ReturnExpression)context);
        }
        if (e instanceof InitializationExpression && context instanceof Argument) {
            return this._inferByContext((InitializationExpression)e, (Argument)context);
        }
        if (e instanceof InitializationExpression && context instanceof Expression) {
            return this._inferByContext((InitializationExpression)e, (Expression)context);
        }
        if (e instanceof Argument && context instanceof ArgumentExpression) {
            return this._inferByContext((Argument)e, (ArgumentExpression)context);
        }
        if (e instanceof Argument && context instanceof InitializationExpression) {
            return this._inferByContext((Argument)e, (InitializationExpression)context);
        }
        if (e != null && context != null) {
            return this._inferByContext(e, context);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e, context).toString());
    }
}

