/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.linking;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.linking.OperationOverloadingResolver;
import com.yakindu.base.expressions.util.ExpressionExtensions;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.TypesPackage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;

public class ArgumentLinkingService
extends DefaultLinkingService {
    @Inject
    @Extension
    protected IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    @Extension
    protected OperationOverloadingResolver operationsLinker;
    @Inject
    @Extension
    protected ExpressionExtensions utils;

    public List<EObject> getLinkedObjects(EObject context, EReference ref, INode node) throws IllegalNodeException {
        if (context instanceof ArgumentExpression && this.isOperationCall(context)) {
            return this.getLinkedOperation((ArgumentExpression)context, ref, node);
        }
        return super.getLinkedObjects(context, ref, node);
    }

    public List<EObject> getLinkedOperation(ArgumentExpression context, EReference ref, INode node) {
        QualifiedName qualifiedLinkName;
        EClass requiredType = ref.getEReferenceType();
        if (requiredType == null) {
            return Collections.emptyList();
        }
        String crossRefString = this.getCrossRefNodeAsString(node);
        if (crossRefString == null || crossRefString.equals("")) {
            return Collections.emptyList();
        }
        IScope scope = this.getScope((EObject)context, ref);
        Iterable eObjectDescription = scope.getElements(qualifiedLinkName = this.qualifiedNameConverter.toQualifiedName(crossRefString));
        int size = Iterables.size((Iterable)eObjectDescription);
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            return Collections.singletonList(((IEObjectDescription)Iterables.getFirst((Iterable)eObjectDescription, null)).getEObjectOrProxy());
        }
        ArrayList candidates = CollectionLiterals.newArrayList();
        for (IEObjectDescription currentDescription : eObjectDescription) {
            boolean _isSuperTypeOf = TypesPackage.Literals.OPERATION.isSuperTypeOf(currentDescription.getEClass());
            if (!_isSuperTypeOf) continue;
            candidates.add(currentDescription);
        }
        Optional<Operation> operation = this.operationsLinker.linkOperation(candidates, context);
        boolean _isPresent = operation.isPresent();
        if (_isPresent) {
            return Collections.singletonList((EObject)operation.get());
        }
        return Collections.singletonList(((IEObjectDescription)Iterables.getFirst((Iterable)eObjectDescription, null)).getEObjectOrProxy());
    }

    protected boolean isOperationCall(EObject context) {
        if (context instanceof ElementReferenceExpression) {
            return ((ElementReferenceExpression)context).isOperationCall();
        }
        if (context instanceof FeatureCall) {
            return ((FeatureCall)context).isOperationCall();
        }
        return false;
    }
}

