/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.validation;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.BlockExpression;
import com.yakindu.base.expressions.expressions.IfExpression;
import com.yakindu.base.expressions.expressions.ReturnExpression;
import com.yakindu.base.expressions.expressions.SwitchExpression;
import com.yakindu.base.expressions.validation.ExpressionsBaseValidator;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypesUtil;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.base.types.validation.IValidationIssueAcceptor;
import com.yakindu.base.types.validation.TypeValidator;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class ReturnValidator
extends ExpressionsBaseValidator {
    @Inject
    private ITypeSystemInferrer inferrer;
    @Inject
    private TypeValidator typeValidator;
    @Inject
    private ITypeSystem typeSystem;
    public static final String UNREACHABLE_CODE_MSG = "Unreachable expression.";
    public static final String UNREACHABLE_CODE_CODE = "UnreachableExpression";
    @Inject
    @Extension
    protected TypesUtil _typesUtil;
    public static final String RETURN_MISSING_MSG = "The operation must return a result of type %s";
    public static final String RETURN_MISSING_CODE = "ReturnMissing";

    @Check
    public void checkUnreachableCode(ReturnExpression it) {
        EObject _eContainer = it.eContainer();
        if (_eContainer instanceof BlockExpression) {
            int _size;
            int _minus;
            boolean _lessThan;
            EObject _eContainer_1 = it.eContainer();
            BlockExpression block = (BlockExpression)_eContainer_1;
            int index = block.getExpressions().indexOf((Object)it);
            boolean bl = _lessThan = index < (_minus = (_size = block.getExpressions().size()) - 1);
            if (_lessThan) {
                this.error(UNREACHABLE_CODE_MSG, (EObject)block.getExpressions().get(index + 1), null, UNREACHABLE_CODE_CODE, new String[0]);
            }
        }
    }

    @Check
    public void checkReturnTypesCompatible(Operation it) {
        ITypeSystemInferrer.InferenceResult operationType = this.inferrer.infer((EObject)it);
        UnmodifiableIterator returnExpressions = Iterators.filter((Iterator)it.eAllContents(), ReturnExpression.class);
        Functions.Function1 _function = ex -> this.inferrer.infer((EObject)ex);
        Procedures.Procedure1 _function_1 = rT -> this.typeValidator.assertAssignable(operationType, rT, null, (IValidationIssueAcceptor)this);
        IteratorExtensions.forEach((Iterator)IteratorExtensions.map((Iterator)returnExpressions, (Functions.Function1)_function), (Procedures.Procedure1)_function_1);
    }

    @Check
    public void checkMissingReturn(Operation it) {
        boolean _not;
        boolean _tripleEquals;
        Expression _implementation = it.getImplementation();
        boolean bl = _tripleEquals = _implementation == null;
        if (_tripleEquals) {
            return;
        }
        ITypeSystemInferrer.InferenceResult operationType = this.inferrer.infer((EObject)it);
        boolean _isVoid = this.typeSystem.isVoid(operationType.getType());
        boolean bl2 = _not = !_isVoid;
        if (_not) {
            boolean _not_1;
            boolean _returns = this.returns(it.getImplementation());
            boolean bl3 = _not_1 = !_returns;
            if (_not_1) {
                Type _type = null;
                if (it != null) {
                    _type = it.getType();
                }
                this.error(String.format(RETURN_MISSING_MSG, _type.getName()), (EObject)it, null, RETURN_MISSING_CODE, new String[0]);
            }
        }
    }

    protected boolean _returns(BlockExpression it) {
        boolean _xifexpression = false;
        boolean _isEmpty = it.getExpressions().isEmpty();
        _xifexpression = _isEmpty ? false : this.returns((Expression)this._typesUtil.lastOrNull(it.getExpressions()));
        return _xifexpression;
    }

    protected boolean _returns(IfExpression it) {
        return this.returns(it.getThen()) && it.getElse() != null && this.returns(it.getElse());
    }

    protected boolean _returns(SwitchExpression it) {
        return IterableExtensions.forall(it.getCases(), it_1 -> this.returns(it_1.getThen())) && this.returns(it.getDefault());
    }

    protected boolean _returns(ReturnExpression it) {
        return true;
    }

    protected boolean _returns(Expression it) {
        return false;
    }

    @XbaseGenerated
    protected boolean returns(Expression it) {
        if (it instanceof BlockExpression) {
            return this._returns((BlockExpression)it);
        }
        if (it instanceof IfExpression) {
            return this._returns((IfExpression)it);
        }
        if (it instanceof ReturnExpression) {
            return this._returns((ReturnExpression)it);
        }
        if (it instanceof SwitchExpression) {
            return this._returns((SwitchExpression)it);
        }
        if (it != null) {
            return this._returns(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

