/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.graphics.Image;

public class ImageFigureEx
extends Figure {
    private Image img;
    private Dimension imgSize = new Dimension();
    private int alignment;

    public ImageFigureEx() {
        this(null, 2);
    }

    public ImageFigureEx(Image image) {
        this(image, 2);
    }

    public ImageFigureEx(Image image, int alignment) {
        this.setImage(image);
        this.setAlignment(alignment);
    }

    public Image getImage() {
        return this.img;
    }

    private Dimension getImageSize() {
        if (this.imgSize.isEmpty() && this.getImage() != null) {
            org.eclipse.swt.graphics.Rectangle r = this.getImage().getBounds();
            IMapMode mm = MapModeUtil.getMapMode((IFigure)this);
            this.imgSize = new Dimension(mm.DPtoLP(r.width), mm.DPtoLP(r.height));
        }
        if (!this.imgSize.isEmpty()) {
            return this.imgSize;
        }
        return this.getBounds().getSize();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return this.getImageSize();
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.getImage() == null) {
            return;
        }
        Rectangle area = this.getClientArea();
        Dimension size = this.getImageSize();
        graphics.drawImage(this.getImage(), switch (this.alignment & 0x18) {
            case 16 -> area.x + area.width - size.width;
            case 8 -> area.x;
            default -> (area.width - size.width) / 2 + area.x;
        }, switch (this.alignment & 5) {
            case 1 -> area.y;
            case 4 -> area.y + area.height - size.height;
            default -> (area.height - size.height) / 2 + area.y;
        });
    }

    public void setAlignment(int flag) {
        this.alignment = flag;
    }

    public void setImage(Image image) {
        if (this.img == image) {
            return;
        }
        this.img = image;
        this.imgSize = new Dimension();
        this.revalidate();
        this.repaint();
    }
}

