/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.search.core.filter;

import com.google.common.base.Function;
import com.yakindu.sct.search.core.Marker;
import com.yakindu.sct.search.core.ModelSearchResultEntry;
import com.yakindu.sct.search.core.SearchEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class TransformFunction
implements Function<List<SearchEntry>, List<ModelSearchResultEntry>> {
    private EObject parent;

    public TransformFunction(EObject parent) {
        this.parent = parent;
    }

    public List<ModelSearchResultEntry> apply(List<SearchEntry> input) {
        ArrayList<ModelSearchResultEntry> returnList = new ArrayList<ModelSearchResultEntry>();
        for (SearchEntry node : input) {
            if (node.getMarker().size() == 0) {
                returnList.add(new ModelSearchResultEntry(this.parent, node.getReference()));
                continue;
            }
            if (!(node.getReference() instanceof EAttribute)) continue;
            List<Marker> marker = node.getMarker();
            Object eGet = this.parent.eGet((EStructuralFeature)node.getReference());
            if (!(eGet instanceof String)) continue;
            String featureText = (String)eGet;
            int startpos = 0;
            int newLinePos = -1;
            if (marker.size() > 0) {
                newLinePos = featureText.indexOf(10, marker.get(0).getEndMarker());
            }
            if (newLinePos == -1) {
                newLinePos = featureText.length();
            }
            ModelSearchResultEntry entry = null;
            Iterator<Marker> iterator = marker.iterator();
            while (iterator.hasNext()) {
                Marker marker2 = iterator.next();
                if (entry == null) {
                    entry = new ModelSearchResultEntry(this.parent, node.getReference());
                    startpos = marker2.getStartMarker();
                    entry.addMarker(marker2);
                    if (iterator.hasNext()) continue;
                    returnList.add(entry);
                    continue;
                }
                if (marker2.getEndMarker() - startpos < 120 && marker2.getStartMarker() < newLinePos) {
                    entry.addMarker(marker2);
                    if (iterator.hasNext()) continue;
                    returnList.add(entry);
                    continue;
                }
                returnList.add(entry);
                entry = new ModelSearchResultEntry(this.parent, node.getReference());
                entry.addMarker(marker2);
                if (!iterator.hasNext()) {
                    returnList.add(entry);
                }
                startpos = marker2.getEndMarker();
                if (marker2.getStartMarker() < newLinePos || (newLinePos = featureText.indexOf(10, newLinePos + 1)) != -1) continue;
                newLinePos = featureText.length();
            }
        }
        return returnList;
    }
}

