/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.genmodel.validation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.yakindu.base.base.DomainElement;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.base.types.validation.IValidationIssueAcceptor;
import com.yakindu.base.types.validation.TypeValidator;
import com.yakindu.sct.commons.EmfUriUtil;
import com.yakindu.sct.commons.ErrorCodeStatus;
import com.yakindu.sct.commons.PathHelper;
import com.yakindu.sct.generator.core.extensions.GeneratorExtensions;
import com.yakindu.sct.generator.core.extensions.IGeneratorDescriptor;
import com.yakindu.sct.generator.core.extensions.ILibraryDescriptor;
import com.yakindu.sct.generator.core.extensions.LibraryExtensions;
import com.yakindu.sct.generator.core.library.IDefaultFeatureValueProvider;
import com.yakindu.sct.generator.genmodel.validation.AbstractSGenValidator;
import com.yakindu.sct.model.sgen.FeatureConfiguration;
import com.yakindu.sct.model.sgen.FeatureParameter;
import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.FeatureType;
import com.yakindu.sct.model.sgen.FeatureTypeLibrary;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgen.GeneratorModel;
import com.yakindu.sct.model.sgen.SGenPackage;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.validation.Check;

public class SGenJavaValidator
extends AbstractSGenValidator {
    public static final String MISSING_REQUIRED_PARAMETER = "Missing required parameter.";
    public static final String MISSING_REQUIRED_FEATURE = "Missing required feature.";
    public static final String DUPLICATE_PARAMETER = "Duplicate parameter.";
    public static final String DUPLICATE_FEATURE = "Duplicate feature.";
    public static final String UNKOWN_GENERATOR = "Unknown generator.";
    public static final String DEPRECATED_GENERATOR = "The generator %s is deprecated. Please use %s instead.";
    public static final String UNKNOWN_CONTENT_TYPE = "Unknown content type '";
    public static final String DEPRECATED = "Element '%s' is deprecated and will be removed in the next version. ";
    public static final String EMPTY_SGEN = ".sgen file does not contain any entries.";
    public static final String INVALID_DOMAIN_ID = "This generator can not be used for domain %s. Valid domains are %s";
    public static final String DUPLICATE_ELEMENT = "The %s '%s' exists multiple times. Please rename or remove duplicates: %s";
    public static final String CODE_REQUIRED_FEATURE = "code_req_feature";
    public static final String CODE_REQUIRED_DOMAIN = "code_req_domain";
    @Inject
    private Injector injector;
    @Inject
    private ITypeSystemInferrer inferrer;
    @Inject
    protected TypeValidator typeValidator;
    @Inject
    protected ITypeSystem typesystem;
    @Inject
    protected IScopeProvider scopeProvider;
    @Inject
    protected IQualifiedNameProvider nameProvider;
    @Inject
    protected PathHelper pathHelper;

    @Check
    public void checkInitialValue(Property property) {
        if (property.getType() == null || property.getType().eIsProxy()) {
            return;
        }
        ITypeSystemInferrer.InferenceResult expressionResult = this.inferrer.infer((EObject)property.getInitialValue(), (IValidationIssueAcceptor)this);
        this.typeValidator.assertAssignable(ITypeSystemInferrer.InferenceResult.from((Type)property.getType()), expressionResult, null, (IValidationIssueAcceptor)this);
    }

    @Check
    public void checkKeyword(GeneratorEntry entry) {
        GeneratorModel generatorModel = (GeneratorModel)EcoreUtil2.getContainerOfType((EObject)entry, GeneratorModel.class);
        Optional descriptor = GeneratorExtensions.getGeneratorDescriptor((String)generatorModel.getGeneratorId());
        if (!descriptor.isPresent()) {
            return;
        }
        String keyword = entry.getKeyword();
        if (keyword == null || keyword.trim().length() == 0) {
            return;
        }
        if (!keyword.equals(((IGeneratorDescriptor)descriptor.get()).getKeyword())) {
            this.error(UNKNOWN_CONTENT_TYPE + keyword + "'", (EStructuralFeature)SGenPackage.Literals.GENERATOR_ENTRY__KEYWORD);
        }
    }

    @Check
    public void checkDuplicateElementRef(GeneratorEntry entry) {
        EObject elementRef = entry.getElementRef();
        if (elementRef == null) {
            return;
        }
        QualifiedName elementName = this.nameProvider.getFullyQualifiedName(elementRef);
        if (elementName == null) {
            return;
        }
        IScope scope = this.scopeProvider.getScope((EObject)entry, SGenPackage.Literals.GENERATOR_ENTRY__ELEMENT_REF);
        Iterable duplicateNames = Iterables.filter((Iterable)scope.getAllElements(), e -> elementName.equals((Object)e.getQualifiedName()));
        Iterable duplicatePaths = Iterables.transform((Iterable)duplicateNames, e -> this.pathHelper.toPath((IResource)EmfUriUtil.toFile((URI)e.getEObjectURI()), new LinkOption[0]).toString());
        HashSet uniquePaths = Sets.newHashSet((Iterable)duplicatePaths);
        if (uniquePaths.size() > 1) {
            this.warning(String.format(DUPLICATE_ELEMENT, entry.getKeyword(), elementName, System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), uniquePaths)), (EStructuralFeature)SGenPackage.Literals.GENERATOR_ENTRY__ELEMENT_REF);
        }
    }

    @Check
    public void checkParameterValueType(FeatureParameterValue parameterValue) {
        if (parameterValue == null || parameterValue.getExpression() == null) {
            return;
        }
        ITypeSystemInferrer.InferenceResult valueResult = this.inferrer.infer((EObject)parameterValue.getExpression());
        Type parameterType = parameterValue.getParameter().getParameterType();
        if (parameterType != null) {
            this.typeValidator.assertAssignable(ITypeSystemInferrer.InferenceResult.from((Type)parameterType), valueResult, null, (IValidationIssueAcceptor)this);
        }
    }

    @Check
    public void checkParameterValue(FeatureParameterValue value) {
        if (value.getExpression() == null || value.getExpression() == null) {
            return;
        }
        GeneratorModel model = (GeneratorModel)EcoreUtil2.getRootContainer((EObject)value);
        Optional generatorDescriptor = GeneratorExtensions.getGeneratorDescriptor((String)model.getGeneratorId());
        if (!generatorDescriptor.isPresent()) {
            return;
        }
        IDefaultFeatureValueProvider provider = LibraryExtensions.getDefaultFeatureValueProvider((String)((IGeneratorDescriptor)generatorDescriptor.get()).getLibraryID(), (FeatureTypeLibrary)value.getParameter().getFeatureType().getLibrary());
        this.injector.injectMembers((Object)provider);
        IStatus status = provider.validateParameterValue(value);
        this.createMarker(status, (EStructuralFeature)SGenPackage.Literals.FEATURE_PARAMETER_VALUE__EXPRESSION);
    }

    @Check
    public void checkGeneratorExists(GeneratorModel model) {
        String generatorId = model.getGeneratorId();
        Optional descriptor = GeneratorExtensions.getGeneratorDescriptor((String)model.getGeneratorId());
        if (!descriptor.isPresent()) {
            this.error(String.format("Unknown generator. %s!", generatorId), (EStructuralFeature)SGenPackage.Literals.GENERATOR_MODEL__GENERATOR_ID);
            return;
        }
        IGeneratorDescriptor currentDescriptor = (IGeneratorDescriptor)descriptor.get();
        if (currentDescriptor.isDeprecated()) {
            this.warning(String.format(DEPRECATED_GENERATOR, generatorId, currentDescriptor.getPrimaryGeneratorId()), (EStructuralFeature)SGenPackage.Literals.GENERATOR_MODEL__GENERATOR_ID);
            return;
        }
    }

    @Check
    public void checkEntriesExist(GeneratorModel model) {
        if (model.getEntries() == null || model.getEntries().isEmpty()) {
            this.warning(EMPTY_SGEN, null);
        }
    }

    @Check
    public void checkDuplicateGeneratorEntryFeature(final FeatureConfiguration config) {
        GeneratorEntry entry = (GeneratorEntry)config.eContainer();
        Iterable filter = Iterables.filter((Iterable)entry.getFeatures(), (Predicate)new Predicate<FeatureConfiguration>(){

            public boolean apply(FeatureConfiguration input) {
                return input.getType().getName().equals(config.getType().getName());
            }
        });
        if (Iterables.size((Iterable)filter) > 1) {
            this.error(DUPLICATE_FEATURE, (EStructuralFeature)SGenPackage.Literals.FEATURE_CONFIGURATION__TYPE);
        }
    }

    @Check
    public void checkDuplicateFeatureParameter(final FeatureParameterValue value) {
        FeatureConfiguration entry = (FeatureConfiguration)value.eContainer();
        Iterable filter = Iterables.filter((Iterable)entry.getParameterValues(), (Predicate)new Predicate<FeatureParameterValue>(){

            public boolean apply(FeatureParameterValue input) {
                return input.getParameter().getName().equals(value.getParameter().getName());
            }
        });
        if (Iterables.size((Iterable)filter) > 1) {
            this.error(DUPLICATE_PARAMETER, (EStructuralFeature)SGenPackage.Literals.FEATURE_PARAMETER_VALUE__PARAMETER);
        }
    }

    @Check
    public void checkRequiredFeatures(GeneratorEntry entry) {
        GeneratorModel model = (GeneratorModel)EcoreUtil2.getRootContainer((EObject)entry);
        Optional generatorDescriptor = GeneratorExtensions.getGeneratorDescriptor((String)model.getGeneratorId());
        if (!generatorDescriptor.isPresent()) {
            return;
        }
        ILibraryDescriptor libraryDescriptors = LibraryExtensions.getLibraryDescriptor((String)((IGeneratorDescriptor)generatorDescriptor.get()).getLibraryID());
        Iterable requiredFeatures = Iterables.filter((Iterable)libraryDescriptors.getFeatureTypeLibrary().getTypes(), SGenJavaValidator.isRequired());
        ArrayList configuredTypes = Lists.newArrayList();
        for (FeatureConfiguration featureConfiguration : entry.getFeatures()) {
            configuredTypes.add(featureConfiguration.getType().getName());
        }
        for (FeatureType featureType : requiredFeatures) {
            if (configuredTypes.contains(featureType.getName())) continue;
            this.error(String.format("Missing required feature. %s", featureType.getName()), (EStructuralFeature)SGenPackage.Literals.GENERATOR_ENTRY__ELEMENT_REF, CODE_REQUIRED_FEATURE, new String[]{featureType.getName()});
        }
    }

    @Check
    public void checkDomainCompatibility(GeneratorModel model) {
        Optional generatorDescriptor = GeneratorExtensions.getGeneratorDescriptor((String)model.getGeneratorId());
        if (!generatorDescriptor.isPresent()) {
            return;
        }
        Set validDomains = ((IGeneratorDescriptor)generatorDescriptor.get()).getValidDomains();
        EList entries = model.getEntries();
        for (GeneratorEntry generatorEntry : entries) {
            EObject reference = generatorEntry.getElementRef();
            if (!(reference instanceof DomainElement)) continue;
            String domainID = ((DomainElement)reference).getDomainID();
            if (validDomains.isEmpty() || validDomains.contains(domainID)) continue;
            this.error(String.format(INVALID_DOMAIN_ID, domainID, Arrays.toString(validDomains.toArray())), (EObject)generatorEntry, (EStructuralFeature)SGenPackage.Literals.GENERATOR_ENTRY__ELEMENT_REF, CODE_REQUIRED_DOMAIN, new String[]{String.join((CharSequence)",", validDomains)});
        }
    }

    @Check
    public void checkDeprecatedParameters(FeatureParameterValue value) {
        if (value.getParameter().isDeprecated()) {
            Object warning = String.format(DEPRECATED, value.getParameter().getName());
            if (value.getParameter().getComment() != null) {
                warning = (String)warning + value.getParameter().getComment();
            }
            this.warning((String)warning, (EObject)value, null);
        }
    }

    @Check
    public void checkFeatureConfiguration(FeatureConfiguration configuration) {
        GeneratorModel model = (GeneratorModel)EcoreUtil2.getRootContainer((EObject)configuration);
        Optional generatorDescriptor = GeneratorExtensions.getGeneratorDescriptor((String)model.getGeneratorId());
        if (!generatorDescriptor.isPresent()) {
            return;
        }
        IDefaultFeatureValueProvider provider = LibraryExtensions.getDefaultFeatureValueProvider((String)((IGeneratorDescriptor)generatorDescriptor.get()).getLibraryID(), (FeatureTypeLibrary)configuration.getType().getLibrary());
        this.injector.injectMembers((Object)provider);
        IStatus status = provider.validateConfiguration(configuration);
        this.createMarker(status, (EStructuralFeature)SGenPackage.Literals.FEATURE_CONFIGURATION__TYPE);
    }

    @Check
    public void checkGeneratorEntry(GeneratorEntry entry) {
        GeneratorModel model = (GeneratorModel)EcoreUtil2.getRootContainer((EObject)entry);
        Optional generatorDescriptor = GeneratorExtensions.getGeneratorDescriptor((String)model.getGeneratorId());
        if (!generatorDescriptor.isPresent()) {
            return;
        }
        ILibraryDescriptor libraryDescriptor = LibraryExtensions.getLibraryDescriptor((String)((IGeneratorDescriptor)generatorDescriptor.get()).getLibraryID());
        IDefaultFeatureValueProvider valueProvider = libraryDescriptor.createFeatureValueProvider(this.injector);
        IStatus status = valueProvider.validateGeneratorEntry(entry);
        this.createMarker(status, (EStructuralFeature)SGenPackage.Literals.GENERATOR_ENTRY__ELEMENT_REF);
    }

    @Check
    public void checkDeprecatedFeatures(FeatureConfiguration configuration) {
        if (configuration.getType().isDeprecated()) {
            Object warning = String.format(DEPRECATED, configuration.getType().getName());
            if (configuration.getType().getComment() != null) {
                warning = (String)warning + configuration.getType().getComment();
            }
            this.warning((String)warning, (EObject)configuration, null);
        }
    }

    @Check
    public void checkRequiredParameters(FeatureConfiguration configuration) {
        GeneratorModel model = (GeneratorModel)EcoreUtil2.getRootContainer((EObject)configuration);
        Optional generatorDescriptor = GeneratorExtensions.getGeneratorDescriptor((String)model.getGeneratorId());
        if (!generatorDescriptor.isPresent()) {
            return;
        }
        ILibraryDescriptor libraryDescriptor = LibraryExtensions.getLibraryDescriptor((String)((IGeneratorDescriptor)generatorDescriptor.get()).getLibraryID());
        Iterable requiredParameters = Iterables.transform((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)libraryDescriptor.getFeatureTypeLibrary().getTypes(), this.hasName(configuration.getType().getName())), this.getParameter())), this.isRequiredParamter()), this.getName());
        ArrayList configuredParameters = Lists.newArrayList();
        for (FeatureParameterValue featureParameterValue : configuration.getParameterValues()) {
            configuredParameters.add(featureParameterValue.getParameter().getName());
        }
        for (String string : requiredParameters) {
            if (configuredParameters.contains(string)) continue;
            this.error(String.format("Missing required parameter. %s", string), (EStructuralFeature)SGenPackage.Literals.FEATURE_CONFIGURATION__TYPE);
        }
    }

    private Function<NamedElement, String> getName() {
        return new Function<NamedElement, String>(){

            public String apply(NamedElement from) {
                return from.getName();
            }
        };
    }

    private Predicate<FeatureParameter> isRequiredParamter() {
        return new Predicate<FeatureParameter>(){

            public boolean apply(FeatureParameter input) {
                return !input.isOptional();
            }
        };
    }

    private Function<FeatureType, Iterable<FeatureParameter>> getParameter() {
        return new Function<FeatureType, Iterable<FeatureParameter>>(){

            public Iterable<FeatureParameter> apply(FeatureType from) {
                return from.getParameters();
            }
        };
    }

    private Predicate<NamedElement> hasName(final String name) {
        return new Predicate<NamedElement>(){

            public boolean apply(NamedElement input) {
                if (name == null) {
                    return input == null;
                }
                return name.equals(input.getName());
            }
        };
    }

    private static Predicate<FeatureType> isRequired() {
        return new Predicate<FeatureType>(){

            public boolean apply(FeatureType input) {
                return !input.isOptional();
            }
        };
    }

    private void createMarker(IStatus status, EStructuralFeature feature) {
        switch (status.getSeverity()) {
            case 4: {
                if (status instanceof ErrorCodeStatus) {
                    super.error(status.getMessage(), feature, ((ErrorCodeStatus)status).getErrorCode(), new String[0]);
                    break;
                }
                super.error(status.getMessage(), feature);
                break;
            }
            case 2: {
                super.warning(status.getMessage(), feature);
            }
        }
    }
}

