/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.interpreter.base;

import com.google.inject.Inject;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.expressions.AssignmentExpression;
import com.yakindu.base.expressions.expressions.AssignmentOperator;
import com.yakindu.base.expressions.expressions.BinaryExpression;
import com.yakindu.base.expressions.expressions.BitwiseAndExpression;
import com.yakindu.base.expressions.expressions.BitwiseOrExpression;
import com.yakindu.base.expressions.expressions.BitwiseXorExpression;
import com.yakindu.base.expressions.expressions.BlockExpression;
import com.yakindu.base.expressions.expressions.BoolLiteral;
import com.yakindu.base.expressions.expressions.ConditionalExpression;
import com.yakindu.base.expressions.expressions.DeclarationExpression;
import com.yakindu.base.expressions.expressions.DoubleLiteral;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.EventRaisingExpression;
import com.yakindu.base.expressions.expressions.EventValueReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.expressions.FloatLiteral;
import com.yakindu.base.expressions.expressions.IfExpression;
import com.yakindu.base.expressions.expressions.InitializationExpression;
import com.yakindu.base.expressions.expressions.IntLiteral;
import com.yakindu.base.expressions.expressions.LambdaExpression;
import com.yakindu.base.expressions.expressions.Literal;
import com.yakindu.base.expressions.expressions.LogicalAndExpression;
import com.yakindu.base.expressions.expressions.LogicalNotExpression;
import com.yakindu.base.expressions.expressions.LogicalOrExpression;
import com.yakindu.base.expressions.expressions.MetaCall;
import com.yakindu.base.expressions.expressions.NullLiteral;
import com.yakindu.base.expressions.expressions.NumericalUnaryExpression;
import com.yakindu.base.expressions.expressions.ParenthesizedExpression;
import com.yakindu.base.expressions.expressions.PostFixUnaryExpression;
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression;
import com.yakindu.base.expressions.expressions.ReturnExpression;
import com.yakindu.base.expressions.expressions.StringLiteral;
import com.yakindu.base.expressions.expressions.ThisExpression;
import com.yakindu.base.expressions.expressions.TypeCastExpression;
import com.yakindu.base.expressions.expressions.WhileExpression;
import com.yakindu.base.expressions.interpreter.base.BaseExecution;
import com.yakindu.base.expressions.interpreter.base.IInstanceFactory;
import com.yakindu.base.expressions.interpreter.base.IInterpreter;
import com.yakindu.base.expressions.interpreter.base.InterpreterException;
import com.yakindu.base.expressions.interpreter.base.SRuntimeFunction;
import com.yakindu.base.expressions.interpreter.context.IExecutionSlotResolver;
import com.yakindu.base.expressions.interpreter.types.FunctionInstance;
import com.yakindu.base.types.Argument;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.EnumerationType;
import com.yakindu.base.types.Enumerator;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypesUtil;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.base.types.util.ArgumentSorter;
import com.yakindu.sct.model.sruntime.CompositeExecutionEvent;
import com.yakindu.sct.model.sruntime.CompositeSlot;
import com.yakindu.sct.model.sruntime.ExecutionEvent;
import com.yakindu.sct.model.sruntime.ExecutionSlot;
import com.yakindu.sct.model.sruntime.ReferenceExecutionEvent;
import com.yakindu.sct.model.sruntime.ReferenceSlot;
import com.yakindu.sct.model.sruntime.SRuntimeFactory;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class ExpressionExecution
extends BaseExecution {
    protected static Map<AssignmentOperator, String> assignFunctionMap = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)AssignmentOperator.MULT_ASSIGN, (Object)"*"), Pair.of((Object)AssignmentOperator.DIV_ASSIGN, (Object)"/"), Pair.of((Object)AssignmentOperator.MOD_ASSIGN, (Object)"%"), Pair.of((Object)AssignmentOperator.ADD_ASSIGN, (Object)"+"), Pair.of((Object)AssignmentOperator.SUB_ASSIGN, (Object)"-"), Pair.of((Object)AssignmentOperator.LEFT_SHIFT_ASSIGN, (Object)"<<"), Pair.of((Object)AssignmentOperator.RIGHT_SHIFT_ASSIGN, (Object)">>"), Pair.of((Object)AssignmentOperator.AND_ASSIGN, (Object)"&"), Pair.of((Object)AssignmentOperator.XOR_ASSIGN, (Object)"^"), Pair.of((Object)AssignmentOperator.OR_ASSIGN, (Object)"|")}));
    @Inject
    @Extension
    protected SRuntimeFunction cf;
    @Inject
    @Extension
    protected IQualifiedNameProvider qnp;
    @Inject
    @Extension
    protected ITypeSystem ts;
    @Inject
    @Extension
    protected ITypeSystemInferrer tsi;
    @Inject
    @Extension
    protected IExecutionSlotResolver _iExecutionSlotResolver;
    @Inject
    @Extension
    protected TypesUtil _typesUtil;
    @Extension
    protected SRuntimeFactory runtimeFactory = SRuntimeFactory.eINSTANCE;
    @Inject
    protected IInstanceFactory factory;
    @Inject
    @Extension
    protected IInstanceFactory _iInstanceFactory;

    @Override
    public void provideExecution(Object program) {
        this.execution(program);
    }

    protected void _execution(Object it) {
    }

    protected void _execution(BlockExpression block) {
        Consumer<Expression> _function = it -> this._exec(it);
        block.getExpressions().forEach(_function);
    }

    protected void _execution(DeclarationExpression it) {
        this.declareLocal(it.getDeclaration());
    }

    protected void _declareLocal(Declaration it) {
    }

    protected void _declareLocal(Property it) {
        boolean _tripleNotEquals;
        Expression _initialValue = it.getInitialValue();
        boolean bl = _tripleNotEquals = _initialValue != null;
        if (_tripleNotEquals) {
            this._exec(it.getInitialValue());
            this._value();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("var ");
            String _name = it.getName();
            _builder.append(_name);
            Runnable _function = () -> {
                Object value = this.context.popValue();
                this.context.defineVariable(it.getName(), value);
            };
            this.context._execute(_builder.toString(), _function);
        }
    }

    protected void _execution(InitializationExpression expr) {
        ITypeSystemInferrer.InferenceResult typeInfo = this.typeInfoUsingArraySize((Expression)expr, expr.getArguments().size());
        Consumer<Argument> _function = arg -> {
            this._exec(arg.getValue());
            this._value();
        };
        expr.getArguments().forEach(_function);
        boolean _isMap = this.ts.isMap(typeInfo.getType());
        if (_isMap) {
            Consumer<Argument> _function_1 = arg -> {
                this._exec(arg.getKey());
                this._value();
            };
            expr.getArguments().forEach(_function_1);
        }
        Functions.Function0 _function_2 = () -> {
            ArrayDeque<Object> argKeys = new ArrayDeque<Object>();
            boolean _isMap_1 = this.ts.isMap(typeInfo.getType());
            if (_isMap_1) {
                int _size = expr.getArguments().size();
                IntegerRange _upTo = new IntegerRange(1, _size);
                for (Integer i : _upTo) {
                    argKeys.push(this.context.popValue());
                }
            }
            ArrayDeque<Object> argValues = new ArrayDeque<Object>();
            int _size_1 = expr.getArguments().size();
            IntegerRange _upTo_1 = new IntegerRange(1, _size_1);
            for (Integer i_1 : _upTo_1) {
                argValues.push(this.context.popValue());
            }
            Object _newInstance = this._iInstanceFactory.newInstance(typeInfo);
            CompositeSlot instance = (CompositeSlot)_newInstance;
            boolean _isMap_2 = this.ts.isMap(typeInfo.getType());
            if (_isMap_2) {
                Procedures.Procedure2 _function_3 = (arg, i_2) -> {
                    Object key = ((Object[])Conversions.unwrapArray((Object)argKeys, Object.class))[i_2];
                    String name = key.toString();
                    Object value = ((Object[])Conversions.unwrapArray((Object)argValues, Object.class))[i_2];
                    Functions.Function1 _function_4 = s -> {
                        Object _key = s.getKey();
                        return Objects.equals(_key, key);
                    };
                    ExecutionSlot slot = (ExecutionSlot)IterableExtensions.findFirst((Iterable)instance.getSlots(), (Functions.Function1)_function_4);
                    if (slot == null) {
                        Object _xifexpression = null;
                        _xifexpression = value instanceof ExecutionSlot ? this.factory.copyInstance(value) : this.factory.newInstance(instance.getTypeSpecifier().getTypeArguments().get(1));
                        Procedures.Procedure1 _function_5 = s -> {
                            s.setName(name);
                            s.setFqName(name);
                            s.setKey(key);
                            if (!(value instanceof ExecutionSlot)) {
                                s.setValue(this.cast(value, s.getType()));
                            }
                        };
                        ExecutionSlot newMapEntry = (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)((ExecutionSlot)_xifexpression), (Procedures.Procedure1)_function_5);
                        List _slots = instance.getSlots();
                        _slots.add(newMapEntry);
                    }
                };
                IterableExtensions.forEach((Iterable)expr.getArguments(), (Procedures.Procedure2)_function_3);
            } else {
                Procedures.Procedure2 _function_4 = (v, i_2) -> {
                    ExecutionSlot slot = (ExecutionSlot)instance.getSlots().get((int)i_2);
                    this.context.set(slot, this.cast(v, slot.getType()));
                };
                IterableExtensions.forEach(argValues, (Procedures.Procedure2)_function_4);
            }
            return instance;
        };
        this._return(_function_2);
    }

    protected ITypeSystemInferrer.InferenceResult typeInfoUsingArraySize(Expression expr, int size) {
        ITypeSystemInferrer.InferenceResult typeInfo = this.tsi.infer((EObject)expr);
        boolean _isArray = this.ts.isArray(typeInfo.getType());
        if (_isArray) {
            typeInfo = ITypeSystemInferrer.InferenceResult.from((Type)typeInfo.getType(), (List)typeInfo.getBindings(), (int)size);
        }
        return typeInfo;
    }

    protected Object _eventValue(ExecutionEvent it) {
        return it.getValue();
    }

    protected Object _eventValue(CompositeExecutionEvent it) {
        CompositeExecutionEvent _copy = (CompositeExecutionEvent)EcoreUtil.copy((EObject)it);
        Procedures.Procedure1 _function = it_1 -> {
            String _name = it_1.getName();
            String _plus = _name + "@value";
            it_1.setName(_plus);
        };
        return ObjectExtensions.operator_doubleArrow((Object)_copy, (Procedures.Procedure1)_function);
    }

    protected Object _eventValue(ReferenceExecutionEvent it) {
        ReferenceExecutionEvent _copy = (ReferenceExecutionEvent)EcoreUtil.copy((EObject)it);
        Procedures.Procedure1 _function = it_1 -> {
            String _name = it_1.getName();
            String _plus = _name + "@value";
            it_1.setName(_plus);
        };
        return ObjectExtensions.operator_doubleArrow((Object)_copy, (Procedures.Procedure1)_function);
    }

    protected void _execution(InitializationExpression context, Operation item) {
        String _name = item.getName();
        String _plus = "call " + _name;
        Runnable _function = () -> {
            this.executeArguments(item, (List<Argument>)context.getArguments());
            if (context instanceof FeatureCall) {
                this._exec(((FeatureCall)context).getOwner());
                Runnable _function_1 = () -> {
                    Object slot = this.context.popValue();
                    this.context.instance(slot).invoke(slot, context);
                };
                this._execute(_function_1);
            } else {
                this._call(context, null, item);
            }
        };
        Procedures.Procedure1 _function_1 = onError -> this.doResolve((EObject)item, (Expression)context);
        this.context._try(_plus, _function, (Procedures.Procedure1<? super Throwable>)_function_1);
    }

    protected void _execution(PrimitiveValueExpression expr) {
        Functions.Function0 _function = () -> this.literalValue(expr.getValue());
        this.context._return(this.literalValue(expr.getValue()).toString(), _function);
    }

    protected void _execution(ParenthesizedExpression expr) {
        this._exec(expr.getExpression());
    }

    protected void _execution(AssignmentExpression expr) {
        this._exec(expr.getExpression());
        this._value();
        this._exec(expr.getVarRef());
        Functions.Function0 _function = () -> {
            boolean _tripleNotEquals;
            String f = assignFunctionMap.get(expr.getOperator());
            Object varRef = this.context.popValue();
            Object value = this.context.popValue();
            AssignmentOperator _operator = expr.getOperator();
            boolean bl = _tripleNotEquals = _operator != AssignmentOperator.ASSIGN;
            if (_tripleNotEquals) {
                Object varValue = this.context.get(varRef);
                value = this.cf.evaluate(f, varValue, value);
            }
            this.context.set(varRef, this.cast(value, ((ExecutionSlot)varRef).getType()));
            return value;
        };
        this.context._return(expr.getOperator().getLiteral(), _function);
    }

    protected void _execution(ElementReferenceExpression expr) {
        this.execution(expr.getReference(), expr);
    }

    protected void _execution(FeatureCall expr) {
        this.execution(expr.getFeature(), expr);
    }

    protected void _execution(Object item, Object context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Don't know how to execute ");
        String _simpleName = item.getClass().getSimpleName();
        _builder.append(_simpleName);
        _builder.append(" in context ");
        String _simpleName_1 = context.getClass().getSimpleName();
        _builder.append(_simpleName_1);
        throw new IllegalArgumentException(_builder.toString());
    }

    protected void _execution(Operation item, ArgumentExpression context) {
        String _name = item.getName();
        String _plus = "call " + _name;
        Runnable _function = () -> {
            this.executeArguments(item, (List<Argument>)context.getArguments());
            if (context instanceof FeatureCall && !item.getName().equals("new")) {
                this._exec(((FeatureCall)context).getOwner());
                Runnable _function_1 = () -> {
                    Object slot = this.context.popValue();
                    Object _xifexpression = null;
                    _xifexpression = slot instanceof ReferenceSlot ? ((ReferenceSlot)slot).getReference() : slot;
                    Object invokationTarget = _xifexpression;
                    this.context.instance(invokationTarget).invoke(slot, context);
                };
                this._execute(_function_1);
            } else {
                this._call(context, null, item);
            }
        };
        Procedures.Procedure1 _function_1 = onError -> this.doResolve((EObject)item, (Expression)context);
        this.context._try(_plus, _function, (Procedures.Procedure1<? super Throwable>)_function_1);
    }

    protected void _execution(NamedElement item, ArgumentExpression context) {
        this.doResolve((EObject)item, (Expression)context);
    }

    protected void _doResolve(NamedElement item, ElementReferenceExpression context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("resolve ");
        String _symbol = this.symbol(item);
        _builder.append(_symbol);
        Functions.Function0 _function = () -> this.executeResolve(item, (ArgumentExpression)context);
        this.context._return(_builder.toString(), _function);
        boolean _and = false;
        boolean _isArrayAccess = context.isArrayAccess();
        if (!_isArrayAccess) {
            _and = false;
        } else {
            boolean _isMap;
            EObject _reference = context.getReference();
            ITypeSystemInferrer.InferenceResult _infer = null;
            if (_reference != null) {
                _infer = this.tsi.infer(_reference);
            }
            Type _type = null;
            if (_infer != null) {
                _type = _infer.getType();
            }
            _and = _isMap = this.ts.isMap(_type);
        }
        if (_and) {
            this.resolveMapElement((List<Expression>)context.getArraySelector());
        } else {
            boolean _isArrayAccess_1 = context.isArrayAccess();
            if (_isArrayAccess_1) {
                this.resolveArrayElement((List<Expression>)context.getArraySelector());
            }
        }
    }

    protected void _doResolve(NamedElement item, FeatureCall context) {
        this._exec(context.getOwner());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("resolve ");
        String _symbol = this.symbol(item);
        _builder.append(_symbol);
        Functions.Function0 _function = () -> this.executeResolve(item, (ArgumentExpression)context);
        this.context._return(_builder.toString(), _function);
        boolean _isArrayAccess = context.isArrayAccess();
        if (_isArrayAccess) {
            this.resolveArrayElement((List<Expression>)context.getArraySelector());
        }
    }

    protected void _doResolve(Enumerator item, ArgumentExpression context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("resolve ");
        String _symbol = this.symbol(item);
        _builder.append(_symbol);
        Functions.Function0 _function = () -> item;
        this.context._return(_builder.toString(), _function);
    }

    protected void _doResolve(InitializationExpression item, EventRaisingExpression context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("resolve ");
        String _symbol = this.symbol(context.getEvent());
        _builder.append(_symbol);
        Functions.Function0 _function = () -> {
            Expression _event = context.getEvent();
            return this.context.resolve(null, this.symbol(((ElementReferenceExpression)_event).getReference()));
        };
        this.context._return(_builder.toString(), _function);
    }

    protected void _doResolve(Enumerator item, InitializationExpression context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("resolve ");
        String _symbol = this.symbol(item);
        _builder.append(_symbol);
        Functions.Function0 _function = () -> {
            int _literalValue = item.getLiteralValue();
            return (long)_literalValue;
        };
        this.context._return(_builder.toString(), _function);
    }

    protected Object _executeResolve(NamedElement item, ElementReferenceExpression context) {
        return this.context.resolve(null, this.symbol(item));
    }

    protected Object _executeResolve(NamedElement item, FeatureCall context) {
        return this.context.resolve(this.context.popValue(), this.symbol(item));
    }

    protected void resolveArrayElement(List<Expression> arraySelectors) {
        this._exec(IterableExtensions.head(arraySelectors));
        this._value();
        Functions.Function0 _function = () -> {
            Object _xblockexpression = null;
            Object arrayIndex = this.context.popValue();
            Object arraySlot = this.context.popValue();
            _xblockexpression = this.context.resolve(arraySlot, arrayIndex);
            return _xblockexpression;
        };
        this._return(_function);
    }

    protected void resolveMapElement(List<Expression> arraySelectors) {
        this._exec(IterableExtensions.head(arraySelectors));
        this._value();
        Functions.Function0 _function = () -> {
            ExecutionSlot _xblockexpression = null;
            Object key = this.context.popValue();
            Object _popValue = this.context.popValue();
            CompositeSlot variable = (CompositeSlot)_popValue;
            Functions.Function1 _function_1 = s -> {
                Object _key = s.getKey();
                return Objects.equals(_key, key);
            };
            ExecutionSlot slot = (ExecutionSlot)IterableExtensions.findFirst((Iterable)variable.getSlots(), (Functions.Function1)_function_1);
            ExecutionSlot _xifexpression = null;
            if (slot == null) {
                ExecutionSlot _xblockexpression_1 = null;
                Object _newInstance = this.factory.newInstance(variable.getTypeSpecifier().getTypeArguments().get(1));
                Procedures.Procedure1 _function_2 = it -> {
                    it.setName(key.toString());
                    it.setFqName(it.getName());
                    it.setKey(key);
                };
                ExecutionSlot newMapEntry = (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)((ExecutionSlot)_newInstance), (Procedures.Procedure1)_function_2);
                List _slots = variable.getSlots();
                _slots.add(newMapEntry);
                _xifexpression = _xblockexpression_1 = newMapEntry;
            } else {
                _xifexpression = slot;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        };
        this._return(_function);
    }

    protected void executeArguments(Operation op, List<Argument> args) {
        Consumer<Expression> _function = a -> {
            this._exec(this.context.get(a));
            this._value();
        };
        ArgumentSorter.getOrderedExpressions(args, (Operation)op).forEach(_function);
    }

    protected void _execution(MetaCall expr) {
        String _name;
        boolean _equals;
        EObject metaFeature = expr.getFeature();
        if (metaFeature instanceof Property && (_equals = Objects.equals(_name = ((Property)metaFeature).getName(), "value"))) {
            this._exec(expr.getOwner());
            Functions.Function0 _function = () -> {
                Object _xblockexpression = null;
                Object eventSlot = this.context.popValue();
                _xblockexpression = this.eventValue((ExecutionEvent)eventSlot);
                return _xblockexpression;
            };
            this._return(_function);
            return;
        }
        this._delegate(expr);
    }

    protected String _symbol(Object it) {
        return null;
    }

    protected String _symbol(NamedElement it) {
        return this.qnp.getFullyQualifiedName((EObject)it).getLastSegment();
    }

    protected void _execution(BinaryExpression it) {
        this.binaryExpressionExecution(it.getOperator().getName(), it.getLeftOperand(), it.getRightOperand());
    }

    protected void binaryExpressionExecution(String operator, Expression left, Expression right) {
        this._exec(left);
        this._value();
        this._exec(right);
        this._value();
        Functions.Function0 _function = () -> {
            Object _xblockexpression = null;
            Object rightValue = this.context.popValue();
            Object leftValue = this.context.popValue();
            _xblockexpression = this.cf.evaluate(operator, leftValue, rightValue);
            return _xblockexpression;
        };
        this.context._return(operator, _function);
    }

    protected void unaryExpressionExecution(String operator, Expression expr) {
        this._exec(expr);
        this._value();
        Functions.Function0 _function = () -> {
            Object _xblockexpression = null;
            Object value = this.context.popValue();
            _xblockexpression = this.cf.evaluate(operator, value);
            return _xblockexpression;
        };
        this.context._return(operator, _function);
    }

    protected void _execution(LogicalOrExpression expr) {
        this._exec(expr.getLeftOperand());
        this._value();
        Runnable _function = () -> {
            Object _popValue = this.context.popValue();
            boolean _equals = Objects.equals(_popValue, true);
            if (_equals) {
                Functions.Function0 _function_1 = () -> true;
                this._return(_function_1);
            } else {
                this._exec(expr.getRightOperand());
                this._value();
                Functions.Function0 _function_2 = () -> this.context.popValue();
                this._return(_function_2);
            }
        };
        this.context._execute("||", _function);
    }

    protected void _execution(LogicalAndExpression expr) {
        this._exec(expr.getLeftOperand());
        this._value();
        Runnable _function = () -> {
            Object _popValue = this.context.popValue();
            boolean _equals = Objects.equals(_popValue, false);
            if (_equals) {
                Functions.Function0 _function_1 = () -> false;
                this._return(_function_1);
            } else {
                this._exec(expr.getRightOperand());
                this._value();
                Functions.Function0 _function_2 = () -> this.context.popValue();
                this._return(_function_2);
            }
        };
        this.context._execute("&&", _function);
    }

    protected void _execution(LogicalNotExpression it) {
        this._exec(it.getOperand());
        this._value();
        Functions.Function0 _function = () -> {
            Object _popValue = this.context.popValue();
            return Objects.equals(_popValue, false);
        };
        this.context._return("!", _function);
    }

    protected void _execution(ConditionalExpression it) {
        this._exec(it.getCondition());
        this._value();
        Runnable _function = () -> {
            Object _popValue = this.context.popValue();
            boolean _equals = Objects.equals(_popValue, true);
            if (_equals) {
                this._exec(it.getTrueCase());
            } else {
                this._exec(it.getFalseCase());
            }
        };
        this._execute(_function);
    }

    protected void _execution(EventRaisingExpression it) {
        boolean _tripleNotEquals;
        this._exec(it.getEvent());
        Expression _value = it.getValue();
        boolean bl = _tripleNotEquals = _value != null;
        if (_tripleNotEquals) {
            this._exec(it.getValue());
            this._value();
        }
        Runnable _function = () -> {
            Object _xifexpression = null;
            Expression _value_1 = it.getValue();
            boolean _tripleNotEquals_1 = _value_1 != null;
            _xifexpression = _tripleNotEquals_1 ? this.context.popValue() : null;
            Object value = _xifexpression;
            Object slot = this.context.popValue();
            this.context.raise(slot, value);
        };
        this._execute(_function);
    }

    protected void _execution(EventValueReferenceExpression expression) {
        this._exec(expression.getValue());
        Functions.Function0 _function = () -> {
            Object _xblockexpression = null;
            Object eventSlot = this.context.popValue();
            _xblockexpression = this.eventValue((ExecutionEvent)eventSlot);
            return _xblockexpression;
        };
        this._return(_function);
    }

    protected void _execution(BitwiseAndExpression it) {
        this.binaryExpressionExecution("&", it.getLeftOperand(), it.getRightOperand());
    }

    protected void _execution(BitwiseOrExpression it) {
        this.binaryExpressionExecution("|", it.getLeftOperand(), it.getRightOperand());
    }

    protected void _execution(BitwiseXorExpression it) {
        this.binaryExpressionExecution("^", it.getLeftOperand(), it.getRightOperand());
    }

    protected void _execution(NumericalUnaryExpression expression) {
        this.unaryExpressionExecution(expression.getOperator().getLiteral(), expression.getOperand());
    }

    protected void _execution(PostFixUnaryExpression it) {
        this._exec(it.getOperand());
        Functions.Function0 _function = () -> {
            Object _xblockexpression = null;
            Object varRef = this.context.popValue();
            Object varValue = this.context.get(varRef);
            Object opValue = this.cf.evaluate(it.getOperator().getLiteral(), varValue);
            this.context.set(varRef, opValue);
            _xblockexpression = varValue;
            return _xblockexpression;
        };
        this.context._return(it.getOperator().getLiteral(), _function);
    }

    protected void _execution(TypeCastExpression expression) {
        this._exec(expression.getOperand());
        this._value();
        String _name = expression.getType().getOriginType().getName();
        String _plus = "cast(" + _name;
        String _plus_1 = _plus + ")";
        Functions.Function0 _function = () -> {
            Object _xblockexpression = null;
            Object operandValue = this.context.popValue();
            _xblockexpression = this.typeCast(operandValue, expression.getType().getOriginType());
            return _xblockexpression;
        };
        this.context._return(_plus_1, _function);
    }

    protected void _execution(ReturnExpression it) {
        boolean _tripleNotEquals;
        Expression _expression = it.getExpression();
        boolean bl = _tripleNotEquals = _expression != null;
        if (_tripleNotEquals) {
            this._exec(it.getExpression());
            this._value();
        }
        Runnable _function = () -> {
            Object _xifexpression = null;
            Expression _expression_1 = it.getExpression();
            boolean _tripleEquals = _expression_1 == null;
            _xifexpression = _tripleEquals ? null : this.context.popValue();
            this.context.exitCall(_xifexpression);
        };
        this.context._execute("return expression", _function);
    }

    protected void _execution(IfExpression it) {
        this._exec(it.getCondition());
        this._value();
        Runnable _function = () -> {
            Object _popValue = this.context.popValue();
            boolean checkResult = Objects.equals(_popValue, true);
            if (checkResult) {
                this._exec(it.getThen());
            } else {
                boolean _tripleNotEquals;
                Expression _else = it.getElse();
                boolean bl = _tripleNotEquals = _else != null;
                if (_tripleNotEquals) {
                    this._exec(it.getElse());
                }
            }
        };
        this.context._execute("if", _function);
    }

    protected void _execution(WhileExpression it) {
        this._exec(it.getCondition());
        this._value();
        Runnable _function = () -> {
            Object _popValue = this.context.popValue();
            boolean checkResult = Objects.equals(_popValue, true);
            if (checkResult) {
                this._exec(it.getBody());
                this._exec(it);
            }
        };
        this.context._execute("while", _function);
    }

    protected void _execution(Operation it) {
        this._delegate(it);
    }

    protected void _execution(ThisExpression it) {
        this._delegate(it);
    }

    protected void _execution(LambdaExpression le) {
        Object _self = this.context.getSelf();
        IInterpreter.Instance _instance = null;
        if (_self != null) {
            _instance = this.context.instance(_self);
        }
        IInterpreter.Instance lambdaOwnerInstance = _instance;
        Object lambdaOwnerSlot = lambdaOwnerInstance.instanceMemory();
        Functions.Function0 _function = () -> {
            IInterpreter.Instance funInstance;
            Object _xblockexpression = null;
            Object funSlot = this._iInstanceFactory.newInstance(le);
            if (lambdaOwnerSlot instanceof ExecutionSlot && (funInstance = this.context.instance(funSlot)) instanceof FunctionInstance) {
                ((FunctionInstance)funInstance).setOwner((ExecutionSlot)lambdaOwnerSlot);
            }
            _xblockexpression = funSlot;
            return _xblockexpression;
        };
        this.context._return("lambda", _function);
    }

    public Object cast(Object value, Type type) {
        Object _xifexpression = null;
        _xifexpression = type != null ? this.typeCast(value, type.getOriginType()) : value;
        return _xifexpression;
    }

    protected Object _typeCast(Long value, Type type) {
        if (type instanceof EnumerationType) {
            return value;
        }
        boolean _isSuperType = this.ts.isSuperType(type, this.ts.getType("integer"));
        if (_isSuperType) {
            return value;
        }
        boolean _isSuperType_1 = this.ts.isSuperType(type, this.ts.getType("real"));
        if (_isSuperType_1) {
            return (double)value.longValue();
        }
        String _name = type.getName();
        String _plus = "Invalid cast from Long to " + _name;
        throw new InterpreterException(_plus);
    }

    protected Object _typeCast(Float value, Type type) {
        boolean _isSuperType = this.ts.isSuperType(type, this.ts.getType("integer"));
        if (_isSuperType) {
            return value.longValue();
        }
        boolean _isSuperType_1 = this.ts.isSuperType(type, this.ts.getType("real"));
        if (_isSuperType_1) {
            return (double)value.floatValue();
        }
        String _name = type.getName();
        String _plus = "Invalid cast from Float to " + _name;
        throw new InterpreterException(_plus);
    }

    protected Object _typeCast(Double value, Type type) {
        boolean _isSuperType = this.ts.isSuperType(type, this.ts.getType("integer"));
        if (_isSuperType) {
            return value.longValue();
        }
        boolean _isSuperType_1 = this.ts.isSuperType(type, this.ts.getType("real"));
        if (_isSuperType_1) {
            return (double)value;
        }
        String _name = type.getName();
        String _plus = "Invalid cast from Double to " + _name;
        throw new InterpreterException(_plus);
    }

    protected Object _typeCast(Boolean value, Type type) {
        boolean _isSuperType = this.ts.isSuperType(type, this.ts.getType("boolean"));
        if (_isSuperType) {
            return value;
        }
        String _name = type.getName();
        String _plus = "Invalid cast from Boolean to " + _name;
        throw new InterpreterException(_plus);
    }

    protected Object _typeCast(String value, Type type) {
        boolean _isSuperType = this.ts.isSuperType(type, this.ts.getType("string"));
        if (_isSuperType) {
            return value;
        }
        String _name = type.getName();
        String _plus = "Invalid cast from String to " + _name;
        throw new InterpreterException(_plus);
    }

    protected Object _typeCast(Enumerator value, Type type) {
        boolean _isSuperType = this.ts.isSuperType(type, (Type)value.getOwningEnumeration());
        if (_isSuperType) {
            return value;
        }
        String _name = type.getName();
        String _plus = "Invalid cast from Enumerator to " + _name;
        throw new InterpreterException(_plus);
    }

    protected Object _typeCast(Object value, Type type) {
        return value;
    }

    protected Object _literalValue(IntLiteral literal) {
        long _value = literal.getValue();
        return _value;
    }

    protected Object _literalValue(BoolLiteral bool) {
        return bool.isValue();
    }

    protected Object _literalValue(DoubleLiteral literal) {
        return literal.getValue();
    }

    protected Object _literalValue(FloatLiteral literal) {
        return Float.valueOf(literal.getValue());
    }

    protected Object _literalValue(StringLiteral literal) {
        return literal.getValue();
    }

    protected Object _literalValue(NullLiteral literal) {
        return IInterpreter.NULL;
    }

    public void _call(Object caller, Object receiver, Object operation) {
        BaseExecution.Invokation _invokation = new BaseExecution.Invokation(caller, receiver, operation);
        this.executionCall(_invokation);
    }

    protected void _executionCall(Object it) {
        throw new UnsupportedOperationException("Don't know how to call operations");
    }

    protected void _executionCall(BaseExecution.Invokation it) {
        this._delegate(it);
    }

    protected void _executionCall(Operation it) {
        this._delegate(it);
    }

    @XbaseGenerated
    public void execution(Object it) {
        if (it instanceof Operation) {
            this._execution((Operation)it);
            return;
        }
        if (it instanceof MetaCall) {
            this._execution((MetaCall)it);
            return;
        }
        if (it instanceof BitwiseAndExpression) {
            this._execution((BitwiseAndExpression)it);
            return;
        }
        if (it instanceof BitwiseOrExpression) {
            this._execution((BitwiseOrExpression)it);
            return;
        }
        if (it instanceof BitwiseXorExpression) {
            this._execution((BitwiseXorExpression)it);
            return;
        }
        if (it instanceof ElementReferenceExpression) {
            this._execution((ElementReferenceExpression)it);
            return;
        }
        if (it instanceof FeatureCall) {
            this._execution((FeatureCall)it);
            return;
        }
        if (it instanceof LogicalAndExpression) {
            this._execution((LogicalAndExpression)it);
            return;
        }
        if (it instanceof LogicalNotExpression) {
            this._execution((LogicalNotExpression)it);
            return;
        }
        if (it instanceof LogicalOrExpression) {
            this._execution((LogicalOrExpression)it);
            return;
        }
        if (it instanceof NumericalUnaryExpression) {
            this._execution((NumericalUnaryExpression)it);
            return;
        }
        if (it instanceof PostFixUnaryExpression) {
            this._execution((PostFixUnaryExpression)it);
            return;
        }
        if (it instanceof WhileExpression) {
            this._execution((WhileExpression)it);
            return;
        }
        if (it instanceof AssignmentExpression) {
            this._execution((AssignmentExpression)it);
            return;
        }
        if (it instanceof BinaryExpression) {
            this._execution((BinaryExpression)it);
            return;
        }
        if (it instanceof BlockExpression) {
            this._execution((BlockExpression)it);
            return;
        }
        if (it instanceof ConditionalExpression) {
            this._execution((ConditionalExpression)it);
            return;
        }
        if (it instanceof DeclarationExpression) {
            this._execution((DeclarationExpression)it);
            return;
        }
        if (it instanceof EventRaisingExpression) {
            this._execution((EventRaisingExpression)it);
            return;
        }
        if (it instanceof EventValueReferenceExpression) {
            this._execution((EventValueReferenceExpression)it);
            return;
        }
        if (it instanceof IfExpression) {
            this._execution((IfExpression)it);
            return;
        }
        if (it instanceof InitializationExpression) {
            this._execution((InitializationExpression)it);
            return;
        }
        if (it instanceof LambdaExpression) {
            this._execution((LambdaExpression)it);
            return;
        }
        if (it instanceof ParenthesizedExpression) {
            this._execution((ParenthesizedExpression)it);
            return;
        }
        if (it instanceof PrimitiveValueExpression) {
            this._execution((PrimitiveValueExpression)it);
            return;
        }
        if (it instanceof ReturnExpression) {
            this._execution((ReturnExpression)it);
            return;
        }
        if (it instanceof ThisExpression) {
            this._execution((ThisExpression)it);
            return;
        }
        if (it instanceof TypeCastExpression) {
            this._execution((TypeCastExpression)it);
            return;
        }
        if (it != null) {
            this._execution(it);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    protected void declareLocal(Declaration it) {
        if (it instanceof Property) {
            this._declareLocal((Property)it);
            return;
        }
        if (it != null) {
            this._declareLocal(it);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public Object eventValue(ExecutionEvent it) {
        if (it instanceof ReferenceExecutionEvent) {
            return this._eventValue((ReferenceExecutionEvent)it);
        }
        if (it instanceof CompositeExecutionEvent) {
            return this._eventValue((CompositeExecutionEvent)it);
        }
        if (it != null) {
            return this._eventValue(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public void execution(Object item, Object context) {
        if (item instanceof Operation && context instanceof ArgumentExpression) {
            this._execution((Operation)item, (ArgumentExpression)context);
            return;
        }
        if (item instanceof InitializationExpression && context instanceof Operation) {
            this._execution((InitializationExpression)item, (Operation)context);
            return;
        }
        if (item instanceof NamedElement && context instanceof ArgumentExpression) {
            this._execution((NamedElement)item, (ArgumentExpression)context);
            return;
        }
        if (item != null && context != null) {
            this._execution(item, context);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(item, context).toString());
    }

    @XbaseGenerated
    protected void doResolve(EObject item, Expression context) {
        if (item instanceof Enumerator && context instanceof ArgumentExpression) {
            this._doResolve((Enumerator)item, (ArgumentExpression)context);
            return;
        }
        if (item instanceof Enumerator && context instanceof InitializationExpression) {
            this._doResolve((Enumerator)item, (InitializationExpression)context);
            return;
        }
        if (item instanceof InitializationExpression && context instanceof EventRaisingExpression) {
            this._doResolve((InitializationExpression)item, (EventRaisingExpression)context);
            return;
        }
        if (item instanceof NamedElement && context instanceof ElementReferenceExpression) {
            this._doResolve((NamedElement)item, (ElementReferenceExpression)context);
            return;
        }
        if (item instanceof NamedElement && context instanceof FeatureCall) {
            this._doResolve((NamedElement)item, (FeatureCall)context);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(item, context).toString());
    }

    @XbaseGenerated
    protected Object executeResolve(NamedElement item, ArgumentExpression context) {
        if (context instanceof ElementReferenceExpression) {
            return this._executeResolve(item, (ElementReferenceExpression)context);
        }
        if (context instanceof FeatureCall) {
            return this._executeResolve(item, (FeatureCall)context);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(item, context).toString());
    }

    @XbaseGenerated
    public String symbol(Object it) {
        if (it instanceof NamedElement) {
            return this._symbol((NamedElement)it);
        }
        if (it != null) {
            return this._symbol(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    protected Object typeCast(Object value, Type type) {
        if (value instanceof Enumerator) {
            return this._typeCast((Enumerator)value, type);
        }
        if (value instanceof Double) {
            return this._typeCast((Double)value, type);
        }
        if (value instanceof Float) {
            return this._typeCast((Float)value, type);
        }
        if (value instanceof Long) {
            return this._typeCast((Long)value, type);
        }
        if (value instanceof Boolean) {
            return this._typeCast((Boolean)value, type);
        }
        if (value instanceof String) {
            return this._typeCast((String)value, type);
        }
        if (value != null) {
            return this._typeCast(value, type);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(value, type).toString());
    }

    @XbaseGenerated
    public Object literalValue(Literal bool) {
        if (bool instanceof BoolLiteral) {
            return this._literalValue((BoolLiteral)bool);
        }
        if (bool instanceof DoubleLiteral) {
            return this._literalValue((DoubleLiteral)bool);
        }
        if (bool instanceof FloatLiteral) {
            return this._literalValue((FloatLiteral)bool);
        }
        if (bool instanceof IntLiteral) {
            return this._literalValue((IntLiteral)bool);
        }
        if (bool instanceof NullLiteral) {
            return this._literalValue((NullLiteral)bool);
        }
        if (bool instanceof StringLiteral) {
            return this._literalValue((StringLiteral)bool);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(bool).toString());
    }

    @XbaseGenerated
    public void executionCall(Object it) {
        if (it instanceof Operation) {
            this._executionCall((Operation)it);
            return;
        }
        if (it instanceof BaseExecution.Invokation) {
            this._executionCall((BaseExecution.Invokation)it);
            return;
        }
        if (it != null) {
            this._executionCall(it);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

