/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.interpreter.base;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.base.expressions.interpreter.base.IInterpreter;
import com.yakindu.base.expressions.interpreter.base.InterpreterException;
import com.yakindu.base.expressions.interpreter.base.InterpreterSessionControl;
import com.yakindu.base.expressions.interpreter.base.InterpreterSuspendedException;
import com.yakindu.base.expressions.interpreter.scheduling.ITimeTaskScheduler;
import com.yakindu.base.expressions.interpreter.scheduling.TaskScheduler;
import com.yakindu.core.ITimerService;
import com.yakindu.core.ITracingListener;
import com.yakindu.core.TimerService;
import com.yakindu.core.rx.Observable;
import com.yakindu.core.rx.Observer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.commons.lang.time.StopWatch;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@Singleton
public class InterpreterSession
extends InterpreterSessionControl
implements InterpreterSessionControl.OperationCallback,
ITracingListener<InterpreterSessionControl.State>,
ITimeTaskScheduler {
    protected BlockingQueue<Callable<Object>> requestQueue = null;
    protected Thread listenerThread = null;
    protected Thread workerThread = null;
    protected IInterpreter interpreter = null;
    protected TimerService tService = null;
    protected Observable<Throwable> onError = new Observable();
    protected Observer<Object> doEvaluateObserver = o -> {
        Callable<Object> _function = () -> {
            Object _xblockexpression = null;
            this.interpreter.evaluate(o);
            _xblockexpression = null;
            return _xblockexpression;
        };
        this.execute(_function);
    };
    protected boolean debug = false;
    protected String lastLogMsg = null;

    @Inject
    public InterpreterSession(IInterpreter i, IInterpreter.Control iCtrl) {
        TimerService _timerService;
        this.tService = _timerService = new TimerService();
        this.setTimerService((ITimerService)this.tService);
        this.setOperationCallback(this);
        this.addTraceObserver(this);
        TaskScheduler _taskScheduler = new TaskScheduler();
        this.setScheduler(_taskScheduler);
        this.enter();
        this.setInterpreterControl(iCtrl);
        this.interpreter = i;
        Object _heap = this.interpreter.getHeap();
        SessionAdapter.adaptSession((EObject)_heap, this);
    }

    public Observable<Throwable> getOnError() {
        return this.onError;
    }

    public Observer<Object> doEvaluate() {
        return this.doEvaluateObserver;
    }

    @Override
    public void start() {
        this.raiseStart();
    }

    public boolean canTerminate() {
        return this.getCanTerminate();
    }

    @Override
    public void terminate() {
        this.raiseTerminate();
        TaskScheduler _taskScheduler = new TaskScheduler();
        this.setScheduler(_taskScheduler);
    }

    public boolean isTerminated() {
        return this.getIsTerminated();
    }

    public boolean canSuspend() {
        return this.getCanSuspend();
    }

    @Override
    public void suspend() {
        this.raiseSuspend();
    }

    public boolean isSuspended() {
        return this.getIsSuspended();
    }

    public boolean canResume() {
        return this.getCanResume();
    }

    @Override
    public void resume() {
        this.raiseResume();
    }

    public boolean canStep() {
        return this.getCanStep();
    }

    @Override
    public void step() {
        this.raiseStep();
    }

    public boolean isStepping() {
        return this.getIsStepping();
    }

    public void raiseEvent(Object event, Object value) {
        Callable<Object> _function = () -> {
            this.interpreter.raiseEvent(event, value);
            return null;
        };
        this.execute(_function);
    }

    public void setValue(Object variable, Object value) {
        Callable<Object> _function = () -> {
            this.interpreter.setValue(variable, value);
            return null;
        };
        this.execute(_function);
    }

    public void execute(Callable<Object> callable) {
        boolean _acceptExecutionRequest = this.getAcceptExecutionRequest();
        if (_acceptExecutionRequest) {
            this.log("worker schedule work");
            if (this.requestQueue != null) {
                this.requestQueue.offer(callable);
            }
        }
    }

    @Override
    public void startWorker() {
        Thread _thread;
        Runnable _function = () -> this.runWorker();
        this.workerThread = _thread = new Thread(_function, "YSCT.InterpreterSession.worker");
        this.workerThread.start();
        this.log("worker started");
    }

    @Override
    public void stopWorker() {
        this.workerThread.interrupt();
        this.log("worker stopped");
    }

    @Override
    public void startListener() {
        Thread _thread;
        LinkedBlockingDeque<Callable<Object>> _linkedBlockingDeque = new LinkedBlockingDeque<Callable<Object>>();
        this.requestQueue = _linkedBlockingDeque;
        Runnable _function = () -> this.runListener();
        this.listenerThread = _thread = new Thread(_function, "YSCT.InterpreterSession.listener");
        this.listenerThread.start();
        this.log("listener started");
    }

    @Override
    public void stopListener() {
        this.listenerThread.interrupt();
        this.requestQueue.clear();
        this.requestQueue = null;
        this.log("listener stopped");
    }

    @Override
    public void interrupt() {
        if (this.workerThread != null) {
            this.workerThread.interrupt();
        }
        this.log("worker interrupt");
    }

    @Override
    public boolean hasWork() {
        ITimeTaskScheduler.TimeTask _head = (ITimeTaskScheduler.TimeTask)IterableExtensions.head(this.getScheduler().getScheduledTimeTasks());
        return _head != null;
    }

    public void runWorker() {
        this.log("begin work");
        while (!this.inactive()) {
            boolean _workContinueSuspended;
            boolean _workSuspended;
            boolean _workSuspending;
            boolean _workProcess;
            boolean _workTimeLeap;
            boolean _workPickTask;
            boolean _matched = false;
            boolean _workIdle = this.workIdle();
            if (_workIdle) {
                _matched = true;
                this.doWorkIdle();
            }
            if (!_matched && (_workPickTask = this.workPickTask())) {
                _matched = true;
                this.doWorkPickTask();
            }
            if (!_matched && (_workTimeLeap = this.workTimeLeap())) {
                _matched = true;
                this.doWorkTimeLeap();
            }
            if (!_matched && (_workProcess = this.workProcess())) {
                _matched = true;
                this.doWorkProcess();
            }
            if (!_matched && (_workSuspending = this.workSuspending())) {
                _matched = true;
                this.doWorkSuspending();
            }
            if (!_matched && (_workSuspended = this.workSuspended())) {
                _matched = true;
                this.doWorkSuspended();
            }
            if (_matched || !(_workContinueSuspended = this.workContinueSuspended())) continue;
            _matched = true;
            this.doWorkContinueSuspended();
        }
        this.log("end work");
    }

    public void runListener() {
        this.log("begin listen");
        while (!this.inactive()) {
            boolean _matched = false;
            boolean _listenAwaitRequest = this.listenAwaitRequest();
            if (!_listenAwaitRequest) continue;
            _matched = true;
            this.doListenAwaitRequest();
        }
        this.log("end listen");
    }

    protected boolean inactive() {
        return this.isStateActive(InterpreterSessionControl.State.MAIN_INACTIVE);
    }

    protected boolean workIdle() {
        return this.isStateActive(InterpreterSessionControl.State.MAIN_ACTIVATED_WORK_IDLE);
    }

    protected void doWorkIdle() {
        this.log("doWorkIdle");
        this.sleep();
    }

    protected boolean workPickTask() {
        return this.isStateActive(InterpreterSessionControl.State.MAIN_ACTIVATED_WORK_PICK_TASK);
    }

    protected void doWorkPickTask() {
        block4: {
            this.log("doWorkPickTask");
            try {
                boolean _tripleNotEquals;
                this.setNextTask((ITimeTaskScheduler.TimeTask)IterableExtensions.head(this.getScheduler().getScheduledTimeTasks()));
                ITimeTaskScheduler.TimeTask _nextTask = this.getNextTask();
                boolean bl = _tripleNotEquals = _nextTask != null;
                if (_tripleNotEquals) {
                    this.raiseDone();
                } else {
                    this.proceedTime(100L);
                }
            }
            catch (Throwable _t) {
                if (_t instanceof InterruptedException) break block4;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    protected boolean workTimeLeap() {
        return this.isStateActive(InterpreterSessionControl.State.MAIN_ACTIVATED_WORK_TIME_LEAP);
    }

    protected void doWorkTimeLeap() {
        boolean _tripleNotEquals;
        this.log("doWorkTimeLeap");
        this.setNextTask((ITimeTaskScheduler.TimeTask)IterableExtensions.head(this.getScheduler().getScheduledTimeTasks()));
        ITimeTaskScheduler.TimeTask _nextTask = this.getNextTask();
        boolean bl = _tripleNotEquals = _nextTask != null;
        if (_tripleNotEquals) {
            boolean _lessEqualsThan;
            long _currentTime;
            long _nextExecutionTime = this.getNextTask().getNextExecutionTime();
            long _minus = _nextExecutionTime - (_currentTime = this.getScheduler().getCurrentTime());
            boolean bl2 = _lessEqualsThan = _minus <= 0L;
            if (_lessEqualsThan) {
                this.raiseDone();
            } else {
                long _nextExecutionTime_1 = this.getNextTask().getNextExecutionTime();
                long _currentTime_1 = this.getScheduler().getCurrentTime();
                long _minus_1 = _nextExecutionTime_1 - _currentTime_1;
                long leapTime = Math.min(_minus_1, 100L);
                this.proceedTime(leapTime);
            }
        }
    }

    protected boolean workProcess() {
        return this.isStateActive(InterpreterSessionControl.State.MAIN_ACTIVATED_WORK_PROCESS);
    }

    protected void doWorkProcess() {
        this.log("doWorkProcess");
        try {
            this.getScheduler().timeLeap(0L);
            this.raiseDone();
        }
        catch (Throwable _t) {
            if (_t instanceof InterpreterSuspendedException) {
                this.raiseWorkSuspended();
            }
            if (_t instanceof InterpreterException) {
                InterpreterException ie = (InterpreterException)_t;
                Throwable _elvis = null;
                Throwable _cause = ie.getCause();
                _elvis = _cause != null ? _cause : ie;
                this.onError.next((Object)_elvis);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected boolean workSuspending() {
        return this.isStateActive(InterpreterSessionControl.State.MAIN_ACTIVATED_WORK_SUSPENDING);
    }

    protected void doWorkSuspending() {
        this.log("doWorkSuspending");
    }

    protected boolean workSuspended() {
        return this.isStateActive(InterpreterSessionControl.State.MAIN_ACTIVATED_WORK_SUSPENDED);
    }

    protected void doWorkSuspended() {
        this.log("doWorkSuspended");
        this.sleep();
    }

    protected boolean workContinueSuspended() {
        return this.isStateActive(InterpreterSessionControl.State.MAIN_ACTIVATED_WORK_CONTINUE_SUSPENDED);
    }

    protected void doWorkContinueSuspended() {
        this.log("doWorkContinueSuspended");
        try {
            this.getInterpreterControl().resume();
            this.raiseDone();
        }
        catch (Throwable _t) {
            if (_t instanceof InterpreterSuspendedException) {
                this.raiseWorkSuspended();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected boolean listenAwaitRequest() {
        return this.isStateActive(InterpreterSessionControl.State.MAIN_ACTIVATED_LISTEN_AWAIT_REQUEST);
    }

    protected void doListenAwaitRequest() {
        block3: {
            this.log("doListenAwaitRequest");
            try {
                boolean _tripleEquals;
                Callable<Object> request = this.requestQueue.take();
                Runnable _function = () -> {
                    try {
                        request.call();
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                ITimeTaskScheduler.TimeTask newTask = new ITimeTaskScheduler.TimeTask("request", _function, ITimeTaskScheduler.TimeTask.Priority.HIGH);
                this.getScheduler().scheduleTask(newTask, 0L);
                ITimeTaskScheduler.TimeTask _head = (ITimeTaskScheduler.TimeTask)IterableExtensions.head(this.getScheduler().getScheduledTimeTasks());
                boolean bl = _tripleEquals = _head == newTask;
                if (_tripleEquals) {
                    this.raiseNext();
                }
            }
            catch (Throwable _t) {
                if (_t instanceof InterruptedException) break block3;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    protected Object sleep() {
        Object _xtrycatchfinallyexpression = null;
        try {
            Thread.sleep(1000L);
        }
        catch (Throwable _t) {
            if (_t instanceof InterruptedException) {
                _xtrycatchfinallyexpression = null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    protected long proceedTime(long millis) {
        long consumedTime = 0L;
        StopWatch watch = new StopWatch();
        try {
            try {
                watch.start();
                Thread.sleep(millis);
            }
            catch (Throwable _t) {
                if (!(_t instanceof InterruptedException)) {
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                watch.stop();
                consumedTime = watch.getTime();
                this.getScheduler().timeLeapWithoutExecuting(consumedTime);
            }
        }
        finally {
            watch.stop();
            consumedTime = watch.getTime();
            this.getScheduler().timeLeapWithoutExecuting(consumedTime);
        }
        return consumedTime;
    }

    public void onStateEntered(InterpreterSessionControl.State state) {
        int _identityHashCode = System.identityHashCode(this);
        String _plus = String.valueOf((Object)_identityHashCode) + " enter ";
        String _plus_1 = _plus + String.valueOf((Object)state);
        this.log(_plus_1);
    }

    public void onStateExited(InterpreterSessionControl.State state) {
        int _identityHashCode = System.identityHashCode(this);
        String _plus = String.valueOf((Object)_identityHashCode) + " exit ";
        String _plus_1 = _plus + String.valueOf((Object)state);
        this.log(_plus_1);
    }

    protected void log(String msg) {
        if (this.debug) {
            boolean _equals = msg.equals(this.lastLogMsg);
            if (_equals) {
                System.out.print(".");
            } else {
                this.lastLogMsg = msg;
                System.out.println("");
                System.out.print(this.lastLogMsg);
            }
        }
    }

    @Override
    public long getCurrentTime() {
        return this.getClock().getTime();
    }

    @Override
    public List<ITimeTaskScheduler.TimeTask> getScheduledTimeTasks() {
        return this.getScheduler().getScheduledTimeTasks();
    }

    @Override
    public Observable<Void> scheduleChanged() {
        return this.getScheduler().scheduleChanged();
    }

    @Override
    public void scheduleTimeTask(ITimeTaskScheduler.TimeTask task, boolean isPeriodical, long duration) {
        this.getScheduler().scheduleTask(task, isPeriodical, duration);
    }

    @Override
    public void timeLeap(long ms) {
        this.getScheduler().timeLeap(ms);
    }

    @Override
    public void cycleLeap(int cycles) {
        this.getScheduler().cycleLeap(cycles);
    }

    @Override
    public void unscheduleTimeTask(String taskName) {
        this.getScheduler().unschedulTask(taskName);
    }

    public static class SessionAdapter
    extends AdapterImpl {
        @Accessors
        private InterpreterSession session;

        public boolean isAdapterForType(Object type) {
            return Objects.equals(type, SessionAdapter.class);
        }

        public static void adaptSession(EObject it, InterpreterSession s) {
            EList _eAdapters = it.eAdapters();
            SessionAdapter _sessionAdapter = new SessionAdapter();
            Procedures.Procedure1 _function = it_1 -> {
                it_1.session = s;
            };
            SessionAdapter _doubleArrow = (SessionAdapter)((Object)ObjectExtensions.operator_doubleArrow((Object)((Object)_sessionAdapter), (Procedures.Procedure1)_function));
            _eAdapters.add((Object)_doubleArrow);
        }

        public static InterpreterSession session(EObject it) {
            InterpreterSession _xblockexpression = null;
            Adapter adapter = EcoreUtil.getExistingAdapter((Notifier)EcoreUtil.getRootContainer((EObject)it), SessionAdapter.class);
            InterpreterSession _xifexpression = null;
            _xifexpression = adapter != null ? ((SessionAdapter)adapter).session : null;
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        @Pure
        public InterpreterSession getSession() {
            return this.session;
        }

        public void setSession(InterpreterSession session) {
            this.session = session;
        }
    }
}

