/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.interpreter.types;

import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.interpreter.base.IInstanceFactory;
import com.yakindu.base.expressions.interpreter.base.IInterpreter;
import com.yakindu.base.expressions.interpreter.types.RuntimeInstance;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.model.sruntime.CompositeSlot;
import com.yakindu.sct.model.sruntime.ExecutionSlot;
import com.yakindu.sct.model.sruntime.ExecutionVariable;
import com.yakindu.sct.model.sruntime.SRuntimeFactory;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class ArrayInstance
extends RuntimeInstance {
    @Inject
    @Extension
    private ITypeSystem _iTypeSystem;
    protected ComplexType arrayType;
    protected Package declarationPackage;

    @Override
    public void setUp(CompositeSlot instance, IInterpreter.Context context, IInstanceFactory factory) {
        super.setUp(instance, context, factory);
        Type _type = this._iTypeSystem.getType("array");
        this.arrayType = (ComplexType)_type;
        EObject _eContainer = this.arrayType.eContainer();
        this.declarationPackage = (Package)_eContainer;
    }

    @Override
    public Package declarationPackage() {
        return this.declarationPackage;
    }

    @Override
    public Iterable<Declaration> declarations() {
        return this.arrayType.getAllFeatures();
    }

    @Override
    protected void _doInvoke(ArgumentExpression expr) {
        String _name;
        boolean _equals;
        EObject feature = this.featureOrReference(expr);
        boolean _matched = false;
        if (feature instanceof Operation && (_equals = Objects.equals("add", _name = ((Operation)feature).getName()))) {
            _matched = true;
            this.add();
        }
        if (!_matched && feature instanceof Operation && (_equals = Objects.equals("addAll", _name = ((Operation)feature).getName()))) {
            _matched = true;
            this.addAll();
        }
        if (!_matched && feature instanceof Operation && (_equals = Objects.equals("remove", _name = ((Operation)feature).getName()))) {
            _matched = true;
            this.remove();
        }
        if (!_matched && feature instanceof Operation && (_equals = Objects.equals("removeAll", _name = ((Operation)feature).getName()))) {
            _matched = true;
            this.removeAll();
        }
        if (!_matched && feature instanceof Operation && (_equals = Objects.equals("size", _name = ((Operation)feature).getName()))) {
            _matched = true;
            this.size();
        }
        if (!_matched && feature instanceof Operation && (_equals = Objects.equals("contains", _name = ((Operation)feature).getName()))) {
            _matched = true;
            this.contains();
        }
        if (!_matched && feature instanceof Operation && (_equals = Objects.equals("clear", _name = ((Operation)feature).getName()))) {
            _matched = true;
            this.clear();
        }
        if (!_matched) {
            super._doInvoke(expr);
        }
    }

    protected void clear() {
        this.instanceSlot.getSlots().clear();
    }

    protected void contains() {
        Object value = this.context.popValue();
        Functions.Function1 _function = slot -> {
            Object _value = slot.getValue();
            return Objects.equals(_value, value);
        };
        this.context.pushValue(IterableExtensions.exists((Iterable)this.instanceSlot.getSlots(), (Functions.Function1)_function));
    }

    protected void size() {
        this.context.pushValue(this.instanceSlot.getSlots().size());
    }

    protected void removeAll() {
        Object _popValue = this.context.popValue();
        CompositeSlot removeAll = (CompositeSlot)_popValue;
        Consumer<ExecutionSlot> _function = it -> {
            this.context.pushValue(it.getValue());
            this.remove();
        };
        removeAll.getSlots().forEach(_function);
    }

    protected void remove() {
        Object value = this.context.popValue();
        Functions.Function1 _function = slot -> {
            Object _value = slot.getValue();
            return Objects.equals(_value, value);
        };
        ExecutionSlot slotValue = (ExecutionSlot)IterableExtensions.findFirst((Iterable)this.instanceSlot.getSlots(), (Functions.Function1)_function);
        if (slotValue != null) {
            this.instanceSlot.getSlots().remove(slotValue);
        }
        this.updateIndex();
    }

    protected void addAll() {
        Object _popValue = this.context.popValue();
        CompositeSlot addAll = (CompositeSlot)_popValue;
        Consumer<ExecutionSlot> _function = it -> {
            this.context.pushValue(it.getValue());
            this.add();
        };
        addAll.getSlots().forEach(_function);
    }

    protected void add() {
        Object value = this.context.popValue();
        ExecutionVariable _createExecutionVariable = SRuntimeFactory.eINSTANCE.createExecutionVariable();
        Procedures.Procedure1 _function = slot -> {
            slot.setValue(value);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("[");
            int _size = this.instanceSlot.getSlots().size();
            _builder.append((Object)_size);
            _builder.append("]");
            String _plus = String.valueOf(_builder);
            slot.setName(_plus);
            slot.setType(this._iTypeSystem.getType("any"));
        };
        ExecutionVariable newSlot = (ExecutionVariable)ObjectExtensions.operator_doubleArrow((Object)_createExecutionVariable, (Procedures.Procedure1)_function);
        List _slots = this.instanceSlot.getSlots();
        _slots.add(newSlot);
        this.updateIndex();
        this.context.pushValue(IInterpreter.NULL);
    }

    protected void updateIndex() {
        Procedures.Procedure2 _function = (variable, index) -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("[");
            _builder.append(index);
            _builder.append("]");
            variable.setName(_builder.toString());
        };
        IterableExtensions.forEach((Iterable)this.instanceSlot.getSlots(), (Procedures.Procedure2)_function);
    }

    @Override
    public void set(Object slot, Object value) {
        if (slot == this.instanceSlot) {
            if (slot instanceof CompositeSlot) {
                if (value instanceof CompositeSlot) {
                    ((CompositeSlot)slot).getSlots().clear();
                    Procedures.Procedure2 _function = (s, i) -> {
                        List _slots = ((CompositeSlot)slot).getSlots();
                        Object _copyInstance = this.factory.copyInstance(s);
                        Procedures.Procedure1 _function_1 = it -> {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append("[");
                            _builder.append(i);
                            _builder.append("]");
                            it.setName(_builder.toString());
                            it.setFqName(it.getName());
                        };
                        ExecutionSlot _doubleArrow = (ExecutionSlot)ObjectExtensions.operator_doubleArrow((Object)((ExecutionSlot)_copyInstance), (Procedures.Procedure1)_function_1);
                        _slots.add(_doubleArrow);
                    };
                    IterableExtensions.forEach((Iterable)((CompositeSlot)value).getSlots(), (Procedures.Procedure2)_function);
                } else {
                    this._valueSemantics.setValue(slot, value);
                }
            }
        } else {
            this._valueSemantics.setValue(slot, value);
        }
    }

    @Override
    @XbaseGenerated
    public void doInvoke(Object expr) {
        if (expr instanceof Operation) {
            this._doInvoke((Operation)expr);
            return;
        }
        if (expr instanceof ArgumentExpression) {
            this._doInvoke((ArgumentExpression)expr);
            return;
        }
        if (expr == null) {
            this._doInvoke((Void)null);
            return;
        }
        this._doInvoke(expr);
    }
}

