/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.examples.wizard.service;

import com.google.common.collect.Lists;
import com.yakindu.sct.runtime.ContentTypeHelper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.ide.IDE;

public class ExampleModelOpener {
    public void openModelFiles(IProject project) {
        ArrayList filesToOpen = Lists.newArrayList();
        this.addStatecharts(project, filesToOpen);
        if (filesToOpen == null || this.getPage() == null) {
            return;
        }
        Display.getDefault().asyncExec(() -> {
            try {
                for (IFile file : filesToOpen) {
                    IDE.openEditor((IWorkbenchPage)this.getPage(), (IFile)file, (boolean)false);
                }
                if (this.online()) {
                    String browserid = "org.eclipse.ui.browser.editor";
                    String baseURL = "https://www.itemis.com/en/yakindu/state-machine/documentation/examples/example/";
                    URL url = new URL(baseURL + project.getName().replace(".", "-"));
                    IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(browserid);
                    browser.openURL(url);
                } else {
                    this.openExampleReadme(project);
                }
            }
            catch (MalformedURLException | PartInitException e) {
                e.printStackTrace();
                return;
            }
        });
    }

    protected void openExampleReadme(IProject project) throws PartInitException {
        IResource indexFile = project.findMember("index.html");
        if (indexFile != null) {
            IDE.openEditor((IWorkbenchPage)this.getPage(), (IFile)((IFile)indexFile), (boolean)true);
        }
    }

    private boolean online() {
        block12: {
            Throwable throwable = null;
            Object var2_4 = null;
            Socket socket = new Socket();
            try {
                InetSocketAddress socketAddress = new InetSocketAddress("itemis.com", 80);
                socket.connect(socketAddress, 500);
                socket.close();
                if (socket == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException unknownHost) {
                    return false;
                }
            }
            socket.close();
        }
        return true;
    }

    protected IWorkbenchPage getPage() {
        IWorkbenchWindow workbenchWindow;
        IWorkbenchPage[] pages;
        IWorkbenchWindow[] workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (workbenchWindows.length > 0 && (pages = (workbenchWindow = workbenchWindows[0]).getPages()).length > 0) {
            return pages[0];
        }
        return null;
    }

    protected void addStatecharts(IProject project, List<IFile> filesToOpen) {
        try {
            filesToOpen.addAll(this.findAllStatechartsRecursively((IContainer)project));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public List<IFile> findAllStatechartsRecursively(IContainer container) throws CoreException {
        ArrayList files = Lists.newArrayList();
        IResource[] iResourceArray = container.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            if (r instanceof IContainer) {
                files.addAll(this.findAllStatechartsRecursively((IContainer)r));
            } else if (r instanceof IFile && ContentTypeHelper.isStatechart((IFile)((IFile)r))) {
                files.add((IFile)r);
            }
            ++n2;
        }
        return files;
    }
}

