/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.scoping;

import com.yakindu.base.types.scoping.IPackageImport2URIMapper;
import com.yakindu.sct.model.sgraph.util.ContextElementAdapter;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;

public abstract class AbstractPackageImportUriMapper
implements IPackageImport2URIMapper {
    public abstract Set<IPackageImport2URIMapper.PackageImport> getAllImports(Resource var1);

    public Optional<IPackageImport2URIMapper.PackageImport> findPackageImport(final Resource context, final String packageImport) {
        try {
            return (Optional)TransactionUtil.runExclusive((TransactionalEditingDomain)this.getSharedEditingDomain(), (RunnableWithResult)new RunnableWithResult.Impl<Optional<IPackageImport2URIMapper.PackageImport>>(){

                public void run() {
                    Set<IPackageImport2URIMapper.PackageImport> allImports = AbstractPackageImportUriMapper.this.getAllImports(AbstractPackageImportUriMapper.this.getContextResource(context));
                    for (IPackageImport2URIMapper.PackageImport currentImport : allImports) {
                        if (!currentImport.getName().equals(packageImport)) continue;
                        this.setResult(Optional.of(currentImport));
                        return;
                    }
                    this.setResult(Optional.empty());
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    protected Optional<IFile> getImportedFile(Resource context, String packageImport) {
        IFile file = WorkspaceSynchronizer.getFile((Resource)this.getContextResource(context));
        if (file == null) {
            return Optional.empty();
        }
        if (packageImport.isEmpty()) {
            return Optional.empty();
        }
        IPath importPath = file.getFullPath().removeLastSegments(1).append(packageImport);
        IFile wsFile = ResourcesPlugin.getWorkspace().getRoot().getFile(importPath);
        if (wsFile.exists()) {
            return Optional.of(wsFile);
        }
        return Optional.empty();
    }

    protected Resource getContextResource(final Resource context) {
        TransactionalEditingDomain editingDomain = this.getSharedEditingDomain();
        try {
            return (Resource)editingDomain.runExclusive((Runnable)new RunnableWithResult.Impl<Resource>(){

                public void run() {
                    ContextElementAdapter provider = (ContextElementAdapter)EcoreUtil.getExistingAdapter((Notifier)context, ContextElementAdapter.class);
                    if (provider != null) {
                        this.setResult(provider.getElement().eResource());
                        return;
                    }
                    this.setResult(context);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return context;
        }
    }

    protected TransactionalEditingDomain getSharedEditingDomain() {
        return TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("com.yakindu.sct.domain");
    }
}

