/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.scoping;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.base.expressions.expressions.ExpressionsPackage;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.TypesPackage;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.model.sgraph.util.StatechartUtil;
import com.yakindu.sct.model.stext.stext.StextPackage;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class ContextPredicateProvider {
    @Inject
    StatechartUtil statechartUtil;
    public static final Predicate<IEObjectDescription> EMPTY_PREDICATE = Predicates.alwaysTrue();
    protected static final Predicate<IEObjectDescription> FEATURE = input -> SGraphPackage.Literals.SCOPE.isSuperTypeOf(input.getEClass());
    protected static final Predicate<IEObjectDescription> VARIABLES = Predicates.or(FEATURE, input -> TypesPackage.Literals.PROPERTY.isSuperTypeOf(input.getEClass()));
    protected static final Predicate<IEObjectDescription> EVENTS = Predicates.or(FEATURE, input -> TypesPackage.Literals.EVENT.isSuperTypeOf(input.getEClass()) || TypesPackage.Literals.DECLARATION.isSuperTypeOf(input.getEClass()) && !TypesPackage.Literals.PRIMITIVE_TYPE.isSuperTypeOf(input.getEClass()));
    protected static final Predicate<IEObjectDescription> OPERATIONS = Predicates.or(FEATURE, input -> TypesPackage.Literals.OPERATION.isSuperTypeOf(input.getEClass()));
    protected final Predicate<IEObjectDescription> SUBMACHINES = Predicates.or(FEATURE, input -> input.getEObjectOrProxy() instanceof Property && this.statechartUtil.isOriginStatechart((EObject)((Property)input.getEObjectOrProxy()).getType()));
    protected static final Predicate<IEObjectDescription> ENUMERATIONS = Predicates.or(FEATURE, input -> TypesPackage.Literals.ENUMERATOR.isSuperTypeOf(input.getEClass()) || TypesPackage.Literals.ENUMERATION_TYPE.isSuperTypeOf(input.getEClass()));
    protected static final Predicate<IEObjectDescription> TYPES = input -> TypesPackage.Literals.TYPE.isSuperTypeOf(input.getEClass()) && !TypesPackage.Literals.TYPE_PARAMETER.isSuperTypeOf(input.getEClass());
    protected static final Predicate<IEObjectDescription> ALL = Predicates.alwaysTrue();
    protected final Map<Pair<EClass, EReference>, Predicate<IEObjectDescription>> filter = new HashMap<Pair<EClass, EReference>, Predicate<IEObjectDescription>>();

    public ContextPredicateProvider() {
        this.initMap();
    }

    protected Pair<EClass, EReference> key(EClass eClass) {
        return Tuples.create((Object)eClass, null);
    }

    protected Pair<EClass, EReference> key(EClass eClass, EReference ref) {
        return Tuples.create((Object)eClass, (Object)ref);
    }

    protected void initMap() {
        this.filter.put(this.key(ExpressionsPackage.Literals.ASSIGNMENT_EXPRESSION), (Predicate<IEObjectDescription>)Predicates.or((Predicate[])new Predicate[]{VARIABLES, OPERATIONS, EVENTS, ENUMERATIONS}));
        this.filter.put(this.key(ExpressionsPackage.Literals.ASSIGNMENT_EXPRESSION, ExpressionsPackage.Literals.ASSIGNMENT_EXPRESSION__EXPRESSION), ALL);
        this.filter.put(this.key(ExpressionsPackage.Literals.CONDITIONAL_EXPRESSION), (Predicate<IEObjectDescription>)Predicates.or(VARIABLES, OPERATIONS));
        this.filter.put(this.key(ExpressionsPackage.Literals.LOGICAL_OR_EXPRESSION), (Predicate<IEObjectDescription>)Predicates.or((Predicate[])new Predicate[]{VARIABLES, OPERATIONS, EVENTS, ENUMERATIONS}));
        this.filter.put(this.key(ExpressionsPackage.Literals.LOGICAL_AND_EXPRESSION), (Predicate<IEObjectDescription>)Predicates.or((Predicate[])new Predicate[]{VARIABLES, OPERATIONS, EVENTS, ENUMERATIONS}));
        this.filter.put(this.key(ExpressionsPackage.Literals.LOGICAL_NOT_EXPRESSION), (Predicate<IEObjectDescription>)Predicates.or((Predicate[])new Predicate[]{VARIABLES, OPERATIONS, EVENTS, ENUMERATIONS}));
        this.filter.put(this.key(ExpressionsPackage.Literals.BITWISE_XOR_EXPRESSION), (Predicate<IEObjectDescription>)Predicates.or(VARIABLES, OPERATIONS));
        this.filter.put(this.key(ExpressionsPackage.Literals.BITWISE_OR_EXPRESSION), (Predicate<IEObjectDescription>)Predicates.or(VARIABLES, OPERATIONS));
        this.filter.put(this.key(ExpressionsPackage.Literals.BITWISE_AND_EXPRESSION), (Predicate<IEObjectDescription>)Predicates.or(VARIABLES, OPERATIONS));
        this.filter.put(this.key(ExpressionsPackage.Literals.SHIFT_EXPRESSION), (Predicate<IEObjectDescription>)Predicates.or(VARIABLES, OPERATIONS));
        this.filter.put(this.key(ExpressionsPackage.Literals.LOGICAL_RELATION_EXPRESSION), (Predicate<IEObjectDescription>)Predicates.or((Predicate[])new Predicate[]{VARIABLES, OPERATIONS, EVENTS, ENUMERATIONS}));
        this.filter.put(this.key(ExpressionsPackage.Literals.NUMERICAL_ADD_SUBTRACT_EXPRESSION), (Predicate<IEObjectDescription>)Predicates.or(VARIABLES, OPERATIONS));
        this.filter.put(this.key(ExpressionsPackage.Literals.NUMERICAL_MULTIPLY_DIVIDE_EXPRESSION), (Predicate<IEObjectDescription>)Predicates.or(VARIABLES, OPERATIONS));
        this.filter.put(this.key(ExpressionsPackage.Literals.NUMERICAL_UNARY_EXPRESSION), (Predicate<IEObjectDescription>)Predicates.or(VARIABLES, OPERATIONS));
        this.filter.put(this.key(ExpressionsPackage.Literals.EVENT_RAISING_EXPRESSION), EVENTS);
        this.filter.put(this.key(ExpressionsPackage.Literals.EVENT_RAISING_EXPRESSION, ExpressionsPackage.Literals.EVENT_RAISING_EXPRESSION__VALUE), (Predicate<IEObjectDescription>)Predicates.or((Predicate[])new Predicate[]{VARIABLES, OPERATIONS, EVENTS, ENUMERATIONS}));
        this.filter.put(this.key(ExpressionsPackage.Literals.REGULAR_EVENT_SPEC), EVENTS);
        this.filter.put(this.key(ExpressionsPackage.Literals.EVENT_VALUE_REFERENCE_EXPRESSION), EVENTS);
        this.filter.put(this.key(ExpressionsPackage.Literals.REACTION_EFFECT), (Predicate<IEObjectDescription>)Predicates.or((Predicate[])new Predicate[]{VARIABLES, OPERATIONS, EVENTS, ENUMERATIONS}));
        this.filter.put(this.key(StextPackage.Literals.TRANSITION_SPECIFICATION), EVENTS);
        this.filter.put(this.key(StextPackage.Literals.LOCAL_REACTION), (Predicate<IEObjectDescription>)Predicates.or((Predicate[])new Predicate[]{VARIABLES, OPERATIONS, EVENTS, ENUMERATIONS}));
        this.filter.put(this.key(StextPackage.Literals.TRANSITION_REACTION), (Predicate<IEObjectDescription>)Predicates.or((Predicate[])new Predicate[]{VARIABLES, OPERATIONS, ENUMERATIONS}));
        this.filter.put(this.key(StextPackage.Literals.VARIABLE_DEFINITION, TypesPackage.Literals.TYPE_SPECIFIER__TYPE), TYPES);
        this.filter.put(this.key(StextPackage.Literals.VARIABLE_DEFINITION, ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE), (Predicate<IEObjectDescription>)Predicates.or((Predicate[])new Predicate[]{VARIABLES, OPERATIONS, EVENTS, ENUMERATIONS}));
        this.filter.put(this.key(ExpressionsPackage.Literals.TYPE_CAST_EXPRESSION, ExpressionsPackage.Literals.TYPE_CAST_EXPRESSION__TYPE_SPECIFIER), TYPES);
        this.filter.put(this.key(StextPackage.Literals.STATE_SPECIFICATION), EVENTS);
        this.filter.put(this.key(StextPackage.Literals.SUBMACHINE_REFERENCE_EXPRESSION), this.SUBMACHINES);
    }

    public Predicate<IEObjectDescription> getPredicate(EClass clazz, EReference reference) {
        Predicate<IEObjectDescription> predicate = this.filter.get(this.key(clazz, reference));
        if (predicate == null && (predicate = this.filter.get(this.key(clazz, null))) == null) {
            return EMPTY_PREDICATE;
        }
        return predicate;
    }
}

