/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.validation;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.ReactionTrigger;
import com.yakindu.base.types.Trigger;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.Synchronization;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.stext.concepts.ExitTransition;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import com.yakindu.sct.model.stext.stext.AlwaysEvent;
import com.yakindu.sct.model.stext.stext.ExitPointSpec;
import com.yakindu.sct.model.stext.validation.STextBaseValidator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class STextSynchronizationValidatior
extends STextBaseValidator {
    @Inject
    @Extension
    protected ExitTransition _exitTransition;
    @Inject
    @Extension
    protected StatechartAnnotations _statechartAnnotations;
    public static final String SYNCHRONIZATION_INCOMING_TRIGGER_MSG = "Only one of the incoming transitions should have a trigger to keep the node reachable. Please consider removing trigger(s) or change to CycleBased execution.";
    public static final String SYNCHRONIZATION_INCOMING_TRIGGER_CODE = "synchronization.MoreThanOneIncomingTriggers";
    public static final String SYNCHRONIZATION_EXITPOINT_SPEC_MSG = "This transition is a synchronization transition, thus it can't be an exit transition from exit '%s'. Please remove exit point specification or reconsider using synchronization node.";
    public static final String SYNCHRONIZATION_EXITPOINT_SPEC_CODE = "synchronization.ExitPointSpec";

    @Check(value=CheckType.FAST)
    public void checkSyncTooManyTriggersOnIncomingTransition(Synchronization it) {
        boolean _isEventDriven = this._statechartAnnotations.isEventDriven((Statechart)EcoreUtil2.getContainerOfType((EObject)it, Statechart.class));
        if (_isEventDriven) {
            boolean _greaterThan;
            Functions.Function1 _function = t -> {
                boolean _tripleNotEquals;
                boolean _and = false;
                Trigger _trigger = t.getTrigger();
                boolean bl = _tripleNotEquals = _trigger != null;
                if (!_tripleNotEquals) {
                    _and = false;
                } else {
                    boolean _xifexpression = false;
                    Trigger _trigger_1 = t.getTrigger();
                    if (_trigger_1 instanceof ReactionTrigger) {
                        boolean _xblockexpression = false;
                        Trigger _trigger_2 = t.getTrigger();
                        ReactionTrigger rt = (ReactionTrigger)_trigger_2;
                        Functions.Function1 _function_1 = a -> !(a instanceof AlwaysEvent);
                        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)rt.getTriggers(), (Functions.Function1)_function_1));
                        _xifexpression = _xblockexpression = _size > 0;
                    } else {
                        _xifexpression = false;
                    }
                    _and = _xifexpression;
                }
                return _and;
            };
            Functions.Function1 _function_1 = it_1 -> it_1.getTrigger();
            int _size = IterableExtensions.size((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)it.getIncomingTransitions(), (Functions.Function1)_function), (Functions.Function1)_function_1));
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                this.warning(SYNCHRONIZATION_INCOMING_TRIGGER_MSG, (EObject)it, null, -1, SYNCHRONIZATION_INCOMING_TRIGGER_CODE, new String[0]);
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkJoinHasNoIncomingExitPointSpecTransition(Synchronization it) {
        boolean _tripleNotEquals;
        int _size = it.getIncomingTransitions().size();
        boolean bl = _tripleNotEquals = _size != 1;
        if (_tripleNotEquals) {
            EList _incomingTransitions = it.getIncomingTransitions();
            for (Transition transition : _incomingTransitions) {
                boolean _isNamedExitTransition = this._exitTransition.isNamedExitTransition(transition);
                if (!_isNamedExitTransition) continue;
                this.error(String.format(SYNCHRONIZATION_EXITPOINT_SPEC_MSG, ((ExitPointSpec)IterableExtensions.head((Iterable)Iterables.filter((Iterable)transition.getProperties(), ExitPointSpec.class))).getExitpoint()), (EObject)transition, null, -1, SYNCHRONIZATION_EXITPOINT_SPEC_CODE, new String[0]);
            }
        }
    }
}

