/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.validation;

import com.google.inject.Inject;
import com.yakindu.base.types.Annotation;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import com.yakindu.sct.model.stext.extensions.STextExtensions;
import com.yakindu.sct.model.stext.stext.StatechartSpecification;
import com.yakindu.sct.model.stext.validation.STextBaseValidator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.lib.Extension;

public class SpecificationValidator
extends STextBaseValidator {
    @Inject
    @Extension
    private StatechartAnnotations _statechartAnnotations;
    @Inject
    @Extension
    private STextExtensions _sTextExtensions;
    public static final String CONTRADICTORY_ANNOTATIONS_MSG = "Some annotations (%s) have contradictory effects.";
    public static final String CONTRADICTORY_ANNOTATIONS_CODE = "ContradictoryAnnotations";
    public static final String INTERNAL_EVENT_QUEUE_CANT_BE_DEACTIVATED_MSG = "The internal event queue can't be deactivated for @EventDriven statecharts.";
    public static final String INTERNAL_EVENT_QUEUE_CANT_BE_DEACTIVATED_CODE = "InvalidQueueDeactivation";

    @Check(value=CheckType.FAST)
    public void checkAnnotations(StatechartSpecification statechart) {
        Annotation eventDriven = statechart.getAnnotationOfType("EventDriven");
        Annotation cycleBased = statechart.getAnnotationOfType("CycleBased");
        if (eventDriven != null && cycleBased != null) {
            String errorMsg = String.format(CONTRADICTORY_ANNOTATIONS_MSG, String.join((CharSequence)", ", eventDriven.getType().toString(), cycleBased.getType().toString()));
            this.error(errorMsg, (EObject)cycleBased, null, -1, CONTRADICTORY_ANNOTATIONS_CODE, new String[0]);
        }
        Annotation parentFirst = statechart.getAnnotationOfType("ParentFirstExecution");
        Annotation childFirst = statechart.getAnnotationOfType("ChildFirstExecution");
        if (parentFirst != null && childFirst != null) {
            String errorMsg_1 = String.format(CONTRADICTORY_ANNOTATIONS_MSG, String.join((CharSequence)", ", parentFirst.getType().toString(), childFirst.getType().toString()));
            this.error(errorMsg_1, (EObject)parentFirst, null, -1, CONTRADICTORY_ANNOTATIONS_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkLocalEventQueueForEventDriven(StatechartSpecification specification) {
        Statechart statechart = this._sTextExtensions.getStatechart((EObject)specification);
        if (statechart != null && this._statechartAnnotations.isEventDriven(statechart) && !this._statechartAnnotations.isInternalEventBuffer(statechart)) {
            this.error(INTERNAL_EVENT_QUEUE_CANT_BE_DEACTIVATED_MSG, (EObject)specification.getAnnotationOfType("EventBuffering"), null, -1, INTERNAL_EVENT_QUEUE_CANT_BE_DEACTIVATED_CODE, new String[0]);
        }
    }
}

