/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.ui.sexec.launch.tabs;

import com.yakindu.sct.commons.WorkspaceClassLoaderFactory;
import com.yakindu.sct.runtime.ContentTypeHelper;
import com.yakindu.sct.simulation.core.sexec.launch.ISCTLaunchParameters;
import com.yakindu.sct.simulation.ui.SimulationImages;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;

public class StatechartLaunchConfigurationTab
extends JavaLaunchTab
implements ISCTLaunchParameters {
    public static final String LAUNCH_TAB_ID = "com.yakindu.sct.simulation.sexec.launchTab";
    private Text modelfile;
    private Text operationClass;
    private Button startSuspended;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout(1, true));
        this.createFileSelectionGroup(comp);
        this.createStartAsSuspendedCheckBox(comp);
        new Label(comp, 0);
    }

    private void createFileSelectionGroup(Composite comp) {
        this.createModelFileGroup(comp);
        this.createOperationClassGroup(comp);
    }

    private void createStartAsSuspendedCheckBox(Composite parent) {
        this.startSuspended = new Button(parent, 32);
        this.startSuspended.setText("Start simulation in suspended state");
        this.startSuspended.setLayoutData((Object)new GridData(768));
        this.startSuspended.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatechartLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                StatechartLaunchConfigurationTab.this.setDirty(true);
            }
        });
    }

    private void createOperationClassGroup(Composite parent) {
        Group propertyGroup = new Group(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)propertyGroup);
        propertyGroup.setText("Operation class:");
        propertyGroup.setLayout((Layout)new GridLayout(1, false));
        this.operationClass = new Text((Composite)propertyGroup, 2048);
        this.operationClass.addListener(24, (Listener)new UpdateListener());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.operationClass);
    }

    private void createModelFileGroup(Composite comp) {
        Group fileGroup = new Group(comp, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)fileGroup);
        fileGroup.setText("Model file:");
        fileGroup.setLayout((Layout)new GridLayout(2, false));
        this.modelfile = new Text((Composite)fileGroup, 2048);
        this.modelfile.addListener(24, (Listener)new UpdateListener());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.modelfile);
        Button browse = new Button((Composite)fileGroup, 0);
        browse.setText("Search");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(StatechartLaunchConfigurationTab.this.getShell(), this.getStatechartResources()){

                    protected String adjustPattern() {
                        String pattern = super.adjustPattern();
                        if (pattern.equals("")) {
                            return "*";
                        }
                        return pattern;
                    }
                };
                dialog.setTitle("Select Statechart");
                dialog.setMessage("Please select the statechart file you want to execute.");
                if (dialog.open() == 0) {
                    Object[] files = dialog.getResult();
                    IFile file = (IFile)files[0];
                    StatechartLaunchConfigurationTab.this.modelfile.setText(file.getFullPath().toString());
                }
            }

            private IResource[] getStatechartResources() {
                final ArrayList resources = new ArrayList();
                try {
                    ResourcesPlugin.getWorkspace().getRoot().accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (resource instanceof IFile && ContentTypeHelper.isStatechart((IFile)((IFile)resource))) {
                                resources.add(resource);
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                return resources.toArray(new IResource[0]);
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)browse);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("startSuspended", false);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.modelfile.setText(configuration.getAttribute("filename", ""));
            this.operationClass.setText(configuration.getAttribute("operationClass", ""));
            boolean suspended = configuration.getAttribute("startSuspended", false);
            this.startSuspended.setSelection(suspended);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("filename", this.modelfile.getText());
        configuration.setAttribute("operationClass", this.operationClass.getText());
        configuration.setAttribute("startSuspended", this.startSuspended.getSelection());
    }

    public String getName() {
        return "Main";
    }

    public Image getImage() {
        return SimulationImages.LAUNCHER_ICON.image();
    }

    protected Set<String> getOperationClasses() {
        String operationClasses = this.operationClass.getText();
        HashSet<String> result = new HashSet<String>();
        if (operationClasses.trim().length() > 0) {
            String[] split;
            String[] stringArray = split = operationClasses.split(",");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                result.add(string.trim());
                ++n2;
            }
        }
        return result;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setMessage(null);
        this.setErrorMessage(null);
        String model = this.modelfile.getText().trim();
        if (model.length() > 0 && ResourcesPlugin.getWorkspace().getRoot().findMember(model) == null) {
            this.setErrorMessage("file " + model + " does not exist!");
            return false;
        }
        Set<String> operationClasses = this.getOperationClasses();
        if (operationClasses.size() > 0) {
            for (String clazz : operationClasses) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().findMember(model).getProject();
                if (project == null) continue;
                ClassLoader classLoader = new WorkspaceClassLoaderFactory().createClassLoader(project, ((Object)((Object)this)).getClass().getClassLoader());
                try {
                    Class<?> loadClass = classLoader.loadClass(clazz);
                    loadClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException e) {
                    this.setErrorMessage("Class " + clazz + " not found in project " + project.getName() + "!");
                    return false;
                }
                catch (InstantiationException e) {
                    this.setErrorMessage("Could not instantiate class " + clazz + "! (No default constructor available?) ");
                    return false;
                }
                catch (NoSuchMethodException e) {
                    this.setErrorMessage("Could not instantiate class " + clazz + "! (No default constructor available?) ");
                    return false;
                }
                catch (IllegalAccessException e) {
                    this.setErrorMessage("Could not access class constructor for class" + clazz + "!");
                    return false;
                }
                catch (Throwable t) {
                    this.setErrorMessage(t.getMessage());
                    return false;
                }
            }
        }
        return super.isValid(launchConfig);
    }

    public String getId() {
        return LAUNCH_TAB_ID;
    }

    private class UpdateListener
    implements Listener {
        private UpdateListener() {
        }

        public void handleEvent(Event event) {
            StatechartLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
        }
    }
}

