/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.commons;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;

public class EMFHelper {
    public static List<EClass> getAllSuperClasses(EClass eClass) {
        ArrayList<List<EClass>> superClasses = new ArrayList<List<EClass>>();
        EMFHelper.getSuperClassTree(superClasses, eClass, 0);
        ArrayList<EClass> result = new ArrayList<EClass>();
        for (List list : superClasses) {
            result.addAll(list);
        }
        return result;
    }

    protected static void getSuperClassTree(List<List<EClass>> superClasses, EClass eClass, int depth) {
        if (superClasses.size() <= depth) {
            superClasses.add(depth, new ArrayList());
        }
        EList superTypes = eClass.getESuperTypes();
        superClasses.get(depth).add(eClass);
        for (EClass superType : superTypes) {
            EMFHelper.getSuperClassTree(superClasses, superType, depth + 1);
        }
    }

    public static IFile getIFileFromEMFUri(URI uri) {
        if (uri.isPlatformResource()) {
            String platformString = uri.toPlatformString(true);
            return (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
        }
        if (uri.isFile()) {
            File file = new File(uri.toFileString());
            if (!file.exists()) {
                return null;
            }
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.toURI());
            if (files.length == 1) {
                return files[0];
            }
        }
        return null;
    }
}

