/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.commons;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;

public class WorkspaceClassLoaderFactory {
    private final boolean resolveSimpleProjectReferences;

    public WorkspaceClassLoaderFactory() {
        this(false);
    }

    public WorkspaceClassLoaderFactory(boolean resolveSimpleProjectReferences) {
        this.resolveSimpleProjectReferences = resolveSimpleProjectReferences;
    }

    public ClassLoader createClassLoader(IProject project) {
        return this.createClassLoader(project, WorkspaceClassLoaderFactory.class.getClassLoader());
    }

    public ClassLoader createClassLoader(IProject project, ClassLoader parent) {
        ArrayList urls = Lists.newArrayList();
        this.addClasspathEntries(project, urls);
        return URLClassLoader.newInstance(urls.toArray(new URL[urls.size()]), parent);
    }

    protected void addClasspathEntries(IProject project, List<URL> urls) {
        IJavaProject javaProject = this.toJavaProject(project);
        if (javaProject != null) {
            this.addJavaClasspathEntries(javaProject, urls);
        } else {
            try {
                urls.add(this.getFileSystemFile((IResource)project).toURI().toURL());
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
            if (this.resolveSimpleProjectReferences) {
                this.addReferencedProjectsClasspaths(project, urls);
            }
        }
    }

    protected void addReferencedProjectsClasspaths(IProject project, List<URL> urls) {
        try {
            IProject[] referencedProjects;
            IProject[] iProjectArray = referencedProjects = project.getReferencedProjects();
            int n = referencedProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject iProject = iProjectArray[n2];
                this.addClasspathEntries(iProject, urls);
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected File getFileSystemFile(IResource resource) {
        return new File(resource.getWorkspace().getRoot().getRawLocation().toFile().getAbsolutePath() + File.separator + resource.getFullPath().toFile().getAbsolutePath());
    }

    protected IJavaProject toJavaProject(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject.exists()) {
            return javaProject;
        }
        return null;
    }

    protected void addJavaClasspathEntries(IJavaProject project, List<URL> urls) {
        try {
            urls.addAll(Lists.newArrayList((Object[])WorkspaceClassLoaderFactory.convertClassPath(JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project))));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static URL[] convertClassPath(String[] classPath) {
        URL[] urls = new URL[classPath.length];
        int i = 0;
        while (i < classPath.length) {
            String entry = classPath[i];
            Path path = new Path(entry);
            try {
                URL url;
                urls[i] = url = path.toFile().toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Could not convert classpath entry to URL: " + path.toString(), e);
            }
            ++i;
        }
        return urls;
    }
}

