/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.core.sexec.launch;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.expressions.interpreter.IOperationExecutor;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.domain.extension.IDomain;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.simulation.core.coverage.Measurement;
import com.yakindu.sct.simulation.core.coverage.StatechartMeasurementBuilder;
import com.yakindu.sct.simulation.core.engine.ISimulationEngine;
import com.yakindu.sct.simulation.core.launch.AbstractSCTLaunchConfigurationDelegate;
import com.yakindu.sct.simulation.core.sexec.container.ISimulationEngineFactory;
import com.yakindu.sct.simulation.core.sexec.interpreter.JavaOperationMockup;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;

public class SexecLaunchConfigurationDelegate
extends AbstractSCTLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    @Inject
    private ISimulationEngineFactory factory;
    @Inject
    private Set<IOperationExecutor> mockups;

    protected ISimulationEngine createExecutionContainer(ILaunch launch, Statechart statechart, Injector injector) {
        try {
            IFile file = WorkspaceSynchronizer.getFile((Resource)statechart.eResource());
            injector.injectMembers((Object)this);
            for (IOperationExecutor mockup : this.mockups) {
                if (!(mockup instanceof JavaOperationMockup)) continue;
                IProject project = file.getProject();
                String classes = launch.getLaunchConfiguration().getAttribute("operationClass", "");
                String[] split = classes.split(",");
                ((JavaOperationMockup)mockup).initOperationCallbacks(project, split);
            }
            return this.factory.createExecutionContainer(statechart, launch);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Module getInjectionModule(Statechart statechart, ILaunch launch) {
        Module domainSimulationModule;
        Module simulationModule = super.getInjectionModule(statechart, launch);
        IDomain domain = DomainRegistry.getDomain((EObject)statechart);
        if (domain != null && (domainSimulationModule = domain.getModule("com.yakindu.sct.simulation", new String[0])) != null) {
            simulationModule = Modules.override((Module[])new Module[]{simulationModule}).with(new Module[]{domainSimulationModule});
        }
        StatechartMeasurementBuilder mBuilder = new StatechartMeasurementBuilder();
        final Measurement measurement = mBuilder.buildMeasurement((NamedElement)statechart);
        simulationModule = Modules.override((Module[])new Module[]{simulationModule}).with(new Module[]{new Module(){

            public void configure(Binder binder) {
                binder.bind(Measurement.class).toInstance((Object)measurement);
            }
        }});
        return simulationModule;
    }
}

