/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.ui.document;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.yakindu.base.xtext.utils.jface.concurrent.DeferredUnitOfWork;
import com.yakindu.base.xtext.utils.jface.concurrent.INonBlockingReadAccess;
import com.yakindu.base.xtext.utils.jface.viewers.ParallelReadXtextDocument;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.DocumentTokenSource;
import org.eclipse.xtext.ui.editor.model.edit.ITextEditComposer;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class TransactionalXtextDocument
extends ParallelReadXtextDocument
implements INonBlockingReadAccess<XtextResource>,
INonBlockingReadAccess.Priority<XtextResource> {
    @Inject
    @Named(value="domain.id")
    protected String domainId;
    protected AtomicInteger currentWrites = new AtomicInteger(0);
    private static boolean enforceLongRunningWriteAccess = false;
    private static long enforceLongRunningWriteAccessWaitTime = 7000L;

    @Inject
    public TransactionalXtextDocument(DocumentTokenSource tokenSource, ITextEditComposer composer) {
        super(tokenSource, composer);
    }

    protected TransactionalEditingDomain getDomain() {
        return TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(this.domainId);
    }

    public <T> T tryReadOnlyNonBlocking(IUnitOfWork<T, XtextResource> work, T defaultValue) {
        if (this.currentWrites.get() > 0) {
            return defaultValue;
        }
        return (T)this.tryReadOnly(work);
    }

    public <T> T priorityReadOnlyNonBlocking(IUnitOfWork<T, XtextResource> work, T defaultValue) {
        if (this.currentWrites.get() > 0) {
            return defaultValue;
        }
        return this.priorityReadOnly(work);
    }

    public <T> T readOnly(IUnitOfWork<T, XtextResource> work) {
        if (work instanceof CancelableUnitOfWork) {
            return (T)super.readOnly(new CancelableUnitOfWorkOnTransactionalEditingDomain((CancelableUnitOfWork)work));
        }
        return (T)super.readOnly(new UnitOfWorkOnTransactionalEditingDomain<T>(work));
    }

    public <T> T priorityReadOnly(IUnitOfWork<T, XtextResource> work) {
        if (work instanceof CancelableUnitOfWork) {
            return (T)super.priorityReadOnly(new CancelableUnitOfWorkOnTransactionalEditingDomain((CancelableUnitOfWork)work));
        }
        return (T)super.priorityReadOnly(new UnitOfWorkOnTransactionalEditingDomain<T>(work));
    }

    public <T> T modify(IUnitOfWork<T, XtextResource> work) {
        if (work instanceof CancelableUnitOfWork) {
            return (T)super.modify(new CancelableUnitOfWorkOnTransactionalEditingDomain((CancelableUnitOfWork)work));
        }
        return (T)super.modify(new UnitOfWorkOnTransactionalEditingDomain<T>(work));
    }

    public <T> T internalModify(IUnitOfWork<T, XtextResource> work) {
        try {
            this.currentWrites.incrementAndGet();
            if (enforceLongRunningWriteAccess) {
                Object object = super.internalModify(DeferredUnitOfWork.deferred(work, (long)enforceLongRunningWriteAccessWaitTime));
                return (T)object;
            }
            Object object = super.internalModify(work);
            return (T)object;
        }
        finally {
            this.currentWrites.decrementAndGet();
        }
    }

    public class CancelableUnitOfWorkOnTransactionalEditingDomain<T>
    extends CancelableUnitOfWork<T, XtextResource> {
        private CancelableUnitOfWork<T, XtextResource> delegate;

        public CancelableUnitOfWorkOnTransactionalEditingDomain(CancelableUnitOfWork<T, XtextResource> delegate) {
            this.delegate = delegate;
        }

        public void setCancelIndicator(CancelIndicator cancelIndicator) {
            super.setCancelIndicator(cancelIndicator);
            this.delegate.setCancelIndicator(cancelIndicator);
        }

        public T exec(final XtextResource state, final CancelIndicator cancelIndicator) throws Exception {
            try {
                return (T)TransactionalXtextDocument.this.getDomain().runExclusive((Runnable)new RunnableWithResult.Impl<T>(){

                    public void run() {
                        try {
                            Object result = CancelableUnitOfWorkOnTransactionalEditingDomain.this.delegate.exec((Object)state, cancelIndicator);
                            if (result != null) {
                                this.setResult(result);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public class UnitOfWorkOnTransactionalEditingDomain<T>
    implements IUnitOfWork<T, XtextResource> {
        private IUnitOfWork<T, XtextResource> delegate;

        public UnitOfWorkOnTransactionalEditingDomain(IUnitOfWork<T, XtextResource> delegate) {
            this.delegate = delegate;
        }

        public T exec(final XtextResource state) throws Exception {
            try {
                return (T)TransactionalXtextDocument.this.getDomain().runExclusive((Runnable)new RunnableWithResult.Impl<T>(){

                    public void run() {
                        try {
                            Object result = UnitOfWorkOnTransactionalEditingDomain.this.delegate.exec((Object)state);
                            if (result != null) {
                                this.setResult(result);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

