/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.ui.help;

import com.google.inject.Inject;
import com.yakindu.base.types.AnnotationType;
import com.yakindu.base.types.Property;
import com.yakindu.base.utils.jface.help.AbstractUserHelpDocumentationProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.documentation.impl.MultiLineCommentDocumentationProvider;

public abstract class SCTUserHelpDocumentationProvider
extends AbstractUserHelpDocumentationProvider
implements IEObjectDocumentationProvider {
    @Inject
    private MultiLineCommentDocumentationProvider delegate;

    public String getDocumentation(EObject o) {
        if (o instanceof Keyword) {
            return this.getHelpText(this.getHelpId((Keyword)o));
        }
        if (o instanceof AnnotationType) {
            return this.getHelpText(this.getHelpId((AnnotationType)o));
        }
        if (o instanceof Property && ((Property)o).getTypeSpecifier() != null) {
            return ((Property)o).getTypeSpecifier().toString();
        }
        return this.delegate.getDocumentation(o);
    }

    protected String getHelpText(String name) {
        String helpContent = this.getHelp(this.getPluginId() + "." + this.getContextId());
        int beginIndex = helpContent.indexOf("<!-- Start " + name + " -->");
        int endIndex = helpContent.indexOf("<!-- End " + name + " -->");
        if (beginIndex >= 0 && endIndex >= 0 && endIndex > beginIndex) {
            return helpContent.substring(beginIndex, endIndex);
        }
        return "";
    }

    protected String getHelpId(Keyword keyword) {
        return this.getContextId() + "_" + keyword.getValue();
    }

    protected String getHelpId(AnnotationType annot) {
        return this.getContextId() + "_" + annot.getName().toLowerCase();
    }

    protected abstract String getContextId();

    protected abstract String getPluginId();
}

