/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.product.intro;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class OpenExampleIntroAction
implements IIntroAction {
    private static final String WIZARD_ID_KEY = "wizardId";
    private static final String EXAMPLE_ID = "exampleId";

    public void run(IIntroSite site, Properties params) {
        String wizardId = (String)params.get(WIZARD_ID_KEY);
        String exampleId = (String)params.get(EXAMPLE_ID);
        List<String> exampleIds = new ArrayList<String>();
        if (exampleId != null) {
            exampleIds = Arrays.asList(exampleId.split(","));
        }
        this.openWizard(wizardId, exampleIds);
    }

    public void openWizard(String wizardId, List<String> exampleIds) {
        IWizardDescriptor descriptor = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(wizardId);
        if (descriptor == null) {
            descriptor = PlatformUI.getWorkbench().getImportWizardRegistry().findWizard(wizardId);
        }
        if (descriptor == null) {
            descriptor = PlatformUI.getWorkbench().getExportWizardRegistry().findWizard(wizardId);
        }
        try {
            if (descriptor != null) {
                IWorkbenchWizard wizard = descriptor.createWizard();
                WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                wd.setTitle(wizard.getWindowTitle());
                this.setExampleID((IWizard)wizard, exampleIds);
                int open = wd.open();
                if (open == 0) {
                    IIntroManager introManager = PlatformUI.getWorkbench().getIntroManager();
                    introManager.closeIntro(introManager.getIntro());
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void setExampleID(IWizard wizard, List<String> exampleIds) {
        try {
            Field page = wizard.getClass().getDeclaredField("page");
            page.setAccessible(true);
            Object iWizardPage = page.get(wizard);
            Field declaredField = iWizardPage.getClass().getDeclaredField("exampleIdsToInstall");
            declaredField.setAccessible(true);
            declaredField.set(iWizardPage, exampleIds);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
    }
}

