/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sgraph.validation;

import com.yakindu.sct.model.sgraph.CompositeElement;
import com.yakindu.sct.model.sgraph.Synchronization;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.model.sgraph.util.SGgraphUtil;
import com.yakindu.sct.model.sgraph.validation.AbstractSGraphValidator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.validation.Check;

public class TransitionValidator
extends AbstractSGraphValidator {
    private static final String RANSITION_SOURCE_NOT_ORTHOGONAL_TO_TARGET_MSG = "Source and target of a transition must not be located in orthogonal regions!";
    public static final String TRANSITION_SOURCE_NOT_ORTHOGONAL_TO_TARGET_CODE = "transition.SourceNotOrthogonalToTarget";

    @Check
    public void checkTransitionSourceNotOrthogonalToTarget(Transition transition) {
        Vertex source = transition.getSource();
        Vertex target = transition.getTarget();
        if (source instanceof Synchronization || target instanceof Synchronization) {
            return;
        }
        EObject commonAncestor = SGgraphUtil.commonAncestor((EObject)source, (EObject)target);
        if (commonAncestor instanceof CompositeElement) {
            this.error(RANSITION_SOURCE_NOT_ORTHOGONAL_TO_TARGET_MSG, transition, null, -1, TRANSITION_SOURCE_NOT_ORTHOGONAL_TO_TARGET_CODE, new String[0]);
        }
    }
}

