/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.c;

import com.google.inject.Inject;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sctunit.generator.base.ISCTUnitGenerator;
import com.yakindu.sctunit.generator.c.extensions.GTest;
import com.yakindu.sctunit.generator.c.extensions.Genmodel;
import com.yakindu.sctunit.generator.c.extensions.JUnitTest;
import com.yakindu.sctunit.generator.c.extensions.TimerService;
import com.yakindu.sctunit.generator.c.extensions.TimerServiceHeader;
import com.yakindu.sctunit.generator.c.features.CSCTUnitGenmodelEntries;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitElement;
import com.yakindu.sctunit.sCTUnit.TestPackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;

public class CSCTUnitGenerator
implements ISCTUnitGenerator {
    @Inject
    @Extension
    private JUnitTest jUnitTest;
    @Inject
    @Extension
    private CSCTUnitGenmodelEntries _cSCTUnitGenmodelEntries;
    @Inject
    @Extension
    private GTest gTest;
    @Inject
    @Extension
    private TimerService timerService;
    @Inject
    @Extension
    private TimerServiceHeader timerServiceHeader;
    @Inject
    @Extension
    private Genmodel genModel;
    @Inject
    protected ICoreLibraryHelper helper;

    public void generate(GeneratorEntry entry, IFileSystemAccess fsa) {
        SCTUnitElement _get;
        String targetProjectName = this.helper.getTargetProjectValue(entry).getStringValue();
        String gTestOutletFolderString = this._cSCTUnitGenmodelEntries.getTargetFolderString(entry);
        TestPackage testPackage = this._cSCTUnitGenmodelEntries.getTestPackage(entry);
        String targetProjectPath = this._cSCTUnitGenmodelEntries.getJavaPackageForProjectName(targetProjectName);
        boolean _isJUnitWrapper = this._cSCTUnitGenmodelEntries.isJUnitWrapper(entry);
        if (_isJUnitWrapper) {
            this.jUnitTest.generateJUnitTest(testPackage, fsa, targetProjectPath);
        }
        if ((_get = (SCTUnitElement)EcoreUtil2.getAllContentsOfType((EObject)testPackage, SCTUnitElement.class).get(0)) instanceof SCTUnitClass) {
            SCTUnitElement _get_1 = (SCTUnitElement)EcoreUtil2.getAllContentsOfType((EObject)testPackage, SCTUnitElement.class).get(0);
            SCTUnitClass sctunitClass = (SCTUnitClass)_get_1;
            this.gTest.generateGTest(sctunitClass, fsa, gTestOutletFolderString);
            boolean _isSGen = this._cSCTUnitGenmodelEntries.isSGen(entry);
            if (_isSGen) {
                this.genModel.generateGenmodel(sctunitClass, fsa);
            }
            this.timerService.generateTimerService(sctunitClass, fsa, gTestOutletFolderString);
            this.timerServiceHeader.generateTimerServiceHeader(sctunitClass, fsa, gTestOutletFolderString);
        }
    }
}

