/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.ui.wizard;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitElement;
import com.yakindu.sctunit.sCTUnit.SCTUnitPackage;
import com.yakindu.sctunit.sCTUnit.TestPackage;
import com.yakindu.sctunit.ui.wizard.SCTUnitSuiteWizardSelectionPage;
import com.yakindu.sctunit.ui.wizard.SCTUnitWizard;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContextType;

public class SCTUnitSuiteWizard
extends SCTUnitWizard {
    @Inject
    public XtextTemplateContextType templateContextType;

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("New SCTUnit Test Suite");
        this.setNeedsProgressMonitor(true);
        super.init(workbench, selection);
    }

    @Override
    protected void setTitleAndDescription() {
        this.filePage.setTitle("SCTUnit Test Suite");
        this.filePage.setDescription("Create a new SCTUnit Test Suite");
        this.filePage.setFileName("StatechartTestSuite");
    }

    @Override
    protected void create2ndPage() {
        this.statechartPage = new SCTUnitSuiteWizardSelectionPage(this.filePage, "Choose Test Classes");
        this.statechartPage.setTitle("SCTUnit Testconfiguration");
        this.statechartPage.setDescription("Select a statechart");
    }

    @Override
    protected CharSequence getEmptyTemplate(IFile fileToCreate) {
        CharSequence model = this.creator.createInitialSuite(fileToCreate.getName());
        return model;
    }

    @Override
    protected CharSequence getContentToCreate(IFile fileToCreate, List<IFile> selection) {
        return this.creator.createInitialSuite(fileToCreate.getName(), this.loadTestClasses(selection));
    }

    protected List<SCTUnitElement> loadTestClasses(List<IFile> iFiles) {
        ArrayList selectedClasses = Lists.newArrayList();
        for (IFile iFile : iFiles) {
            URI uri = URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true);
            Resource.Factory factory = ResourceFactoryRegistryImpl.INSTANCE.getFactory(uri);
            Resource resource = factory.createResource(uri);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResources().add((Object)resource);
            try {
                resource.load(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            TestPackage testPackage = (TestPackage)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SCTUnitPackage.Literals.TEST_PACKAGE);
            SCTUnitClass testClass = (SCTUnitClass)EcoreUtil2.getObjectByType((Collection)testPackage.getMember(), (EClassifier)SCTUnitPackage.Literals.SCT_UNIT_CLASS);
            if (testClass == null) continue;
            selectedClasses.add(testClass);
        }
        return selectedClasses;
    }
}

