/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.ui.wizard;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sctunit.ui.wizard.SCTUnitModelCreator;
import com.yakindu.sctunit.ui.wizard.SCTUnitWizardPage;
import com.yakindu.sctunit.ui.wizard.SCTUnitWizardPage2;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContextType;
import org.eclipse.xtext.util.StringInputStream;

public class SCTUnitWizard
extends BasicNewResourceWizard
implements INewWizard {
    protected SCTUnitWizardPage filePage;
    protected SCTUnitWizardPage2 statechartPage;
    @Inject
    protected SCTUnitModelCreator creator;
    @Inject
    @Named(value="languageName")
    protected String languageName;
    @Inject
    public XtextTemplateContextType templateContextType;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("New SCTUnit Test Class");
        this.setNeedsProgressMonitor(true);
        super.init(workbench, selection);
    }

    public void addPages() {
        this.filePage = new SCTUnitWizardPage("fileName", this.selection, "sctunit");
        this.setTitleAndDescription();
        this.addPage((IWizardPage)this.filePage);
        this.create2ndPage();
        this.addPage((IWizardPage)this.statechartPage);
    }

    protected void create2ndPage() {
        this.statechartPage = new SCTUnitWizardPage2(this.filePage, "Choose Statechart Model");
        this.statechartPage.setTitle("SCTUnit Testconfiguration");
        this.statechartPage.setDescription("Select a statechart");
    }

    protected void setTitleAndDescription() {
        this.filePage.setTitle("SCTUnit Test Class");
        this.filePage.setDescription("Create a new SCTUnit TestClass");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        IFile fileToCreate = this.filePage.createNewFile();
        try {
            if (this.statechartPage.getSelection() != null && !this.statechartPage.getSelection().isEmpty()) {
                List<IFile> selection = this.statechartPage.getSelection();
                if (fileToCreate == null) {
                    return false;
                }
                this.selectAndReveal((IResource)fileToCreate);
                CharSequence model = this.getContentToCreate(fileToCreate, selection);
                fileToCreate.setContents((InputStream)new StringInputStream(model.toString()), true, false, (IProgressMonitor)new NullProgressMonitor());
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(fileToCreate), "com.yakindu.sctunit.SCTUnit");
                return true;
            }
            this.selectAndReveal((IResource)fileToCreate);
            CharSequence model = this.getEmptyTemplate(fileToCreate);
            fileToCreate.setContents((InputStream)new StringInputStream(model.toString()), true, false, (IProgressMonitor)new NullProgressMonitor());
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(fileToCreate), "com.yakindu.sctunit.SCTUnit");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected CharSequence getEmptyTemplate(IFile fileToCreate) {
        CharSequence model = this.creator.createInitialModel(fileToCreate.getName());
        return model;
    }

    protected CharSequence getContentToCreate(IFile fileToCreate, List<IFile> selection) {
        return this.creator.createInitialModel(fileToCreate.getName(), this.loadStatechartModel(selection.get(0)));
    }

    protected Statechart loadStatechartModel(IFile iFile) {
        URI uri = URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true);
        XMIResourceImpl resource = new XMIResourceImpl(uri);
        try {
            resource.load(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (Statechart)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SGraphPackage.Literals.STATECHART);
    }
}

