/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.python.files;

import com.google.inject.Inject;
import com.yakindu.sct.generator.core.extensions.StringHelper;
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.generator.python.GenmodelEntries;
import com.yakindu.sct.generator.python.files.PackageInit;
import com.yakindu.sct.generator.python.naming.Naming;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;

public class DefaultTimer {
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    private StringHelper _stringHelper;
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    private PackageInit _packageInit;
    @Inject
    @Extension
    private ICoreLibraryHelper _iCoreLibraryHelper;
    @Inject
    @Extension
    private OutputConfigProvider _outputConfigProvider;

    public void generateTimer(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
        boolean _skipLibraryFiles = this._iCoreLibraryHelper.getSkipLibraryFiles(entry);
        if (_skipLibraryFiles) {
            return;
        }
        String _path = this._stringHelper.toPath(this._genmodelEntries.getLibraryPackage(entry));
        String path = _path + "/timer";
        String _py = this._naming.py(this._naming.Timer());
        String _plus = path + "/" + _py;
        fsa.generateFile(_plus, this._outputConfigProvider.getLibraryOutputConfig(entry), this.content(entry));
        this._packageInit.generatePyPackageInit(fsa, path, this._outputConfigProvider.getLibraryOutputConfig(entry), entry);
    }

    private CharSequence content(GeneratorEntry entry) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"\"\" DefaultTimer module.");
        _builder.newLine();
        String _licenseText = this._genmodelEntries.getLicenseText(entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.newLine();
        CharSequence _createImports = this.createImports(entry);
        _builder.append((Object)_createImports);
        _builder.newLineIfNotEmpty();
        CharSequence _createTimer = this.createTimer(entry);
        _builder.append((Object)_createTimer);
        _builder.newLineIfNotEmpty();
        CharSequence _createSingleTimer = this.createSingleTimer(entry);
        _builder.append((Object)_createSingleTimer);
        _builder.newLineIfNotEmpty();
        CharSequence _createRepeatedTimer = this.createRepeatedTimer(entry);
        _builder.append((Object)_createRepeatedTimer);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence createImports(GeneratorEntry entry) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("import threading");
        _builder.newLine();
        _builder.append("import time");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    private CharSequence createSingleTimer(GeneratorEntry entry) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("class SingleTimer:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"Call `function` after `period` seconds.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def __init__(self, period, callback, event_id):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.callback = callback");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.event_id = event_id");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.single_timer = threading.Timer(period, self.callback.time_elapsed, [self.event_id])");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.single_timer.start()");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    private CharSequence createRepeatedTimer(GeneratorEntry entry) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("class RepeatedTimer:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"Repeat `callback` every `interval` seconds.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def __init__(self, interval, callback, event_id):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.interval = interval");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.callback = callback");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.event_id = event_id");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.start = time.time()");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.event = threading.Event()");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.thread = threading.Thread(target=self._target)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.thread.start()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def _target(self):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("while not self.event.wait(self._time):");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.callback.time_elapsed(self.event_id)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@property");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def _time(self):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return self.interval - ((time.time() - self.start) % self.interval)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def stop(self):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"\"\"Stops the repeated timer.");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.event.set()");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("try:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.thread.join()");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("except RuntimeError:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("print('Can not join thread')");
        _builder.newLine();
        return _builder;
    }

    private CharSequence createTimer(GeneratorEntry entry) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("class TimerService:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"Default timer service for timed statecharts.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def __init__(self):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.is_default_timer = True");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.timer_queue = {}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.lock = threading.RLock()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _createSetTimer = this.createSetTimer();
        _builder.append((Object)_createSetTimer, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _createUnsetTimer = this.createUnsetTimer();
        _builder.append((Object)_createUnsetTimer, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _cancelTimer = this.cancelTimer();
        _builder.append((Object)_cancelTimer, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    private CharSequence createSetTimer() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("def set_timer(self, callback, event_id, interval, periodic):");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"Schedule the time event.");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Checks if the given time event is already in queue and creates a");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("timer based on the `periodic`parameter (Single or Repeat).");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Note: statemachine class converts time from sec to milliseconds,");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("so do vice versa.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("timer_id = (callback, event_id)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if timer_id in self.timer_queue:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.unset_timer(callback, event_id)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("m_interval = float(interval)/1000.0");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if periodic is False:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.timer_queue[timer_id] = SingleTimer(m_interval, callback, event_id)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("else:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.timer_queue[timer_id] = RepeatedTimer(m_interval, callback, event_id)");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    private CharSequence createUnsetTimer() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("def unset_timer(self, callback, event_id):");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"Cancel a certain event identified bei `callback` and `event_id`.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("timer_id = (callback, event_id)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("with self.lock:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if timer_id in self.timer_queue:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("event_timer = self.timer_queue[timer_id]");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if isinstance(event_timer, RepeatedTimer):");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("event_timer.stop()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("else:");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("event_timer.single_timer.cancel()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("del event_timer");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    private CharSequence cancelTimer() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("def cancel(self):");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"Cancel all events that are currently running.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("with self.lock:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for (callback, event_id) in self.timer_queue:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.unset_timer(callback, event_id)");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

