/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.python.files;

import com.google.inject.Inject;
import com.yakindu.sct.generator.core.extensions.StringHelper;
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.generator.python.GenmodelEntries;
import com.yakindu.sct.generator.python.files.PackageInit;
import com.yakindu.sct.generator.python.naming.Naming;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class RuntimeService {
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    private StringHelper _stringHelper;
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    private PackageInit _packageInit;
    @Inject
    @Extension
    private ICoreLibraryHelper _iCoreLibraryHelper;
    @Inject
    @Extension
    private OutputConfigProvider _outputConfigProvider;

    public void generateRuntimeService(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
        boolean _not;
        boolean _skipLibraryFiles = this._iCoreLibraryHelper.getSkipLibraryFiles(entry);
        if (_skipLibraryFiles) {
            return;
        }
        String path = this._stringHelper.toPath(this._genmodelEntries.getLibraryPackage(entry));
        String _py = this._naming.py(this._naming.runtimeServiceClass());
        String _plus = path + "/" + _py;
        fsa.generateFile(_plus, this._outputConfigProvider.getLibraryOutputConfig(entry), this.content(entry));
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)path);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            this._packageInit.generatePyPackageInit(fsa, path, this._outputConfigProvider.getLibraryOutputConfig(entry), entry);
        }
    }

    private CharSequence content(GeneratorEntry entry) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"\"\"");
        String _licenseText = this._genmodelEntries.getLicenseText(entry);
        _builder.append(_licenseText);
        _builder.append("\"\"\"");
        _builder.newLineIfNotEmpty();
        _builder.append("import sched");
        _builder.newLine();
        _builder.append("import time  # time in sec represented as floating point number -> 100ms = 0.1s");
        _builder.newLine();
        _builder.append("import threading");
        _builder.newLine();
        _builder.newLine();
        _builder.append("class RuntimeService(object):");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Runtime service for state machines to execute a run to completion step");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("periodically.");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def __init__(self):");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#private static RuntimeService runtimeService;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("self.scheduler = sched.scheduler(time.time, time.sleep)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# <Long,StatemachineTimerTask>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("self.timer_tasks_dict = {}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("class StatemachineTimerTask(object):");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def __init__(self):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.statemachine_list = []");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.rlock = threading.RLock()");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.is_paused = False");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("def run(self):");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("# readLock");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.rlock.acquire()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if not isPaused:");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("for statemachine in statemachine_list:");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("statemachine.run_cycle()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.rlock.release()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("def add_statemachine(self, statemachine):");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Adds the given state machine to the TimerTask.");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Keyword Argument:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("[IStatemachine] statemachine");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("# writeLock");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.rlock.acquire()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("ret = False");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("try:");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("statemachine_list.append(statemachine)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("ret = True");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("except (ValueError, NameError):");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("print('Statemachine cant be added. Check variable definition.')");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.rlock.release()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return ret");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("def remove_statemachine(self, statemachine):");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Removes the given state machine from the TimerTask.");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Keyword Argument:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("[IStatemachine] statemachine");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Return:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("True if state machine is removed properly.");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("# writeLock");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.rlock.acquire()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("ret = False");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("try:");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("statemachine_list.remove(statemachine)");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("ret == True");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("except ValueError:");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("print('Statemachine to remove not found')");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.rlock.release()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return ret");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("def pause(self):");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.is_paused = True");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("def resume(self) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("self.is_paused = False");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def register_statemachine(self, statemachine, cycle_period):");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Registers an {@link IStatemachine} for scheduled fixed rate execution.");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Keyword Arguments:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("[IStatemachine] statemachine - The state machine to execute");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("[long] cycle_period - the fixed rate cycle period for scheduling");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Return:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("True if state machine is added properly.");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if cycle_period in self.timerTasks:");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// TimerTask for cycle time already existing -> add state machine");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return self.timer_tasks_dict[cycle_period].add_statemachine(statemachine)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// Create new TimerTask for cycle period and add state machine");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timer_task = self.StatemachineTimerTask()");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timer_tasks_dict[cycle_period] = timer_task");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("ret = timer_task.add_statemachine(statemachine)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// Create a new Timer instance if runtime service was cancelled");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// before");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (timer == null) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("timer = new Timer();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timer.scheduleAtFixedRate(timerTask, 0, cyclePeriod);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return ret;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def unregister_statemachine(self, statemachine, cycle_period):");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Removes the given state machine from runtime service.");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Keyword Arguments:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("[IStatemachine] statemachine - the state machine to be removed.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("[long] cyclePeriod - the scheduling cycle period of the state machine.");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Return:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("True if state machine is removed properly.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (timerTasks.containsKey(cyclePeriod)) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("boolean ret = timerTasks.get(cyclePeriod).removeStatemachine(");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("statemachine);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return ret;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def cancel_all(self, cycle_period):");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Cancels the execution of state machines for the given cycle period. This");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("stops the execution of state machines which are registered for the given");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("cycle period and cancels the executing {@link TimerTask}.");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Keyword Argument:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("[long] cyclePeriod");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Return:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("True if poperly cancelled.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (timer != null && timerTasks.containsKey(cyclePeriod)) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("TimerTask task = timerTasks.get(cyclePeriod);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("task.cancel();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("timer.purge();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("timerTasks.remove(cyclePeriod);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def pause_all(self, cycle_period):");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Pauses the execution of all state machines which are registered for the");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("given cyclePeriod.");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Keyword Argument:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("[long] cyclePeriod");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Return:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("True if properly paused");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (timerTasks.containsKey(cyclePeriod)) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("timerTasks.get(cyclePeriod).pause();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def resume_all(self, cycle_period):");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Resumes the execution of all state machines which are registered for the");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("given cyclePeriod.");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Keyword Argument:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("[long] cyclePeriod");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Return:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("True if properly resumed.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (timerTasks.containsKey(cyclePeriod)) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("timerTasks.get(cyclePeriod).resume();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("def cancel_timer(self):");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Cancels the execution of all registered state machines. This cancels the");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("executing {@link Timer} freeing all allocated resources and terminates");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("all existing execution threads.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if not self.timer:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.timer.cancel();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.timer.purge();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.timerTasks.clear();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("self.timer = None");
        _builder.newLine();
        return _builder;
    }
}

