/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.python.extensions;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.TimeEventSpec;
import com.yakindu.base.types.Declaration;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.generator.python.naming.Naming;
import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import com.yakindu.sctunit.generator.base.extensions.BaseNamingExtensions;
import com.yakindu.sctunit.generator.base.extensions.BaseNavigationExtensions;
import com.yakindu.sctunit.generator.python.extensions.NamingExtensions;
import com.yakindu.sctunit.generator.python.features.PythonSCTUnitGenmodelEntries;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitElement;
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite;
import com.yakindu.sctunit.sCTUnit.TestPackage;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class JUnitTest {
    @Inject
    protected NamingExtensions naming;
    @Inject
    @Extension
    private BaseNamingExtensions _baseNamingExtensions;
    @Inject
    @Extension
    private BaseNavigationExtensions _baseNavigationExtensions;
    @Inject
    @Extension
    private PythonSCTUnitGenmodelEntries _pythonSCTUnitGenmodelEntries;
    @Inject
    @Extension
    private StatechartAnnotations _statechartAnnotations;
    @Inject
    protected GeneratorEntry entry;
    @Inject
    @Extension
    protected Naming _naming;
    @Inject
    protected ICoreLibraryHelper helper;

    public void generateJUnitTest(TestPackage it, IFileSystemAccess fsa, String targetProjectName) {
        String targetProjectString = this.helper.getTargetProjectValue(this.entry).getStringValue();
        CharSequence content = this.generateTest(this._baseNavigationExtensions.getSCTUnitElement(it), targetProjectString);
        fsa.generateFile(this._baseNamingExtensions.java(this._baseNamingExtensions.testClassName(this._baseNavigationExtensions.getSCTUnitElement(it))), "PYTHON_JUNIT_OUTPUT", content);
    }

    protected CharSequence _generateTest(SCTUnitClass it, String targetProjectString) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._pythonSCTUnitGenmodelEntries.getLicenseText(this.entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        _builder.append(targetProjectString);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this._baseNamingExtensions.namespace((Declaration)this._baseNavigationExtensions.getTestPackage((SCTUnitElement)it)).toString());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append(".");
        }
        CharSequence _namespace = this._baseNamingExtensions.namespace((Declaration)it);
        _builder.append((Object)_namespace);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import org.junit.Before;");
        _builder.newLine();
        _builder.append("import org.junit.runner.RunWith;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@PythonTest(");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("statechartBundle = \"");
        String _segment = it.getStatechart().eResource().getURI().segment(1);
        _builder.append(_segment, "\t");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("sourceFile = \"");
        String _targetFolderString = this._pythonSCTUnitGenmodelEntries.getTargetFolderString(this.entry);
        _builder.append(_targetFolderString, "\t");
        _builder.append("/");
        String _lowerCase = this._baseNamingExtensions.testClassName((SCTUnitElement)it).toLowerCase();
        _builder.append(_lowerCase, "\t");
        _builder.append("/");
        String _py = this._naming.py(this.naming.testClassName((SCTUnitElement)it));
        _builder.append(_py, "\t");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("program = \"");
        String _targetFolderString_1 = this._pythonSCTUnitGenmodelEntries.getTargetFolderString(this.entry);
        _builder.append(_targetFolderString_1, "\t");
        _builder.append("/");
        String _lowerCase_1 = this._baseNamingExtensions.testClassName((SCTUnitElement)it).toLowerCase();
        _builder.append(_lowerCase_1, "\t");
        _builder.append("/");
        String _className = this._baseNamingExtensions.className((EObject)it.getStatechart());
        _builder.append(_className, "\t");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("model = \"");
        String _modelFromUri = this.getModelFromUri(it.getStatechart().eResource().getURI());
        _builder.append(_modelFromUri, "\t");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("additionalFilesToCopy = {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("\"");
        CharSequence _targetFolder = this.targetFolder();
        _builder.append((Object)_targetFolder, "\t\t");
        _builder.append("/");
        String _lowerCase_2 = this._baseNamingExtensions.testClassName((SCTUnitElement)it).toLowerCase();
        _builder.append(_lowerCase_2, "\t\t");
        _builder.append("/__init__.py\"");
        if (this._statechartAnnotations.isCycleBased(it.getStatechart()) || this.isTimed(it.getStatechart())) {
            _builder.append(",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\"");
            CharSequence _targetFolder_1 = this.targetFolder();
            _builder.append((Object)_targetFolder_1, "\t\t");
            _builder.append("/");
            String _lowerCase_3 = this._baseNamingExtensions.testClassName((SCTUnitElement)it).toLowerCase();
            _builder.append(_lowerCase_3, "\t\t");
            _builder.append("/vtimer/__init__.py\",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\"");
            CharSequence _targetFolder_2 = this.targetFolder();
            _builder.append((Object)_targetFolder_2, "\t\t");
            _builder.append("/");
            String _lowerCase_4 = this._baseNamingExtensions.testClassName((SCTUnitElement)it).toLowerCase();
            _builder.append(_lowerCase_4, "\t\t");
            _builder.append("/vtimer/interface_timer.py\",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\"");
            CharSequence _targetFolder_3 = this.targetFolder();
            _builder.append((Object)_targetFolder_3, "\t\t");
            _builder.append("/");
            String _lowerCase_5 = this._baseNamingExtensions.testClassName((SCTUnitElement)it).toLowerCase();
            _builder.append(_lowerCase_5, "\t\t");
            _builder.append("/vtimer/virtual_timer.py\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append(")");
        _builder.newLine();
        _builder.append("@RunWith(PythonTestRunner.class)");
        _builder.newLine();
        _builder.append("public class ");
        String _testClassName = this._baseNamingExtensions.testClassName((SCTUnitElement)it);
        _builder.append(_testClassName);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected final PythonTestHelper helper = new PythonTestHelper(this);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Before");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setUp() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("helper.generate();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence targetFolder() {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        FeatureParameterValue _libraryTargetFeature = this._pythonSCTUnitGenmodelEntries.getLibraryTargetFeature(this.entry);
        boolean bl = _tripleEquals = _libraryTargetFeature == null;
        if (_tripleEquals) {
            String _targetFolderString = this._pythonSCTUnitGenmodelEntries.getTargetFolderString(this.entry);
            _builder.append(_targetFolderString);
        } else {
            String _libraryTargetFolderString = this._pythonSCTUnitGenmodelEntries.getLibraryTargetFolderString(this.entry);
            _builder.append(_libraryTargetFolderString);
        }
        return _builder;
    }

    public String asPath(String namespace) {
        if (namespace != null && !namespace.isEmpty()) {
            String _replace = namespace.replace(".", "/");
            return _replace + "/";
        }
        return "";
    }

    protected CharSequence _generateTest(SCTUnitSuite it, String targetProjectString) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._pythonSCTUnitGenmodelEntries.getLicenseText(this.entry);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        _builder.append(targetProjectString);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this._baseNamingExtensions.namespace((Declaration)this._baseNavigationExtensions.getTestPackage((SCTUnitElement)it)).toString());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append(".");
        }
        CharSequence _namespace = this._baseNamingExtensions.namespace((Declaration)it);
        _builder.append((Object)_namespace);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("import org.junit.runner.RunWith;");
        _builder.newLine();
        _builder.append("import org.junit.runners.Suite;");
        _builder.newLine();
        _builder.append("import org.junit.runners.Suite.SuiteClasses;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@RunWith(Suite.class)");
        _builder.newLine();
        _builder.append("@SuiteClasses({");
        _builder.newLine();
        Iterable _sCTUnitClasses = this._baseNavigationExtensions.getSCTUnitClasses(it);
        boolean _hasElements = false;
        for (SCTUnitClass group : _sCTUnitClasses) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append("\t");
            String _testClassName = this._baseNamingExtensions.testClassName((SCTUnitElement)group);
            _builder.append(_testClassName, "\t");
            _builder.append(".class");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("})");
        _builder.newLine();
        _builder.append("public class ");
        String _className = this._baseNamingExtensions.className((EObject)it);
        _builder.append(_className);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected boolean isTimed(SCTUnitClass it) {
        Functions.Function1 _function = it_1 -> it_1 instanceof TimeEventSpec;
        EObject _findFirst = (EObject)IteratorExtensions.findFirst((Iterator)it.getStatechart().eAllContents(), (Functions.Function1)_function);
        return _findFirst != null;
    }

    protected String getModelFromUri(URI uri) {
        Object model = uri.segment(2);
        int i = 3;
        while (i < uri.segmentsList().size()) {
            String _segment = uri.segment(i);
            String _plus = (String)model + "/" + _segment;
            model = _plus;
            ++i;
        }
        return model;
    }

    protected boolean isTimed(Statechart it) {
        int _size = IteratorExtensions.size((Iterator)Iterators.filter((Iterator)it.eAllContents(), TimeEventSpec.class));
        return _size > 0;
    }

    @XbaseGenerated
    public CharSequence generateTest(SCTUnitElement it, String targetProjectString) {
        if (it instanceof SCTUnitClass) {
            return this._generateTest((SCTUnitClass)it, targetProjectString);
        }
        if (it instanceof SCTUnitSuite) {
            return this._generateTest((SCTUnitSuite)it, targetProjectString);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, targetProjectString).toString());
    }
}

