/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.install;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yakindu.sct.ui.install.ProvisioningAgentProvider;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.OperationFactory;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.swt.widgets.Display;

public class InstallWizardOpener {
    private static final String WILDCARD = "*";
    private ProvisioningAgentProvider agentProvider = new ProvisioningAgentProvider();

    public void open(Map<String, Set<String>> features, IProgressMonitor monitor) {
        IProvisioningAgent agent = null;
        try {
            agent = this.agentProvider.get();
            IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            Set<IInstallableUnit> units = this.collectIUs(features, manager, monitor);
            if (monitor.isCanceled()) {
                return;
            }
            try {
                List<URI> knownRepos = Arrays.asList(manager.getKnownRepositories(0));
                InstallOperation op = new OperationFactory().createInstallOperation(units, knownRepos, monitor);
                this.open(units, op);
            }
            catch (ProvisionException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (agent != null) {
                agent.stop();
            }
        }
    }

    protected Set<IInstallableUnit> collectIUs(Map<String, Set<String>> features, IMetadataRepositoryManager manager, IProgressMonitor monitor) {
        HashSet units = Sets.newHashSet();
        for (Map.Entry<String, Set<String>> entry : features.entrySet()) {
            try {
                if (monitor.isCanceled()) {
                    return units;
                }
                List<Object> repos = Lists.newArrayList();
                if (entry.getKey().equals(WILDCARD)) {
                    List<URI> list = Arrays.asList(manager.getKnownRepositories(0));
                    for (URI repoUri : list) {
                        repos.add(manager.loadRepository(repoUri, monitor));
                    }
                } else {
                    repos = Collections.singletonList(manager.loadRepository(URI.create(entry.getKey()), monitor));
                }
                for (String string : entry.getValue()) {
                    for (IMetadataRepository iMetadataRepository : repos) {
                        Set unmodifiableSet = iMetadataRepository.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)string)), monitor).toUnmodifiableSet();
                        units.addAll(unmodifiableSet);
                    }
                }
                if (!entry.getValue().isEmpty()) continue;
                for (IMetadataRepository iMetadataRepository : repos) {
                    units.addAll(iMetadataRepository.query(QueryUtil.createIUGroupQuery(), monitor).toUnmodifiableSet());
                }
            }
            catch (OperationCanceledException | ProvisionException e) {
                e.printStackTrace();
            }
        }
        return units;
    }

    protected void open(Set<IInstallableUnit> units, InstallOperation op) {
        Display.getDefault().asyncExec(() -> ProvisioningUI.getDefaultUI().openInstallWizard((Collection)units, op, null));
    }
}

