/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.mail;

import com.yakindu.sct.ui.mail.MailTemplate;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.text.ParseException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SupportMail {
    public boolean report() {
        MailTemplate mailTemplate = new MailTemplate();
        String mailto = mailTemplate.asMailTo();
        boolean wasSuccessful = false;
        if (this.isDesktopSupported()) {
            try {
                URI mailtoUri = new URI(mailto);
                Desktop desktop = Desktop.getDesktop();
                desktop.mail(mailtoUri);
                wasSuccessful = true;
            }
            catch (IOException | RuntimeException | URISyntaxException e) {
                wasSuccessful = false;
            }
        }
        if (!wasSuccessful) {
            if (this.isLinux()) {
                mailto = mailTemplate.asMailToForLinuxWithGtk();
            }
            wasSuccessful = Program.launch((String)mailto);
        }
        if (!wasSuccessful) {
            Display display = Display.getDefault();
            Shell shell = display.getActiveShell();
            Dialog dialog = new Dialog(shell){

                protected Control createDialogArea(Composite parent) {
                    Composite container = (Composite)super.createDialogArea(parent);
                    StyledText text = new StyledText(container, 8);
                    text.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                    text.setText("Please send an e-mail containing your support request to:\n\n\tsct-pro@itemis.de\n\nYou will receive a confirmation with a ticket number by e-mail.\n\nBest regards\nYour itemis CREATE support team");
                    text.setCaret(null);
                    text.setBackground(parent.getBackground());
                    text.setSelectionBackground(text.getForeground());
                    text.setSelectionForeground(text.getBackground());
                    return container;
                }

                protected void createButtonsForButtonBar(Composite parent) {
                    this.createButton(parent, 0, "OK", true);
                }

                protected void configureShell(Shell newShell) {
                    super.configureShell(newShell);
                    newShell.setText("Your itemis CREATE Support Request");
                }
            };
            dialog.open();
        }
        return wasSuccessful;
    }

    private boolean isDesktopSupported() {
        boolean canCallIsDesktopSupported = false;
        if (!this.isLinux()) {
            canCallIsDesktopSupported = true;
        } else if (this.getGtkVersion() != 3) {
            canCallIsDesktopSupported = true;
        } else if (this.isAwtGtk3BugFixed()) {
            canCallIsDesktopSupported = true;
        }
        if (canCallIsDesktopSupported) {
            return Desktop.isDesktopSupported();
        }
        return false;
    }

    private boolean isAwtGtk3BugFixed() {
        return System.getProperty("swing.gtk.version") != null;
    }

    private boolean isLinux() {
        String s = System.getProperty("os.name");
        return s != null && s.toLowerCase().contains("linux");
    }

    private int getGtkVersion() {
        String s = System.getProperty("org.eclipse.swt.internal.gtk.version");
        if (s == null) {
            return -1;
        }
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        format.applyPattern("#");
        try {
            int i = format.parse(s).intValue();
            return i;
        }
        catch (ParseException e) {
            return -1;
        }
    }
}

