/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.c.submodules;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.types.AnnotatableElement;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Direction;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.annotations.VisibilityAnnotations;
import com.yakindu.sct.generator.c.GeneratorPredicate;
import com.yakindu.sct.generator.c.IHeaderFragment;
import com.yakindu.sct.generator.c.IncludeProvider;
import com.yakindu.sct.generator.c.extensions.ExpressionsChecker;
import com.yakindu.sct.generator.c.extensions.GenmodelEntries;
import com.yakindu.sct.generator.c.extensions.Naming;
import com.yakindu.sct.generator.c.submodules.APIGenerator;
import com.yakindu.sct.generator.c.submodules.EventCode;
import com.yakindu.sct.generator.c.submodules.MethodGenerator;
import com.yakindu.sct.generator.c.submodules.StatechartTypes;
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations;
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.ExecutionState;
import com.yakindu.sct.model.sexec.concepts.BufferEvent;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sexec.naming.INamingService;
import com.yakindu.sct.model.sexec.transformation.StatechartExtensions;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.stext.EventDefinition;
import com.yakindu.sct.model.stext.stext.InterfaceScope;
import com.yakindu.sct.model.stext.stext.StatechartScope;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class StatemachineHeaderFragment
implements IHeaderFragment {
    @Inject
    protected Set<IncludeProvider> includeProviders;
    @Inject
    @Extension
    protected Naming cNaming;
    @Inject
    @Extension
    protected SExecExtensions _sExecExtensions;
    @Inject
    @Extension
    protected ICodegenTypeSystemAccess _iCodegenTypeSystemAccess;
    @Inject
    @Extension
    protected GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    protected INamingService _iNamingService;
    @Inject
    @Extension
    protected StatechartExtensions _statechartExtensions;
    @Inject
    @Extension
    protected ExpressionsChecker _expressionsChecker;
    @Inject
    @Extension
    protected APIGenerator _aPIGenerator;
    @Inject
    @Extension
    protected StatechartTypes _statechartTypes;
    @Inject
    @Extension
    protected EventCode _eventCode;
    @Inject
    @Extension
    protected GeneratorPredicate _generatorPredicate;
    @Inject
    @Extension
    protected BufferEvent _bufferEvent;
    @Inject
    @Extension
    protected VisibilityAnnotations _visibilityAnnotations;
    @Inject
    @Extension
    protected MethodGenerator _methodGenerator;
    @Inject
    @Extension
    protected GeneratorEntry entry;
    @Inject
    private IGenArtifactConfigurations defaultConfigs;

    @Override
    public CharSequence defines(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations artifactConfigs) {
        boolean _isTimed;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*! Define number of states in the state enum */");
        _builder.newLine();
        _builder.append("#define ");
        CharSequence _numStates = this.cNaming.numStates(it);
        _builder.append((Object)_numStates);
        _builder.append(" ");
        int _size = it.getStates().size();
        _builder.append((Object)_size);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/*! Define dimension of the state configuration vector for orthogonal states. */");
        _builder.newLine();
        _builder.append("#define ");
        CharSequence _maxOrthogonalStates = this.cNaming.maxOrthogonalStates(it);
        _builder.append((Object)_maxOrthogonalStates);
        _builder.append(" ");
        int _size_1 = it.getStateVector().getSize();
        _builder.append((Object)_size_1);
        _builder.newLineIfNotEmpty();
        boolean _hasHistory = this._sExecExtensions.hasHistory(it);
        if (_hasHistory) {
            _builder.append("/*! Define dimension of the state configuration vector for history states. */");
            _builder.newLine();
            _builder.append("#define ");
            CharSequence _maxHistoryStates = this.cNaming.maxHistoryStates(it);
            _builder.append((Object)_maxHistoryStates);
            _builder.append(" ");
            int _size_2 = it.getHistoryVector().getSize();
            _builder.append((Object)_size_2);
            _builder.newLineIfNotEmpty();
        }
        if (_isTimed = this._sExecExtensions.isTimed(it)) {
            _builder.append("/*! Define maximum number of time events that can be active at once */");
            _builder.newLine();
            _builder.append("#define ");
            CharSequence _maxParallelTimeEvents = this.cNaming.maxParallelTimeEvents(it);
            _builder.append((Object)_maxParallelTimeEvents);
            _builder.append(" ");
            EObject _sourceElement = it.getSourceElement();
            int _maxNumberOfParallelTimeEvents = this._statechartExtensions.maxNumberOfParallelTimeEvents((NamedElement)((Statechart)_sourceElement));
            _builder.append((Object)_maxNumberOfParallelTimeEvents);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/*! Define indices of states in the StateConfVector */");
        _builder.newLine();
        EList _states = it.getStates();
        for (ExecutionState state : _states) {
            _builder.append("#define ");
            String _stateVectorDefine = this.cNaming.stateVectorDefine(state);
            _builder.append(_stateVectorDefine);
            _builder.append(" ");
            int _offset = state.getStateVector().getOffset();
            _builder.append((Object)_offset);
            _builder.newLineIfNotEmpty();
        }
        boolean _tracingGeneric = this._genmodelEntries.getTracingGeneric(entry);
        if (_tracingGeneric) {
            _builder.append("/*! Defines the standard value for the \"no feature\" id of the statechart feature enumerations */");
            _builder.newLine();
            _builder.append("#ifndef ");
            _builder.append("SC_NO_FEATURE");
            _builder.newLineIfNotEmpty();
            _builder.append("#define ");
            _builder.append("SC_NO_FEATURE");
            _builder.append(" 0");
            _builder.newLineIfNotEmpty();
            _builder.append("#endif");
            _builder.newLine();
        }
        return _builder;
    }

    @Override
    public CharSequence fileComment(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations artifactConfigs) {
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._genmodelEntries.getLicenseText(entry);
        _builder.append(_licenseText);
        return _builder;
    }

    @Override
    public CharSequence forwardDeclarations(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations artifactConfigs) {
        return this._statechartTypes.forwardDeclarations(it);
    }

    @Override
    public CharSequence functions(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations artifactConfigs) {
        return this.functions(it);
    }

    @Override
    public CharSequence includes(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations artifactConfigs) {
        return this.includes(it, artifactConfigs);
    }

    @Override
    public CharSequence types(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations artifactConfigs) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _statesEnumDecl = this._statechartTypes.statesEnumDecl(it);
        _builder.append((Object)_statesEnumDecl);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _featuresEnumDecl = this._statechartTypes.featuresEnumDecl(it);
        _builder.append((Object)_featuresEnumDecl);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList _scopes = it.getScopes();
        for (Scope s : _scopes) {
            CharSequence _scopeTypeDecl = this._statechartTypes.scopeTypeDecl(s);
            _builder.append((Object)_scopeTypeDecl);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            CharSequence _scopeConstDecl = this._statechartTypes.scopeConstDecl(s);
            _builder.append((Object)_scopeConstDecl);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        _builder.newLine();
        _builder.newLine();
        LinkedList _derivedComplexTypes = this._sExecExtensions.derivedComplexTypes(it);
        for (ComplexType t : _derivedComplexTypes) {
            CharSequence _typeDeclaration = this._statechartTypes.typeDeclaration(t, this._sExecExtensions.flow((EObject)it));
            _builder.append((Object)_typeDeclaration);
            _builder.newLineIfNotEmpty();
            CharSequence _structDeclaration = this._statechartTypes.structDeclaration(t, this._sExecExtensions.flow((EObject)it));
            _builder.append((Object)_structDeclaration);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _statemachineStruct = this._statechartTypes.statemachineStruct(it);
        _builder.append((Object)_statemachineStruct);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence functions(ExecutionFlow it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _tracingGeneric = this._genmodelEntries.getTracingGeneric(this.entry);
        if (_tracingGeneric) {
            _builder.append("/*! Initializes the ");
            String _type = this.cNaming.type((Notifier)it);
            _builder.append(_type);
            _builder.append(" state machine data structures. Must be called before first usage.*/");
            _builder.newLineIfNotEmpty();
            _builder.append("extern ");
            CharSequence _declareInitWithTracing = this._aPIGenerator.declareInitWithTracing(it);
            _builder.append((Object)_declareInitWithTracing);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("/*! Sets the trace handler. Can be called any time. */");
            _builder.newLine();
            _builder.append("extern ");
            CharSequence _declareSetTraceHandler = this._aPIGenerator.declareSetTraceHandler(it);
            _builder.append((Object)_declareSetTraceHandler);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/*! Initializes the ");
        String _type_1 = this.cNaming.type((Notifier)it);
        _builder.append(_type_1);
        _builder.append(" state machine data structures. Must be called before first usage.*/");
        _builder.newLineIfNotEmpty();
        _builder.append("extern ");
        CharSequence _declareInit = this._aPIGenerator.declareInit(it);
        _builder.append((Object)_declareInit);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        Functions.Function1 _function = it_1 -> this._visibilityAnnotations.isPublic((AnnotatableElement)it_1);
        CharSequence _declarations = this._methodGenerator.declarations(IterableExtensions.filter((Iterable)this._sExecExtensions.allMethods(it), (Functions.Function1)_function));
        _builder.append((Object)_declarations);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        boolean _isTimed = this._sExecExtensions.isTimed(it);
        if (_isTimed) {
            _builder.append("/*! Raises a time event. */");
            _builder.newLine();
            _builder.append("extern ");
            CharSequence _declareRaiseTimeEvent = this._aPIGenerator.declareRaiseTimeEvent(it);
            _builder.append((Object)_declareRaiseTimeEvent);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Iterable _filter = Iterables.filter((Iterable)it.getScopes(), InterfaceScope.class);
        for (InterfaceScope s : _filter) {
            CharSequence _scopeFunctionPrototypes = this.scopeFunctionPrototypes(s);
            _builder.append((Object)_scopeFunctionPrototypes);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/*!");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Checks whether the state machine is active (until 2.4.1 this method was used for states).");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* A state machine is active if it was entered. It is inactive if it has not been entered at all or if it has been exited.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("extern ");
        CharSequence _declareIsActive = this._aPIGenerator.declareIsActive(it);
        _builder.append((Object)_declareIsActive);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/*!");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Checks if all active states are final. ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* If there are no active states then the state machine is considered being inactive. In this case this method returns false.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("extern ");
        CharSequence _declareIsFinal = this._aPIGenerator.declareIsFinal(it);
        _builder.append((Object)_declareIsFinal);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/*! Checks if the specified state is active (until 2.4.1 the used method for states was called isActive()). */");
        _builder.newLine();
        _builder.append("extern ");
        CharSequence _declareIsStateActive = this._aPIGenerator.declareIsStateActive(it);
        _builder.append((Object)_declareIsStateActive);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    @Deprecated
    public CharSequence includes(ExecutionFlow it) {
        return this.includes(it, this.defaultConfigs);
    }

    public final CharSequence includes(ExecutionFlow it, @Extension IGenArtifactConfigurations artifactConfigs) {
        StringConcatenation _builder = new StringConcatenation();
        for (IncludeProvider provider : this.includeProviders) {
            List<CharSequence> _includes = provider.getIncludes(it, artifactConfigs);
            for (CharSequence i : _includes) {
                _builder.append((Object)i);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    protected CharSequence _scopeFunctionPrototypes(StatechartScope it) {
        StringConcatenation _builder = new StringConcatenation();
        EList _declarations = it.getDeclarations();
        for (Declaration d : _declarations) {
            CharSequence _functionPrototypes = this.functionPrototypes(d);
            _builder.append((Object)_functionPrototypes);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _scopeFunctionPrototypes(Object it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _functionPrototypes(Declaration it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _functionPrototypes(EventDefinition it) {
        StringConcatenation _builder = new StringConcatenation();
        Direction _direction = it.getDirection();
        boolean _equals = Objects.equals(_direction, Direction.IN);
        if (_equals) {
            _builder.append("/*! Raises the in event '");
            String _name = it.getName();
            _builder.append(_name);
            _builder.append("' that is defined in the ");
            CharSequence _scopeDescription = this._sExecExtensions.scopeDescription(this._sExecExtensions.scope((EObject)it));
            _builder.append((Object)_scopeDescription);
            _builder.append(". */ ");
            _builder.newLineIfNotEmpty();
            _builder.append("extern ");
            CharSequence _eventRaiserSignature = this._eventCode.eventRaiserSignature(this._sExecExtensions.flow((EObject)it), it);
            _builder.append((Object)_eventRaiserSignature);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _useOutEventGetters;
            boolean _useOutEventObservables = this._generatorPredicate.useOutEventObservables();
            if (_useOutEventObservables) {
                _builder.append("/*! Returns the observable for the out event '");
                String _name_1 = it.getName();
                _builder.append(_name_1);
                _builder.append("' that is defined in the ");
                CharSequence _scopeDescription_1 = this._sExecExtensions.scopeDescription(this._sExecExtensions.scope((EObject)it));
                _builder.append((Object)_scopeDescription_1);
                _builder.append(". */ ");
                _builder.newLineIfNotEmpty();
                _builder.append("extern ");
                CharSequence _eventObservableSignature = this._eventCode.eventObservableSignature(this._sExecExtensions.flow((EObject)it), it);
                _builder.append((Object)_eventObservableSignature);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
            }
            if (_useOutEventGetters = this._generatorPredicate.useOutEventGetters()) {
                _builder.append("/*! Checks if the out event '");
                String _name_2 = it.getName();
                _builder.append(_name_2);
                _builder.append("' that is defined in the ");
                CharSequence _scopeDescription_2 = this._sExecExtensions.scopeDescription(this._sExecExtensions.scope((EObject)it));
                _builder.append((Object)_scopeDescription_2);
                _builder.append(" has been raised. */ ");
                _builder.newLineIfNotEmpty();
                _builder.append("extern ");
                CharSequence _eventGetterSignature = this._eventCode.eventGetterSignature(this._sExecExtensions.flow((EObject)it), it);
                _builder.append((Object)_eventGetterSignature);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                boolean _hasValue = this._sExecExtensions.hasValue((Object)it);
                if (_hasValue) {
                    _builder.append("/*! Gets the value of the out event '");
                    String _name_3 = it.getName();
                    _builder.append(_name_3);
                    _builder.append("' that is defined in the ");
                    CharSequence _scopeDescription_3 = this._sExecExtensions.scopeDescription(this._sExecExtensions.scope((EObject)it));
                    _builder.append((Object)_scopeDescription_3);
                    _builder.append(". */ ");
                    _builder.newLineIfNotEmpty();
                    _builder.append("extern ");
                    CharSequence _eventValueGetterSignature = this._eventCode.eventValueGetterSignature(this._sExecExtensions.flow((EObject)it), it);
                    _builder.append((Object)_eventValueGetterSignature);
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                }
            }
        }
        return _builder;
    }

    protected CharSequence _functionPrototypes(VariableDefinition it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*! Gets the value of the variable '");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append("' that is defined in the ");
        CharSequence _scopeDescription = this._sExecExtensions.scopeDescription(this._sExecExtensions.scope((EObject)it));
        _builder.append((Object)_scopeDescription);
        _builder.append(". */ ");
        _builder.newLineIfNotEmpty();
        _builder.append("extern ");
        boolean _isConstString = this._expressionsChecker.isConstString((Property)it);
        if (_isConstString) {
            _builder.append("const ");
        }
        String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(it.getTypeSpecifier());
        _builder.append(_targetLanguageName);
        _builder.append(" ");
        CharSequence _asGetter = this.cNaming.asGetter((EObject)it);
        _builder.append((Object)_asGetter);
        _builder.append("(const ");
        String _scHandleDecl = this.cNaming.scHandleDecl((EObject)it);
        _builder.append(_scHandleDecl);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        if (!it.isReadonly() && !it.isConst()) {
            _builder.append("/*! Sets the value of the variable '");
            String _name_1 = it.getName();
            _builder.append(_name_1);
            _builder.append("' that is defined in the ");
            CharSequence _scopeDescription_1 = this._sExecExtensions.scopeDescription(this._sExecExtensions.scope((EObject)it));
            _builder.append((Object)_scopeDescription_1);
            _builder.append(". */ ");
            _builder.newLineIfNotEmpty();
            _builder.append("extern void ");
            String _asSetter = this.cNaming.asSetter(it);
            _builder.append(_asSetter);
            _builder.append("(");
            String _scHandleDecl_1 = this.cNaming.scHandleDecl((EObject)it);
            _builder.append(_scHandleDecl_1);
            _builder.append(", ");
            String _targetLanguageName_1 = this._iCodegenTypeSystemAccess.getTargetLanguageName(it.getTypeSpecifier());
            _builder.append(_targetLanguageName_1);
            _builder.append(" value);");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    @XbaseGenerated
    public CharSequence scopeFunctionPrototypes(Object it) {
        if (it instanceof StatechartScope) {
            return this._scopeFunctionPrototypes((StatechartScope)it);
        }
        if (it != null) {
            return this._scopeFunctionPrototypes(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public CharSequence functionPrototypes(Declaration it) {
        if (it instanceof EventDefinition) {
            return this._functionPrototypes((EventDefinition)it);
        }
        if (it instanceof VariableDefinition) {
            return this._functionPrototypes((VariableDefinition)it);
        }
        if (it != null) {
            return this._functionPrototypes(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

