/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.dialogs;

import com.yakindu.licmgmt.ILicenseManager;
import com.yakindu.licmgmt.internal.LicenseManager;
import com.yakindu.licmgmt.ui.internal.LicenseManagementUiActivator;
import com.yakindu.licmgmt.ui.internal.dialogs.InvalidLicenseActionHandler;
import com.yakindu.licmgmt.ui.internal.dialogs.actions.AbstractInvalidLicenseAction;
import com.yakindu.licmgmt.ui.internal.utils.EclipseLicenseHelper;
import java.util.Collection;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class HandleInvalidLicenseDialog
extends MessageDialog {
    private static final String DIALOG_TITLE_PREFIX = "License missing for ";
    private static final String DIALOG_MESSAGE_SUFFIX = ". What can I do?";
    private static final Image IMG_YAKINDU = LicenseManagementUiActivator.getDefault().getImage("icons/yakindu-32.png");
    private static final Color LIGHT_GREY = new Color((Device)Display.getCurrent(), 220, 220, 220);
    private LicenseManager licenseManager;

    public HandleInvalidLicenseDialog(Shell shell, ILicenseManager licenseManager) {
        super(shell, DIALOG_TITLE_PREFIX + EclipseLicenseHelper.INSTANCE.getFeatureAndProductName(licenseManager.getFeatureId()), null, HandleInvalidLicenseDialog.createDialogMessage(EclipseLicenseHelper.INSTANCE.getLicenseManager(licenseManager)), 3, new String[]{"Close"}, 0);
        this.licenseManager = EclipseLicenseHelper.INSTANCE.getLicenseManager(licenseManager);
    }

    protected Control createCustomArea(Composite parent) {
        InvalidLicenseActionHandler actionHandler = new InvalidLicenseActionHandler();
        Collection<AbstractInvalidLicenseAction> invalidLicenseActions = actionHandler.getInvalidLicenseActions(this.licenseManager);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = this.getNumColumns(invalidLicenseActions.size());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        Composite customAreaComposit = new Composite(parent, 0);
        customAreaComposit.setLayout((Layout)gridLayout);
        customAreaComposit.setLayoutData((Object)gridData);
        invalidLicenseActions.forEach(action -> {
            Composite composite2 = this.createDialogButton(customAreaComposit, (AbstractInvalidLicenseAction)action);
        });
        return customAreaComposit;
    }

    public Image getImage() {
        return IMG_YAKINDU;
    }

    private static String createDialogMessage(LicenseManager licenseManager) {
        return String.valueOf(InvalidLicenseActionHandler.getErrorMessage(licenseManager)) + DIALOG_MESSAGE_SUFFIX;
    }

    private int getNumColumns(int numberOfActions) {
        return numberOfActions > 0 && numberOfActions <= 4 ? 2 : 3;
    }

    private Composite createDialogButton(Composite parent, AbstractInvalidLicenseAction action) {
        Composite borderComposite = new Composite(parent, 0);
        GridLayout boarderLayout = new GridLayout();
        boarderLayout.numColumns = 1;
        boarderLayout.marginHeight = 1;
        boarderLayout.marginWidth = 1;
        borderComposite.setLayout((Layout)boarderLayout);
        borderComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonComposite = new Composite(borderComposite, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonComposite.setBackground(LIGHT_GREY);
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData buttonGridData = new GridData();
        buttonGridData.widthHint = 250;
        buttonGridData.heightHint = 80;
        buttonComposite.setLayoutData((Object)buttonGridData);
        Label buttonImage = new Label(buttonComposite, 0);
        this.setImage(action.getImage(), buttonComposite);
        buttonImage.setLayoutData((Object)new GridData(2, 2, true, true));
        Display display = parent.getShell().getDisplay();
        StyledText actionText = new StyledText(buttonComposite, 0);
        actionText.setText(action.getActionText());
        actionText.setEditable(false);
        actionText.setEnabled(false);
        actionText.setCaret(null);
        actionText.setWordWrap(true);
        actionText.setForeground(display.getSystemColor(2));
        actionText.setBackground(LIGHT_GREY);
        actionText.setStyleRange(action.getStyleRange());
        actionText.setLayoutData((Object)new GridData(2, 2, true, true));
        if (action.getHint() != null) {
            Label hintText = new Label(buttonComposite, 0);
            hintText.setText(action.getHint());
            hintText.setLayoutData((Object)new GridData(2, 2, true, true));
        }
        Listener mouseEnterFilter = e -> {
            if (this.isChildOrSelf(e.widget, buttonComposite)) {
                borderComposite.setBackground(display.getSystemColor(9));
                buttonComposite.setBackground(display.getSystemColor(1));
                actionText.setBackground(display.getSystemColor(1));
            }
        };
        display.addFilter(6, mouseEnterFilter);
        Listener mouseExitFilter = e -> {
            if (this.isChildOrSelf(e.widget, buttonComposite)) {
                borderComposite.setBackground(parent.getBackground());
                buttonComposite.setBackground(LIGHT_GREY);
                actionText.setBackground(LIGHT_GREY);
            }
        };
        display.addFilter(7, mouseExitFilter);
        Listener mouseDownFilter = e -> {
            if (this.isChildOrSelf(e.widget, buttonComposite)) {
                action.run(parent);
            }
        };
        display.addFilter(3, mouseDownFilter);
        buttonComposite.addDisposeListener(e -> {
            display.removeFilter(6, mouseEnterFilter);
            display.removeFilter(7, mouseExitFilter);
            display.removeFilter(3, mouseDownFilter);
        });
        return borderComposite;
    }

    private void setImage(Image image, Composite buttonComposite) {
        if (image != null) {
            int x = ((GridData)buttonComposite.getLayoutData()).widthHint / 2 - image.getImageData().width / 2;
            buttonComposite.addPaintListener(e -> e.gc.drawImage(image, x, 5));
        }
    }

    private boolean isChildOrSelf(Widget child, Composite parent) {
        if (child == parent) {
            return true;
        }
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Composite ? this.isChildOrSelf(child, (Composite)c) : c == child) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

