/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.preferences.providers;

import com.yakindu.licmgmt.ui.internal.model.TableItemData;
import com.yakindu.licmgmt.ui.internal.preferences.ActionButtonSelectionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class ActionLabelProvider
extends ColumnLabelProvider {
    private static final String BUTTON_LABEL_REMOVE = "Remove";
    private static final String BUTTON_LABEL_BORROW = "Borrow";
    private static final String BUTTON_LABEL_RETURN = "Return";
    private static final String BUTTON_LABEL_ACQUIRE = "Acquire";
    private static final String BUTTON_LABEL_RETRY = "Retry";
    private static final String BUTTON_LABEL_RELEASE = "Release";
    private static final String BOTTON_TOOLTIP_REMOVE = "Delete this license file.";
    private static final String BOTTON_TOOLTIP_BORROW = "Borrow this floating license.";
    private static final String BOTTON_TOOLTIP_RETURN = "Return this floating license.";
    private static final String BOTTON_TOOLTIP_ACQUIRE = "Acquire this license.";
    private static final String BOTTON_TOOLTIP_RETRY = "Retry to acquire this license.";
    private static final String BOTTON_TOOLTIP_RELEASE = "Release this license.";
    private static final Image IMG_DELETE_LICENSE = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE").createImage();
    private static final Image IMG_BORROW_LICENSE = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK").createImage();
    private static final Image IMG_RETURN_LICENSE = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD").createImage();
    private static final Image IMG_ACQUIRE_LICENSE = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_UNDO").createImage();
    private static final Image IMG_RELEASE_LICENSE = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_REDO").createImage();
    private final Map<TableItemData, Button> buttons = new HashMap<TableItemData, Button>();
    private final List<TableEditor> editors = new ArrayList<TableEditor>();

    public String getText(Object element) {
        return "";
    }

    public void update(ViewerCell cell) {
        TableItemData data = (TableItemData)cell.getElement();
        switch (data.getActionType()) {
            case DELETABLE: {
                this.createButton(cell, BUTTON_LABEL_REMOVE, IMG_DELETE_LICENSE, BOTTON_TOOLTIP_REMOVE);
                break;
            }
            case BORROWABLE: {
                this.createButton(cell, BUTTON_LABEL_BORROW, IMG_BORROW_LICENSE, BOTTON_TOOLTIP_BORROW);
                break;
            }
            case RETURNABLE: {
                this.createButton(cell, BUTTON_LABEL_RETURN, IMG_RETURN_LICENSE, BOTTON_TOOLTIP_RETURN);
                break;
            }
            case ACQUIREABLE: {
                this.createButton(cell, BUTTON_LABEL_ACQUIRE, IMG_ACQUIRE_LICENSE, BOTTON_TOOLTIP_ACQUIRE);
                break;
            }
            case RETRYABLE: {
                this.createButton(cell, BUTTON_LABEL_RETRY, IMG_ACQUIRE_LICENSE, BOTTON_TOOLTIP_RETRY);
                break;
            }
            case RELEASABLE: {
                this.createButton(cell, BUTTON_LABEL_RELEASE, IMG_RELEASE_LICENSE, BOTTON_TOOLTIP_RELEASE);
            }
        }
    }

    private void createButton(ViewerCell cell, String text, Image img, String toolTip) {
        TableItem tableItem = (TableItem)cell.getItem();
        TableItemData itemData = (TableItemData)cell.getElement();
        Button button = this.buttons.get(itemData);
        if (button == null) {
            button = new Button((Composite)cell.getViewerRow().getControl(), 0);
            button.setText(text);
            button.setImage(img);
            button.setToolTipText(toolTip);
            button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            button.addSelectionListener((SelectionListener)new ActionButtonSelectionListener(itemData));
            this.buttons.put(itemData, button);
        }
        TableEditor editor = new TableEditor(tableItem.getParent());
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setEditor((Control)button, tableItem, cell.getColumnIndex());
        editor.layout();
    }

    public String getToolTipText(Object element) {
        TableItemData data = (TableItemData)element;
        switch (data.getActionType()) {
            case DELETABLE: {
                return BOTTON_TOOLTIP_REMOVE;
            }
            case BORROWABLE: {
                return BOTTON_TOOLTIP_BORROW;
            }
            case RETURNABLE: {
                return BOTTON_TOOLTIP_RETURN;
            }
            case ACQUIREABLE: {
                return BOTTON_TOOLTIP_ACQUIRE;
            }
            case RETRYABLE: {
                return BOTTON_TOOLTIP_RETRY;
            }
            case RELEASABLE: {
                return BOTTON_TOOLTIP_RELEASE;
            }
        }
        return "";
    }

    public void dispose() {
        for (Button btn : this.buttons.values()) {
            btn.dispose();
        }
        this.buttons.clear();
        for (TableEditor editor : this.editors) {
            editor.dispose();
        }
        this.editors.clear();
        super.dispose();
    }
}

