/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.cpp.types;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.itemis.create.base.generator.core.types.Literals;
import com.yakindu.base.types.Declaration;
import com.yakindu.base.types.Enumerator;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.annotations.NamespaceAnnotations;
import com.yakindu.sct.generator.cpp.types.CppTypes;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@Singleton
public class CppLiterals
extends Literals {
    @Inject
    @Extension
    protected CppTypes _cppTypes;
    @Inject
    @Extension
    protected NamespaceAnnotations _namespaceAnnotations;
    public static final String TRUE_LITERAL_NAME = "true";
    public static final String FALSE_LITERAL_NAME = "false";
    public static final String SEPARATOR_TOKEN = "::";
    public static final String NULL_LITERAL_NAME = "sc_null";

    public String TRUE_LITERAL() {
        return TRUE_LITERAL_NAME;
    }

    public String FALSE_LITERAL() {
        return FALSE_LITERAL_NAME;
    }

    protected String _asLiteral(String v) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        String _fqName = this._cppTypes.sc_string().fqName();
        _builder.append(_fqName);
        _builder.append(")\"");
        _builder.append(v);
        _builder.append("\"");
        return _builder.toString();
    }

    protected String _asLiteral(Enumerator e) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = e.getName();
        _builder.append(_name);
        return _builder.toString();
    }

    public String NULL_LITERAL() {
        return NULL_LITERAL_NAME;
    }

    public String ENUM_SEPARATOR() {
        return SEPARATOR_TOKEN;
    }

    public String NAMESPACE_SEPARATOR() {
        return SEPARATOR_TOKEN;
    }

    @XbaseGenerated
    public String asLiteral(Object e) {
        if (e instanceof Enumerator) {
            return this._asLiteral((Enumerator)e);
        }
        if (e instanceof Package) {
            return this._asLiteral((Package)e);
        }
        if (e instanceof Type) {
            return this._asLiteral((Type)e);
        }
        if (e instanceof Declaration) {
            return this._asLiteral((Declaration)e);
        }
        if (e instanceof List) {
            return this._asLiteral((List)e);
        }
        if (e instanceof TypeSpecifier) {
            return this._asLiteral((TypeSpecifier)e);
        }
        if (e instanceof Boolean) {
            return this._asLiteral((Boolean)e);
        }
        if (e instanceof Number) {
            return this._asLiteral((Number)e);
        }
        if (e instanceof String) {
            return this._asLiteral((String)e);
        }
        if (e == null) {
            return this._asLiteral(null);
        }
        return this._asLiteral(e);
    }
}

