/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sexec.naming;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.expressions.expressions.TimeEventSpec;
import com.yakindu.base.expressions.util.ExpressionExtensions;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Property;
import com.yakindu.sct.model.sexec.ExecutionEntry;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.ExecutionNode;
import com.yakindu.sct.model.sexec.ExecutionScope;
import com.yakindu.sct.model.sexec.ExecutionState;
import com.yakindu.sct.model.sexec.Method;
import com.yakindu.sct.model.sexec.Reaction;
import com.yakindu.sct.model.sexec.Step;
import com.yakindu.sct.model.sexec.TimeEvent;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sexec.naming.ExecutionScopeDepthComparator;
import com.yakindu.sct.model.sexec.naming.INamingService;
import com.yakindu.sct.model.sexec.naming.MethodDepthComparator;
import com.yakindu.sct.model.sexec.naming.NamingHelper;
import com.yakindu.sct.model.sexec.naming.StepDepthComparator;
import com.yakindu.sct.model.sexec.transformation.StatechartExtensions;
import com.yakindu.sct.model.sgraph.CompositeElement;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.RegularState;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.model.stext.naming.StextNameProvider;
import com.yakindu.sct.model.stext.stext.SubmachineReferenceExpression;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@Singleton
public class DefaultNamingService
implements INamingService {
    @Inject
    @Extension
    private ExpressionExtensions _expressionExtensions;
    @Inject
    @Extension
    private SExecExtensions _sExecExtensions;
    @Inject
    @Extension
    private StatechartExtensions _statechartExtensions;
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    @Extension
    private StepDepthComparator stepDepthComparator;
    @Inject
    @Extension
    private ExecutionScopeDepthComparator executionScopeDepthComparator;
    @Inject
    @Extension
    private MethodDepthComparator methodDepthComparator;
    @Inject
    @Extension
    private NamingHelper _namingHelper;
    @Inject
    private StextNameProvider provider;
    private static final String VALID_IDENTIFIER_REGEX = "[_a-zA-Z][_a-zA-Z0-9]*";
    protected final int maxLength = 0;
    protected char separator = (char)95;
    protected Table<EObject, NamedElement, String> nameTable = HashBasedTable.create();
    protected ExecutionFlow activeFlow;
    protected Statechart activeStatechart;

    public DefaultNamingService(int maxLength, char separator) {
        this.separator = separator;
    }

    public DefaultNamingService() {
        this.separator = (char)95;
    }

    @Override
    public void initializeNamingService(Statechart statechart) {
        this.initializeRow((Notifier)statechart);
    }

    @Override
    public void initializeNamingService(ExecutionFlow flow) {
        this.initializeRow((Notifier)flow);
    }

    protected void _initializeRow(Statechart statechart) {
        if (this.nameTable == null || !Objects.equals(this.activeStatechart, statechart)) {
            this.activeFlow = null;
            this.activeStatechart = statechart;
            BiConsumer<NamedElement, String> _function = (element, name) -> this.nameTable.put((Object)statechart, element, name);
            this.createShortNameMap(statechart, 0, this.separator).forEach(_function);
            this.activeStatechart = null;
        }
    }

    protected void _initializeRow(ExecutionFlow flow) {
        if (this.nameTable == null || !Objects.equals(this.activeFlow, flow)) {
            this.activeFlow = flow;
            this.activeStatechart = null;
            BiConsumer<NamedElement, String> _function = (element, name) -> this.nameTable.put((Object)flow, element, name);
            this.createShortNameMap(flow, 0, this.separator).forEach(_function);
            this.activeFlow = null;
        }
    }

    @Override
    public String getShortName(NamedElement element) {
        boolean _not;
        EObject container = this._sExecExtensions.flowOrStatechart((EObject)element);
        boolean _containsRow = this.nameTable.containsRow((Object)container);
        boolean bl = _not = !_containsRow;
        if (_not) {
            this.initializeRow((Notifier)container);
        }
        return (String)this.nameTable.get((Object)container, (Object)element);
    }

    public Map<NamedElement, String> createShortNameMap(Statechart statechart, int maxLength, char separator) {
        HashMap<NamedElement, String> map = new HashMap<NamedElement, String>();
        this.addShortVertexNames(map, (CompositeElement)statechart, maxLength, separator);
        return map;
    }

    protected void addShortVertexNames(Map<NamedElement, String> map, CompositeElement element, int maxLength, char separator) {
        EList _regions = element.getRegions();
        for (Region region : _regions) {
            EList _vertices = region.getVertices();
            for (Vertex vertex : _vertices) {
                boolean _matched = false;
                if (vertex instanceof RegularState) {
                    _matched = true;
                    this.putShortName(map, (NamedElement)vertex, this.prefix((RegularState)vertex, separator), this.suffix(vertex, separator), maxLength, separator);
                }
                if (_matched) continue;
                this.putShortName(map, (NamedElement)vertex, this.prefix(vertex, separator), this.suffix(vertex, separator), maxLength, separator);
            }
        }
        EList _regions_1 = element.getRegions();
        for (Region region_1 : _regions_1) {
            EList _vertices_1 = region_1.getVertices();
            for (Vertex vertex_1 : _vertices_1) {
                if (!(vertex_1 instanceof CompositeElement)) continue;
                this.addShortVertexNames(map, (CompositeElement)vertex_1, maxLength, separator);
            }
        }
    }

    public Map<NamedElement, String> createShortNameMap(ExecutionFlow flow, int maxLength, char separator) {
        HashMap<NamedElement, String> map = new HashMap<NamedElement, String>();
        this.addShortStateNames(map, flow, maxLength, separator);
        this.addShortFctNames(map, flow, maxLength, separator);
        this.addShortMethodNames(map, flow, maxLength, separator);
        this.addShortTimeEventNames(map, flow, maxLength, separator);
        return map;
    }

    protected void addShortStateNames(Map<NamedElement, String> map, ExecutionFlow flow, int maxLength, char separator) {
        List _sortWith = IterableExtensions.sortWith(flow.getStates(), (Comparator)this.executionScopeDepthComparator);
        for (ExecutionState s : _sortWith) {
            this.putShortName(map, s, this.prefix(s, separator), this.suffix(s, separator), maxLength, separator);
        }
    }

    protected void addShortFctNames(Map<NamedElement, String> map, ExecutionFlow flow, int maxLength, char separator) {
        List _sortWith = IterableExtensions.sortWith(this._sExecExtensions.getAllFunctions(flow), (Comparator)this.stepDepthComparator);
        for (Step s : _sortWith) {
            this.putShortName(map, s, this.prefix(s, separator), this.suffix(s, separator), maxLength, separator);
        }
    }

    protected void addShortMethodNames(Map<NamedElement, String> map, ExecutionFlow flow, int maxLength, char separator) {
        List _sortWith = IterableExtensions.sortWith(this._sExecExtensions.reactMethods(flow), (Comparator)this.methodDepthComparator);
        for (Method s : _sortWith) {
            this.putShortName(map, (NamedElement)s, this.prefix(s, separator), this.suffix(s, separator), maxLength, separator);
        }
        Consumer<Method> _function = m -> this.addMethod(map, (Method)m);
        this._sExecExtensions.methods(flow).forEach(_function);
    }

    protected void addMethod(Map<NamedElement, String> map, Method op) {
        if (op != null) {
            this.putShortName(map, (NamedElement)op, this.prefix(op, this.separator), this.suffix(op, this.separator), 0, this.separator);
        }
    }

    protected void addShortTimeEventNames(Map<NamedElement, String> map, ExecutionFlow flow, int maxLength, char separator) {
        EObject _sourceElement = flow.getSourceElement();
        if (_sourceElement instanceof Statechart) {
            EObject _sourceElement_1 = flow.getSourceElement();
            Statechart statechart = (Statechart)_sourceElement_1;
            this.addShortTimeEventName(flow, (NamedElement)statechart, this._statechartExtensions.timeEventSpecs((EObject)statechart), map, maxLength, separator);
        }
        List _sortWith = IterableExtensions.sortWith(flow.getStates(), (Comparator)this.executionScopeDepthComparator);
        for (ExecutionState executionState : _sortWith) {
            EObject _sourceElement_2 = executionState.getSourceElement();
            if (!(_sourceElement_2 instanceof State)) continue;
            EObject _sourceElement_3 = executionState.getSourceElement();
            State state = (State)_sourceElement_3;
            this.addShortTimeEventName(executionState, (NamedElement)state, this._statechartExtensions.timeEventSpecs((EObject)state), map, maxLength, separator);
        }
    }

    protected void addShortTimeEventName(NamedElement executionFlowElement, NamedElement sgraphElement, List<TimeEventSpec> timeEventSpecs, Map<NamedElement, String> map, int maxLength, char separator) {
        for (TimeEventSpec tes : timeEventSpecs) {
            int _indexOf;
            QualifiedName _fullyQualifiedName;
            String _plus;
            String _plus_1;
            ExecutionFlow _flow = this._sExecExtensions.flow((EObject)executionFlowElement);
            TimeEvent timeEvent = this._sExecExtensions.getTimeEvent(_flow, _plus_1 = (_plus = String.valueOf(_fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)sgraphElement)) + "_time_event_") + String.valueOf((Object)(_indexOf = timeEventSpecs.indexOf(tes))));
            if (timeEvent == null) continue;
            map.put((NamedElement)timeEvent, this.getShortName(executionFlowElement, this.prefix(tes, sgraphElement, separator), this.suffix(tes, sgraphElement, separator), IterableExtensions.toList(map.values()), separator));
        }
    }

    protected void putShortName(Map<NamedElement, String> map, NamedElement element, String prefix, String suffix, int maxLength, char separator) {
        boolean _not;
        boolean _containsKey = map.containsKey(element);
        boolean bl = _not = !_containsKey;
        if (_not) {
            map.put(element, this.getShortName(element, prefix, suffix, IterableExtensions.toList(map.values()), separator));
        }
    }

    protected String prefix(Step it, char separator) {
        boolean _isReactSequence;
        boolean _isExitSequence;
        boolean _isShallowEnterSequence;
        boolean _isDeepEnterSequence;
        boolean _isEnterSequence;
        boolean _isEffect;
        boolean _isExitAction;
        boolean _isEntryAction;
        String _xblockexpression = null;
        String prefix = StringExtensions.toFirstLower((String)this._sExecExtensions.flow((EObject)it).getName());
        Object _switchResult = null;
        boolean _matched = false;
        boolean _isCheckFunction = this._sExecExtensions.isCheckFunction(it);
        if (_isCheckFunction) {
            _matched = true;
            _switchResult = prefix + String.valueOf(Character.valueOf(separator)) + "check";
        }
        if (!_matched && (_isEntryAction = this._sExecExtensions.isEntryAction(it))) {
            _matched = true;
            _switchResult = prefix + String.valueOf(Character.valueOf(separator)) + "enact";
        }
        if (!_matched && (_isExitAction = this._sExecExtensions.isExitAction(it))) {
            _matched = true;
            _switchResult = prefix + String.valueOf(Character.valueOf(separator)) + "exact";
        }
        if (!_matched && (_isEffect = this._sExecExtensions.isEffect(it))) {
            _matched = true;
            _switchResult = prefix + String.valueOf(Character.valueOf(separator)) + "effect";
        }
        if (!_matched && (_isEnterSequence = this._sExecExtensions.isEnterSequence(it))) {
            _matched = true;
            _switchResult = prefix + String.valueOf(Character.valueOf(separator)) + "enseq";
        }
        if (!_matched && (_isDeepEnterSequence = this._sExecExtensions.isDeepEnterSequence(it))) {
            _matched = true;
            _switchResult = prefix + String.valueOf(Character.valueOf(separator)) + "dhenseq";
        }
        if (!_matched && (_isShallowEnterSequence = this._sExecExtensions.isShallowEnterSequence(it))) {
            _matched = true;
            _switchResult = prefix + String.valueOf(Character.valueOf(separator)) + "shenseq";
        }
        if (!_matched && (_isExitSequence = this._sExecExtensions.isExitSequence(it))) {
            _matched = true;
            _switchResult = prefix + String.valueOf(Character.valueOf(separator)) + "exseq";
        }
        if (!_matched && (_isReactSequence = this._sExecExtensions.isReactSequence(it))) {
            _matched = true;
            _switchResult = prefix + String.valueOf(Character.valueOf(separator)) + "react";
        }
        if (!_matched) {
            _switchResult = "";
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected String suffix(Step it, char separator) {
        return "";
    }

    protected String prefix(Method it, char separator) {
        return "";
    }

    protected String suffix(Method it, char separator) {
        return "";
    }

    protected String prefix(ExecutionState it, char separator) {
        return this._sExecExtensions.flow(it).getName();
    }

    protected String suffix(ExecutionState it, char separator) {
        return "";
    }

    protected String prefix(TimeEventSpec it, NamedElement element, char separator) {
        return this.activeFlow.getName();
    }

    protected String suffix(TimeEventSpec it, NamedElement element, char separator) {
        int _indexOf = this._statechartExtensions.timeEventSpecs((EObject)element).indexOf(it);
        return "tev" + String.valueOf((Object)_indexOf);
    }

    protected String prefix(RegularState it, char separator) {
        return this.activeStatechart.getName();
    }

    protected String prefix(Vertex it, char separator) {
        return "";
    }

    protected String suffix(Vertex it, char separator) {
        return "";
    }

    @Override
    public String asIdentifier(String string) {
        return string.replaceAll("[[^a-z]&&[^A-Z]&&[^0-9]]", Character.valueOf(this.separator).toString());
    }

    @Override
    public String asEscapedIdentifier(String string) {
        return this.asIdentifier(string);
    }

    @Override
    public boolean isKeyword(String string) {
        return false;
    }

    protected String getShortName(NamedElement element, String prefix, String suffix, List<String> nameList, char separator) {
        String shortName;
        boolean _isNullOrEmpty_2;
        boolean _not_2;
        boolean _isNullOrEmpty;
        boolean _not;
        Object name = this.elementName((EObject)element);
        if (StringExtensions.isNullOrEmpty((String)name) && StringExtensions.isNullOrEmpty((String)prefix) && StringExtensions.isNullOrEmpty((String)suffix)) {
            name = element.getClass().getSimpleName();
        }
        boolean bl = _not = !(_isNullOrEmpty = StringExtensions.isNullOrEmpty((String)suffix));
        if (_not) {
            boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)name);
            boolean _not_1 = !_isNullOrEmpty_1;
            name = _not_1 ? (String)name + String.valueOf(Character.valueOf(separator)) + suffix : suffix;
        }
        boolean bl2 = _not_2 = !(_isNullOrEmpty_2 = StringExtensions.isNullOrEmpty((String)prefix));
        if (_not_2) {
            boolean _isNullOrEmpty_3 = StringExtensions.isNullOrEmpty((String)name);
            boolean _not_3 = !_isNullOrEmpty_3;
            name = _not_3 ? prefix + String.valueOf(Character.valueOf(separator)) + (String)name : prefix;
        }
        if (this._namingHelper.containsName(nameList, shortName = this.asEscapedIdentifier((String)name)) || !(element.eContainer() instanceof ExecutionFlow) && Objects.equals(shortName, "react")) {
            EObject _eContainer;
            boolean _matched = false;
            if (element instanceof ExecutionScope) {
                _matched = true;
                shortName = this.getShortName(((ExecutionScope)element).getSuperScope(), prefix, (String)name, nameList, separator);
            }
            if (!_matched && element instanceof Step) {
                _matched = true;
                int _scopeDepth = this._sExecExtensions.getScopeDepth((Step)element);
                boolean _greaterThan = _scopeDepth > 0;
                shortName = _greaterThan ? this.getShortName(this._sExecExtensions.parentExecutionScope((EObject)element).getSuperScope(), prefix, (String)name, nameList, separator) : this.getShortName(this._sExecExtensions.parentExecutionScope((EObject)element), prefix, (String)name, nameList, separator);
            }
            if (!_matched && (_eContainer = element.eContainer()) instanceof NamedElement) {
                EObject _eContainer_1 = element.eContainer();
                shortName = this.getShortName((NamedElement)_eContainer_1, prefix, (String)name, nameList, separator);
            }
        }
        return shortName;
    }

    protected String _elementName(Reaction it) {
        return this.skipFirst(this.provider.getFullyQualifiedName((EObject)it), 2).toString(Character.valueOf(this.separator).toString());
    }

    protected String _elementName(ExecutionScope it) {
        return this.elementName(it.getSourceElement());
    }

    protected String _elementName(ExecutionState it) {
        return this.elementName(it.getSourceElement());
    }

    protected String _elementName(ExecutionNode it) {
        return this.skipFirst(this.provider.getFullyQualifiedName((EObject)it), 2).toString(Character.valueOf(this.separator).toString());
    }

    protected String _elementName(ExecutionEntry it) {
        return this.skipFirst(this.provider.getFullyQualifiedName((EObject)it), 2).toString(Character.valueOf(this.separator).toString());
    }

    protected String _elementName(NamedElement it) {
        return this.skipFirst(this.provider.getFullyQualifiedName((EObject)it), 2).toString(Character.valueOf(this.separator).toString());
    }

    protected String _elementName(Region it) {
        return this.vertexOrRegionName((NamedElement)it);
    }

    protected String _elementName(Vertex it) {
        return this.vertexOrRegionName((NamedElement)it);
    }

    protected String _elementName(Method it) {
        return it.getName();
    }

    private String vertexOrRegionName(NamedElement it) {
        return this.skipFirst(this.provider.getFullyQualifiedName((EObject)it), 1).toString(Character.valueOf(this.separator).toString());
    }

    private QualifiedName skipFirst(QualifiedName name, int skipCount) {
        int _namespaceCount = this.namespaceCount();
        int _plus = _namespaceCount + skipCount;
        return name.skipFirst(_plus);
    }

    private int namespaceCount() {
        int _xifexpression = 0;
        String _namespace = this.getNamespace();
        boolean _tripleEquals = _namespace == null;
        _xifexpression = _tripleEquals ? 0 : ((List)Conversions.doWrapArray((Object)this.getNamespace().split("\\."))).size();
        return _xifexpression;
    }

    private String getNamespace() {
        String _elvis = null;
        Statechart _statechart = null;
        if (this.activeFlow != null) {
            _statechart = this._sExecExtensions.statechart(this.activeFlow);
        }
        String _namespace = null;
        if (_statechart != null) {
            _namespace = _statechart.getNamespace();
        }
        if (_namespace != null) {
            _elvis = _namespace;
        } else {
            String _namespace_1 = null;
            if (this.activeStatechart != null) {
                _namespace_1 = this.activeStatechart.getNamespace();
            }
            _elvis = _namespace_1;
        }
        return _elvis;
    }

    protected String _elementName(ExecutionFlow it) {
        return "";
    }

    protected String _elementName(Step it) {
        String _xblockexpression = null;
        String parentName = this.elementName(it.eContainer());
        Object _xifexpression = null;
        if ((this._sExecExtensions.isEnterSequence(it) || this._sExecExtensions.isCheckFunction(it) || this._sExecExtensions.isEffect(it)) && it.getName() != null && !it.getName().trim().isEmpty()) {
            String _name = it.getName();
            _xifexpression = parentName + String.valueOf(Character.valueOf(this.separator)) + _name;
        } else {
            _xifexpression = parentName;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected String _elementName(EObject it) {
        EObject _eContainer = it.eContainer();
        String _elementName = null;
        if (_eContainer != null) {
            _elementName = this.elementName(_eContainer);
        }
        return _elementName;
    }

    protected String _elementName(SubmachineReferenceExpression it) {
        StringConcatenation _builder = new StringConcatenation();
        String _elementName = this.elementName((EObject)this.getSubMachineHostState(it));
        _builder.append(_elementName);
        _builder.append("_");
        String _asIdentifier = this.asIdentifier(this.getSubMachineProperty(it).getName());
        _builder.append(_asIdentifier);
        return _builder.toString();
    }

    public State getSubMachineHostState(SubmachineReferenceExpression it) {
        State _xifexpression = null;
        _xifexpression = it != null ? (State)EcoreUtil2.getContainerOfType((EObject)it, State.class) : null;
        return _xifexpression;
    }

    public Property getSubMachineProperty(SubmachineReferenceExpression it) {
        Expression _submachine = null;
        if (it != null) {
            _submachine = it.getSubmachine();
        }
        EObject sub = this._expressionExtensions.featureOrReference(_submachine);
        Property _xifexpression = null;
        _xifexpression = sub instanceof Property ? (Property)sub : null;
        return _xifexpression;
    }

    protected String asIndexPosition(ExecutionScope it) {
        return Integer.valueOf(it.getSuperScope().getSubScopes().indexOf((Object)it)).toString();
    }

    protected String removeVowels(String it) {
        return it.replaceAll("[aeiou]", "");
    }

    @Override
    public void setMaxLength(int length) {
    }

    @Override
    public void setSeparator(char sep) {
        boolean _not;
        String sepString = String.valueOf(Character.valueOf(sep));
        boolean _matches = sepString.matches(VALID_IDENTIFIER_REGEX);
        boolean bl = _not = !_matches;
        if (_not) {
            throw new IllegalArgumentException();
        }
        this.separator = sep;
    }

    @Override
    public int getMaxLength() {
        return 0;
    }

    @Override
    public char getSeparator() {
        return this.separator;
    }

    @XbaseGenerated
    protected void initializeRow(Notifier flow) {
        if (flow instanceof ExecutionFlow) {
            this._initializeRow((ExecutionFlow)flow);
            return;
        }
        if (flow instanceof Statechart) {
            this._initializeRow((Statechart)flow);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(flow).toString());
    }

    @XbaseGenerated
    protected String elementName(EObject it) {
        if (it instanceof ExecutionEntry) {
            return this._elementName((ExecutionEntry)it);
        }
        if (it instanceof ExecutionFlow) {
            return this._elementName((ExecutionFlow)it);
        }
        if (it instanceof ExecutionState) {
            return this._elementName((ExecutionState)it);
        }
        if (it instanceof ExecutionNode) {
            return this._elementName((ExecutionNode)it);
        }
        if (it instanceof Method) {
            return this._elementName((Method)it);
        }
        if (it instanceof ExecutionScope) {
            return this._elementName((ExecutionScope)it);
        }
        if (it instanceof Reaction) {
            return this._elementName((Reaction)it);
        }
        if (it instanceof Step) {
            return this._elementName((Step)it);
        }
        if (it instanceof Region) {
            return this._elementName((Region)it);
        }
        if (it instanceof Vertex) {
            return this._elementName((Vertex)it);
        }
        if (it instanceof SubmachineReferenceExpression) {
            return this._elementName((SubmachineReferenceExpression)it);
        }
        if (it instanceof NamedElement) {
            return this._elementName((NamedElement)it);
        }
        if (it != null) {
            return this._elementName(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

