/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sexec.naming.tree;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.expressions.expressions.TimeEventSpec;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.ExecutionNode;
import com.yakindu.sct.model.sexec.ExecutionRegion;
import com.yakindu.sct.model.sexec.ExecutionScope;
import com.yakindu.sct.model.sexec.ExecutionState;
import com.yakindu.sct.model.sexec.Method;
import com.yakindu.sct.model.sexec.Step;
import com.yakindu.sct.model.sexec.TimeEvent;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sexec.naming.ElementNameProvider;
import com.yakindu.sct.model.sexec.naming.INamingService;
import com.yakindu.sct.model.sexec.naming.IStringShortener;
import com.yakindu.sct.model.sexec.naming.tree.StringTreeNodeDepthComparator;
import com.yakindu.sct.model.sexec.transformation.StatechartExtensions;
import com.yakindu.sct.model.sgraph.CompositeElement;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class TreeNamingService
implements INamingService {
    @Accessors
    protected int maxLength = 0;
    @Inject
    @Named(value="Separator")
    @Accessors
    protected char separator = (char)95;
    @Inject
    @Extension
    private SExecExtensions _sExecExtensions;
    @Inject
    @Extension
    private StatechartExtensions _statechartExtensions;
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    @Extension
    private ElementNameProvider _elementNameProvider;
    @Inject
    protected StringTreeNodeDepthComparator stringTreeNodeDepthComparator;
    @Inject
    protected IStringShortener shortener;
    protected static final String VALID_IDENTIFIER_REGEX = "[_a-zA-Z][_a-zA-Z0-9]*";
    protected Map<NamedElement, String> map;
    protected ExecutionFlow activeFlow;
    protected Statechart activeStatechart;

    public TreeNamingService(int maxLength, char separator) {
        this.maxLength = maxLength;
        this.separator = separator;
    }

    public TreeNamingService() {
        this.maxLength = 0;
        this.separator = (char)95;
    }

    protected void reset() {
        this.map = CollectionLiterals.newHashMap();
        this.activeFlow = null;
        this.activeStatechart = null;
        this.shortener.reset();
    }

    @Override
    public void initializeNamingService(Statechart statechart) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equals(this.activeStatechart, statechart);
        if (_notEquals) {
            this.reset();
            this.activeStatechart = statechart;
            this.collectNames((CompositeElement)statechart);
        }
    }

    protected void collectNames(CompositeElement element) {
        EList _regions = element.getRegions();
        for (Region region : _regions) {
            ArrayList<String> _arrayList = new ArrayList<String>();
            ArrayList<String> _arrayList_1 = new ArrayList<String>();
            this.addElement((NamedElement)region, _arrayList, _arrayList_1);
            EList _vertices = region.getVertices();
            for (Vertex vertex : _vertices) {
                ArrayList<String> _arrayList_3;
                ArrayList<String> _arrayList_2;
                boolean _matched = false;
                if (vertex instanceof State) {
                    _matched = true;
                    _arrayList_2 = new ArrayList<String>();
                    _arrayList_3 = new ArrayList<String>();
                    this.addElement((NamedElement)vertex, _arrayList_2, _arrayList_3);
                }
                if (_matched) continue;
                _arrayList_2 = new ArrayList();
                _arrayList_3 = new ArrayList();
                this.addElement((NamedElement)vertex, _arrayList_2, _arrayList_3);
            }
        }
        EList _regions_1 = element.getRegions();
        for (Region region_1 : _regions_1) {
            EList _vertices = region_1.getVertices();
            for (Vertex vertex : _vertices) {
                if (!(vertex instanceof CompositeElement)) continue;
                this.collectNames((CompositeElement)vertex);
            }
        }
    }

    @Override
    public void initializeNamingService(ExecutionFlow flow) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equals(this.activeFlow, flow);
        if (_notEquals) {
            this.reset();
            this.activeFlow = flow;
            this.collectNames(flow);
        }
    }

    protected void collectNames(ExecutionFlow flow) {
        EList<ExecutionRegion> _regions = flow.getRegions();
        for (ExecutionRegion region : _regions) {
            ArrayList _arrayList = new ArrayList();
            ArrayList<String> _arrayList_1 = new ArrayList<String>();
            this.addElement(region, _arrayList, _arrayList_1);
            EList<ExecutionNode> _nodes = region.getNodes();
            for (ExecutionNode node : _nodes) {
                ArrayList<String> _arrayList_2 = new ArrayList<String>();
                ArrayList<String> _arrayList_3 = new ArrayList<String>();
                this.addElement(node, _arrayList_2, _arrayList_3);
            }
        }
        EList<ExecutionState> _states = flow.getStates();
        for (ExecutionState state : _states) {
            this.addElement(state, this.prefix(state), this.suffix(state));
        }
        List<Step> _allFunctions = this._sExecExtensions.getAllFunctions(flow);
        for (Step func : _allFunctions) {
            this.addElement(func, this.prefix(func), this.suffix(func));
        }
        Consumer<Method> _function = it -> this.addMethod((Method)it);
        this._sExecExtensions.reactMethods(flow).forEach(_function);
        Consumer<Method> _function_1 = it -> this.addMethod((Method)it);
        this._sExecExtensions.methods(flow).forEach(_function_1);
        EObject _sourceElement = flow.getSourceElement();
        if (_sourceElement instanceof Statechart) {
            EObject _sourceElement_1 = flow.getSourceElement();
            Statechart statechart = (Statechart)_sourceElement_1;
            this.addShortTimeEventName(flow, (NamedElement)statechart);
        }
        EList<ExecutionState> _states_1 = flow.getStates();
        for (ExecutionState executionState : _states_1) {
            EObject _sourceElement_2 = executionState.getSourceElement();
            if (!(_sourceElement_2 instanceof State)) continue;
            EObject _sourceElement_3 = executionState.getSourceElement();
            State state_1 = (State)_sourceElement_3;
            this.addShortTimeEventName(executionState, (NamedElement)state_1);
        }
    }

    protected void addMethod(Method op) {
        if (op != null) {
            this.addElement((NamedElement)op, this.prefix(op), this.suffix(op));
        }
    }

    protected void addShortTimeEventName(NamedElement executionFlowElement, NamedElement sgraphElement) {
        List<TimeEventSpec> timeEventSpecs = this._statechartExtensions.timeEventSpecs((EObject)sgraphElement);
        for (TimeEventSpec tes : timeEventSpecs) {
            int _indexOf;
            QualifiedName _fullyQualifiedName;
            String _plus;
            String _plus_1;
            ExecutionFlow _flow = this._sExecExtensions.flow((EObject)executionFlowElement);
            TimeEvent timeEvent = this._sExecExtensions.getTimeEvent(_flow, _plus_1 = (_plus = String.valueOf(_fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)sgraphElement)) + "_time_event_") + String.valueOf((Object)(_indexOf = timeEventSpecs.indexOf(tes))));
            if (timeEvent == null) continue;
            this.addElement(executionFlowElement, this.prefix(tes, sgraphElement), this.suffix(tes, sgraphElement), timeEvent);
        }
    }

    protected void addElement(NamedElement elem, List<String> prefix, List<String> suffix) {
        this.addElement(elem, prefix, suffix, elem);
    }

    protected void addElement(NamedElement elem, List<String> prefix, List<String> suffix, Object token) {
        ArrayList<String> segments = new ArrayList<String>();
        segments.addAll(prefix);
        segments.addAll(this._elementNameProvider.elementNameSegments(elem));
        segments.addAll(suffix);
        try {
            this.shortener.addString(this.addSeparator(segments), token);
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                IllegalArgumentException e = (IllegalArgumentException)_t;
                EObject _eContainer = elem.eContainer();
                if (_eContainer instanceof NamedElement) {
                    EObject _eContainer_1 = elem.eContainer();
                    this.addElement((NamedElement)_eContainer_1, CollectionLiterals.newArrayList(), segments, token);
                }
                throw e;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected String asIndexPosition(ExecutionScope it) {
        return Integer.valueOf(it.getSuperScope().getSubScopes().indexOf((Object)it)).toString();
    }

    protected String _asSGraphIndexPosition(Region it) {
        return Integer.valueOf(IterableExtensions.toList((Iterable)it.getComposite().getRegions()).indexOf(it)).toString();
    }

    protected String _asSGraphIndexPosition(State it) {
        return Integer.valueOf(IterableExtensions.toList((Iterable)Iterables.filter((Iterable)it.getParentRegion().getVertices(), State.class)).indexOf(it)).toString();
    }

    protected String _asSGraphIndexPosition(Vertex it) {
        return Integer.valueOf(IterableExtensions.toList((Iterable)it.getParentRegion().getVertices()).indexOf(it)).toString();
    }

    @Override
    public void setMaxLength(int length) {
        this.maxLength = length;
        this.shortener.setMaxLength(length);
    }

    @Override
    public void setSeparator(char sep) {
        boolean _not;
        String sepString = String.valueOf(Character.valueOf(sep));
        boolean _matches = sepString.matches(VALID_IDENTIFIER_REGEX);
        boolean bl = _not = !_matches;
        if (_not) {
            throw new IllegalArgumentException();
        }
        this.separator = sep;
    }

    @Override
    public String getShortName(NamedElement element) {
        boolean _containsKey = this.map.containsKey(element);
        if (_containsKey) {
            return this.map.get(element);
        }
        String name = this.shortener.getString(element);
        if (name == null) {
            ArrayList<String> _arrayList = new ArrayList<String>();
            ArrayList<String> _arrayList_1 = new ArrayList<String>();
            this.addElement(element, _arrayList, _arrayList_1);
            name = this.shortener.getString(element);
        }
        this.map.put(element, name);
        return name;
    }

    @Override
    public String asEscapedIdentifier(String string) {
        return this.asIdentifier(string);
    }

    @Override
    public String asIdentifier(String string) {
        return string.replaceAll("[[^a-z]&&[^A-Z]&&[^0-9]]", Character.valueOf(this.separator).toString());
    }

    @Override
    public boolean isKeyword(String string) {
        return false;
    }

    protected List<String> suffix(Step it) {
        boolean _isReactSequence;
        boolean _isExitSequence;
        boolean _isShallowEnterSequence;
        boolean _isDeepEnterSequence;
        boolean _isEnterSequence;
        boolean _isEffect;
        boolean _isExitAction;
        boolean _isEntryAction;
        ArrayList<String> l = new ArrayList<String>();
        boolean _matched = false;
        boolean _isCheckFunction = this._sExecExtensions.isCheckFunction(it);
        if (_isCheckFunction) {
            _matched = true;
            l.add("check");
        }
        if (!_matched && (_isEntryAction = this._sExecExtensions.isEntryAction(it))) {
            _matched = true;
            l.add("enact");
        }
        if (!_matched && (_isExitAction = this._sExecExtensions.isExitAction(it))) {
            _matched = true;
            l.add("exact");
        }
        if (!_matched && (_isEffect = this._sExecExtensions.isEffect(it))) {
            _matched = true;
            l.add("effect");
        }
        if (!_matched && (_isEnterSequence = this._sExecExtensions.isEnterSequence(it))) {
            _matched = true;
            l.add("enseq");
        }
        if (!_matched && (_isDeepEnterSequence = this._sExecExtensions.isDeepEnterSequence(it))) {
            _matched = true;
            l.add("dhenseq");
        }
        if (!_matched && (_isShallowEnterSequence = this._sExecExtensions.isShallowEnterSequence(it))) {
            _matched = true;
            l.add("shenseq");
        }
        if (!_matched && (_isExitSequence = this._sExecExtensions.isExitSequence(it))) {
            _matched = true;
            l.add("exseq");
        }
        if (!_matched && (_isReactSequence = this._sExecExtensions.isReactSequence(it))) {
            _matched = true;
            l.add("react");
        }
        return l;
    }

    protected List<String> prefix(Step it) {
        return new ArrayList<String>();
    }

    protected List<String> prefix(ExecutionState it) {
        ArrayList<String> l = new ArrayList<String>();
        return l;
    }

    protected List<String> prefix(Method it) {
        return new ArrayList<String>();
    }

    protected List<String> suffix(ExecutionState it) {
        return new ArrayList<String>();
    }

    protected List<String> prefix(TimeEventSpec it, NamedElement element) {
        ArrayList<String> l = new ArrayList<String>();
        return l;
    }

    protected List<String> suffix(Method it) {
        return new ArrayList<String>();
    }

    protected List<String> suffix(TimeEventSpec it, NamedElement element) {
        String _plus;
        int _indexOf;
        ArrayList<String> l = new ArrayList<String>();
        boolean _matched = false;
        if (element instanceof Statechart) {
            _matched = true;
            _indexOf = this._statechartExtensions.timeEventSpecs((EObject)element).indexOf(it);
            _plus = "tev" + String.valueOf((Object)_indexOf);
            l.add(_plus);
        }
        if (!_matched && element instanceof State) {
            _matched = true;
            _indexOf = this._statechartExtensions.timeEventSpecs((EObject)element).indexOf(it);
            _plus = "tev" + String.valueOf((Object)_indexOf);
            l.add(_plus);
        }
        return l;
    }

    protected List<String> prefix(State it) {
        ArrayList<String> l = new ArrayList<String>();
        return l;
    }

    protected List<String> prefix(Vertex it) {
        return new ArrayList<String>();
    }

    protected List<String> suffix(Vertex it) {
        return new ArrayList<String>();
    }

    protected List<String> addSeparator(List<String> segments) {
        ArrayList _xblockexpression = null;
        ArrayList result = CollectionLiterals.newArrayList();
        int i = 0;
        while (i < segments.size()) {
            boolean _lessThan;
            result.add(segments.get(i));
            int _size = segments.size();
            int _minus = _size - 1;
            boolean bl = _lessThan = i < _minus;
            if (_lessThan) {
                result.add(Character.valueOf(this.separator).toString());
            }
            ++i;
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    protected List<String> toFirstUpper(List<String> segments) {
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(segments);
        if (_isNullOrEmpty) {
            return CollectionLiterals.newArrayList();
        }
        segments.set(0, StringExtensions.toFirstUpper((String)((String)IterableExtensions.head(segments))));
        return segments;
    }

    @XbaseGenerated
    protected String asSGraphIndexPosition(NamedElement it) {
        if (it instanceof State) {
            return this._asSGraphIndexPosition((State)it);
        }
        if (it instanceof Region) {
            return this._asSGraphIndexPosition((Region)it);
        }
        if (it instanceof Vertex) {
            return this._asSGraphIndexPosition((Vertex)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @Override
    @Pure
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    @Pure
    public char getSeparator() {
        return this.separator;
    }
}

