/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sexec.transformation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.expressions.expressions.AssignmentExpression;
import com.yakindu.base.expressions.expressions.AssignmentOperator;
import com.yakindu.base.expressions.expressions.BoolLiteral;
import com.yakindu.base.expressions.expressions.DoubleLiteral;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.ExpressionsFactory;
import com.yakindu.base.expressions.expressions.FloatLiteral;
import com.yakindu.base.expressions.expressions.IntLiteral;
import com.yakindu.base.expressions.expressions.Literal;
import com.yakindu.base.expressions.expressions.MultiplicativeOperator;
import com.yakindu.base.expressions.expressions.NumericalMultiplyDivideExpression;
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression;
import com.yakindu.base.expressions.expressions.StringLiteral;
import com.yakindu.base.expressions.expressions.TimeEventSpec;
import com.yakindu.base.expressions.expressions.TimeUnit;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.typesystem.ITypeValueProvider;
import com.yakindu.sct.model.sexec.Call;
import com.yakindu.sct.model.sexec.EnterState;
import com.yakindu.sct.model.sexec.Execution;
import com.yakindu.sct.model.sexec.ExecutionEntry;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.ExecutionRegion;
import com.yakindu.sct.model.sexec.ExecutionScope;
import com.yakindu.sct.model.sexec.ExecutionState;
import com.yakindu.sct.model.sexec.ExitState;
import com.yakindu.sct.model.sexec.SaveHistory;
import com.yakindu.sct.model.sexec.Sequence;
import com.yakindu.sct.model.sexec.StateCase;
import com.yakindu.sct.model.sexec.StateSwitch;
import com.yakindu.sct.model.sexec.StateVector;
import com.yakindu.sct.model.sexec.Step;
import com.yakindu.sct.model.sexec.concepts.SubMachine;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sexec.extensions.StateVectorExtensions;
import com.yakindu.sct.model.sexec.transformation.SexecElementMapping;
import com.yakindu.sct.model.sexec.transformation.SexecFactoryExtensions;
import com.yakindu.sct.model.sexec.transformation.TraceExtensions;
import com.yakindu.sct.model.sgraph.Entry;
import com.yakindu.sct.model.sgraph.FinalState;
import com.yakindu.sct.model.sgraph.ImportDeclaration;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.RegularState;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.model.sgraph.util.SgraphExtensions;
import com.yakindu.sct.model.sgraph.util.StatechartUtil;
import com.yakindu.sct.model.stext.concepts.EntryTransition;
import com.yakindu.sct.model.stext.stext.SubmachineReferenceExpression;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class SequenceBuilder {
    @Inject
    @Extension
    private SgraphExtensions sgraph;
    @Inject
    @Extension
    private SexecFactoryExtensions sexec;
    @Inject
    @Extension
    private SExecExtensions _sExecExtensions;
    @Inject
    @Extension
    private StateVectorExtensions _stateVectorExtensions;
    @Inject
    @Extension
    private EntryTransition _entryTransition;
    @Inject
    @Extension
    private SexecElementMapping mapping;
    @Inject
    @Extension
    private TraceExtensions trace;
    @Inject
    @Extension
    private SubMachine _subMachine;
    @Inject
    @Extension
    private ITypeValueProvider _iTypeValueProvider;
    @Inject
    @Extension
    private StatechartUtil _statechartUtil;
    private static String DEFAULT_SEQUENCE_NAME = "default";
    private ExpressionsFactory factory = ExpressionsFactory.eINSTANCE;

    public void defineDeepEnterSequences(ExecutionFlow flow, Statechart sc) {
        EList _regions = sc.getRegions();
        for (Region r : _regions) {
            this.defineDeepEnterSequence(r);
        }
    }

    public void defineDeepEnterSequence(State s) {
        EList _regions = s.getRegions();
        for (Region r : _regions) {
            this.defineDeepEnterSequence(r);
        }
    }

    public void defineDeepEnterSequence(Region r) {
        boolean _not;
        Iterable _filter = Iterables.filter((Iterable)r.getVertices(), State.class);
        for (State s : _filter) {
            this.defineDeepEnterSequence(s);
        }
        boolean _requireDeepHistory = this.sgraph.requireDeepHistory(r);
        boolean bl = _not = !_requireDeepHistory;
        if (_not) {
            return;
        }
        ExecutionRegion execRegion = this.mapping.create(r);
        Sequence seq = this.sexec.factory().createSequence();
        seq.setName("deepEnterSequence");
        String _name = r.getName();
        String _plus = "deep enterSequence with history in child " + _name;
        seq.setComment(_plus);
        EList<Step> _steps = seq.getSteps();
        StateSwitch _defineDeepHistorySwitch = this.defineDeepHistorySwitch(r);
        _steps.add((Object)_defineDeepHistorySwitch);
        execRegion.setDeepEnterSequence(seq);
    }

    public StateSwitch defineDeepHistorySwitch(Region r) {
        ExecutionRegion execRegion = this.mapping.create(r);
        StateSwitch sSwitch = this.sexec.factory().createStateSwitch();
        sSwitch.setStateConfigurationIdx(execRegion.getStateVector().getOffset());
        String _name = r.getName();
        String _plus = "Handle deep history entry of " + _name;
        sSwitch.setComment(_plus);
        sSwitch.setHistoryRegion(execRegion);
        Iterable _filter = Iterables.filter((Iterable)r.getVertices(), State.class);
        for (State child : _filter) {
            Functions.Function1 _function = it -> this.sgraph.isLeaf(it);
            Functions.Function1 _function_1 = c -> {
                int _stateConfigurationIdx;
                int _offset = this.mapping.create((RegularState)c).getStateVector().getOffset();
                return _offset == (_stateConfigurationIdx = sSwitch.getStateConfigurationIdx());
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)this.sgraph.allStates((EObject)child, _function), (Functions.Function1)_function_1);
            for (RegularState childLeaf : _filter_1) {
                ExecutionState execChild = this.mapping.create((RegularState)child);
                Sequence seq = this.sexec.factory().createSequence();
                seq.setName(DEFAULT_SEQUENCE_NAME);
                String _name_1 = child.getName();
                String _plus_1 = "enterSequence with history in child " + _name_1;
                String _plus_2 = _plus_1 + " for leaf ";
                String _name_2 = childLeaf.getName();
                String _plus_3 = _plus_2 + _name_2;
                seq.setComment(_plus_3);
                boolean _isLeaf = execChild.isLeaf();
                if (_isLeaf) {
                    EList<Step> _steps = seq.getSteps();
                    Call _newCall = this.mapping.newCall(this._sExecExtensions.defaultSequence((List<Sequence>)execChild.getEnterSequences()));
                    _steps.add((Object)_newCall);
                } else {
                    boolean _tripleNotEquals;
                    Step _entryAction = execChild.getEntryAction();
                    boolean bl = _tripleNotEquals = _entryAction != null;
                    if (_tripleNotEquals) {
                        EList<Step> _steps_1 = seq.getSteps();
                        Call _newCall_1 = this.mapping.newCall(execChild.getEntryAction());
                        _steps_1.add((Object)_newCall_1);
                    }
                    this.trace._trace(seq, this.trace._traceStateEntered(execChild));
                    EList _regions = child.getRegions();
                    for (Region childRegion : _regions) {
                        EList<Step> _steps_2 = seq.getSteps();
                        Call _newCall_2 = this.mapping.newCall(this.mapping.create(childRegion).getDeepEnterSequence());
                        _steps_2.add((Object)_newCall_2);
                    }
                }
                EList<StateCase> _cases = sSwitch.getCases();
                StateCase _newCase = this.sexec.newCase(this.mapping.create(childLeaf), seq);
                _cases.add((Object)_newCase);
            }
        }
        return sSwitch;
    }

    public void defineShallowEnterSequences(ExecutionFlow flow, Statechart sc) {
        TreeIterator contents = sc.eAllContents();
        Iterable _iterable = IteratorExtensions.toIterable((Iterator)Iterators.filter((Iterator)contents, Region.class));
        for (Region r : _iterable) {
            boolean _requireShallowHistory = this.sgraph.requireShallowHistory(r);
            if (!_requireShallowHistory) continue;
            ExecutionRegion execRegion = this.mapping.create(r);
            Sequence seq = this.sexec.factory().createSequence();
            seq.setName("shallowEnterSequence");
            String _name = r.getName();
            String _plus = "shallow enterSequence with history in child " + _name;
            seq.setComment(_plus);
            EList<Step> _steps = seq.getSteps();
            StateSwitch _defineShallowHistorySwitch = this.defineShallowHistorySwitch(r);
            _steps.add((Object)_defineShallowHistorySwitch);
            execRegion.setShallowEnterSequence(seq);
        }
    }

    public StateSwitch defineShallowHistorySwitch(Region r) {
        ExecutionRegion execRegion = this.mapping.create(r);
        StateSwitch sSwitch = this.sexec.factory().createStateSwitch();
        sSwitch.setStateConfigurationIdx(execRegion.getStateVector().getOffset());
        String _name = r.getName();
        String _plus = "Handle shallow history entry of " + _name;
        sSwitch.setComment(_plus);
        sSwitch.setHistoryRegion(this.mapping.create(r));
        Iterable _filter = Iterables.filter((Iterable)r.getVertices(), State.class);
        for (State child : _filter) {
            ExecutionState execChild = this.mapping.create((RegularState)child);
            Functions.Function1 _function = it -> this.sgraph.isLeaf(it);
            Functions.Function1 _function_1 = c -> {
                int _stateConfigurationIdx;
                int _offset = this.mapping.create((RegularState)c).getStateVector().getOffset();
                return _offset == (_stateConfigurationIdx = sSwitch.getStateConfigurationIdx());
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)this.sgraph.allStates((EObject)child, _function), (Functions.Function1)_function_1);
            for (RegularState childLeaf : _filter_1) {
                EList<StateCase> _cases = sSwitch.getCases();
                StateCase _newCase = this.sexec.newCase(this.mapping.create(childLeaf), this.mapping.newCall(this._sExecExtensions.defaultSequence((List<Sequence>)execChild.getEnterSequences())));
                _cases.add((Object)_newCase);
            }
        }
        return sSwitch;
    }

    public void defineEnterSequences(ExecutionFlow flow, Statechart sc) {
        EList _regions = sc.getRegions();
        for (Region r : _regions) {
            this.defineScopeEnterSequences((NamedElement)r);
        }
    }

    protected void _defineScopeEnterSequences(Region r) {
        ExecutionRegion execRegion = this.mapping.create(r);
        EList _vertices = r.getVertices();
        for (Vertex s : _vertices) {
            this.defineScopeEnterSequences((NamedElement)s);
        }
        Iterable _collectEntries = this.sgraph.collectEntries(r);
        for (Entry e : _collectEntries) {
            Sequence seq = this.sexec.factory().createSequence();
            String _xifexpression = null;
            _xifexpression = e.getName() == null || Objects.equals(e.getName().trim(), "") ? DEFAULT_SEQUENCE_NAME : e.getName();
            seq.setName(_xifexpression);
            String _name = seq.getName();
            String _plus = "'" + _name;
            String _plus_1 = _plus + "' enter sequence for region ";
            String _name_1 = r.getName();
            String _plus_2 = _plus_1 + _name_1;
            seq.setComment(_plus_2);
            ExecutionEntry entryNode = this.mapping.create(e);
            if (entryNode != null && entryNode.getReactSequence() != null) {
                seq.getSteps().add((Object)this.mapping.newCall(entryNode.getReactSequence()));
            }
            EList<Sequence> _enterSequences = execRegion.getEnterSequences();
            _enterSequences.add((Object)seq);
        }
    }

    protected void _defineScopeEnterSequences(Vertex v) {
    }

    protected void _defineScopeEnterSequences(FinalState state) {
        boolean _tripleNotEquals;
        ExecutionState execState = this.mapping.create((RegularState)state);
        Sequence seq = this.sexec.factory().createSequence();
        seq.setName(DEFAULT_SEQUENCE_NAME);
        seq.setComment("Default enter sequence for final state");
        Step _entryAction = execState.getEntryAction();
        boolean bl = _tripleNotEquals = _entryAction != null;
        if (_tripleNotEquals) {
            seq.getSteps().add((Object)this.mapping.newCall(execState.getEntryAction()));
        }
        this.trace._trace(seq, this.trace._traceStateEntered(execState));
        EList<Step> _steps = seq.getSteps();
        EnterState _newEnterStateStep = this.sexec.newEnterStateStep(execState);
        _steps.add((Object)_newEnterStateStep);
        EList _enterSequences = execState.getEnterSequences();
        _enterSequences.add((Object)seq);
    }

    protected void _defineScopeEnterSequences(State state) {
        boolean _not_1;
        ExecutionState execState = this.mapping.create((RegularState)state);
        Consumer<Region> _function = r -> this.defineScopeEnterSequences((NamedElement)r);
        state.getRegions().forEach(_function);
        Functions.Function1 _function_1 = t -> this._entryTransition.entryPointName(t);
        List entryPointNames = IterableExtensions.toList((Iterable)IterableExtensions.toSet((Iterable)ListExtensions.map((List)state.getIncomingTransitions(), (Functions.Function1)_function_1)));
        boolean _requireHistory = this.sgraph.requireHistory(state.getParentRegion());
        if (_requireHistory) {
            boolean _not;
            boolean _contains = entryPointNames.contains("default");
            boolean bl = _not = !_contains;
            if (_not) {
                entryPointNames.add("default");
            }
        }
        ListExtensions.sortInplace((List)entryPointNames);
        boolean _isLeaf = execState.isLeaf();
        boolean bl = _not_1 = !_isLeaf;
        if (_not_1) {
            Sequence seq = this.sexec.factory().createSequence();
            seq.setName(execState.getName());
            String _name = execState.getName();
            String _plus = "'" + _name;
            String _plus_1 = _plus + "' enter sequence for state ";
            String _name_1 = state.getName();
            String _plus_2 = _plus_1 + _name_1;
            seq.setComment(_plus_2);
            EList<Step> _steps = seq.getSteps();
            EnterState _newEnterStateStep = this.sexec.newEnterStateStep(execState);
            _steps.add((Object)_newEnterStateStep);
            EList _enterSequences = execState.getEnterSequences();
            _enterSequences.add((Object)seq);
        }
        for (String epName : entryPointNames) {
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            Sequence seq_1 = this.sexec.factory().createSequence();
            seq_1.setName(epName);
            String _name_2 = state.getName();
            String _plus_3 = "'" + epName + "' enter sequence for state " + _name_2;
            seq_1.setComment(_plus_3);
            Step _entryAction = execState.getEntryAction();
            boolean bl2 = _tripleNotEquals = _entryAction != null;
            if (_tripleNotEquals) {
                seq_1.getSteps().add((Object)this.mapping.newCall(execState.getEntryAction()));
            }
            this.trace._trace(seq_1, this.trace._traceStateEntered(execState));
            boolean _isLeaf_1 = execState.isLeaf();
            if (_isLeaf_1) {
                EList<Step> _steps_1 = seq_1.getSteps();
                EnterState _newEnterStateStep_1 = this.sexec.newEnterStateStep(execState);
                _steps_1.add((Object)_newEnterStateStep_1);
            } else {
                EList<Step> _steps_2;
                EList _regions = state.getRegions();
                for (Region r2 : _regions) {
                    ExecutionRegion execRegion = this.mapping.create(r2);
                    Sequence regionEnterSeq = this._sExecExtensions.byName((List<Sequence>)execRegion.getEnterSequences(), epName);
                    if (regionEnterSeq == null) {
                        regionEnterSeq = this._sExecExtensions.defaultSequence((List<Sequence>)execRegion.getEnterSequences());
                    }
                    if (regionEnterSeq == null) continue;
                    _steps_2 = seq_1.getSteps();
                    Call _newCall = this.mapping.newCall(regionEnterSeq);
                    _steps_2.add((Object)_newCall);
                }
                List<SubmachineReferenceExpression> _embeddedSubMachines = this._subMachine.embeddedSubMachines(state);
                for (SubmachineReferenceExpression subRef : _embeddedSubMachines) {
                    ExecutionState subMachineState = this.mapping.create(subRef);
                    _steps_2 = seq_1.getSteps();
                    EnterState _newEnterStateStep_2 = this.sexec.newEnterStateStep(subMachineState);
                    _steps_2.add((Object)_newEnterStateStep_2);
                }
            }
            ExecutionRegion execRegion = this.mapping.create(state.getParentRegion());
            StateVector _historyVector = execRegion.getHistoryVector();
            boolean bl3 = _tripleNotEquals_1 = _historyVector != null;
            if (_tripleNotEquals_1) {
                EList<Step> _steps_2 = seq_1.getSteps();
                SaveHistory _newSaveHistory = this.sexec.newSaveHistory(execRegion);
                _steps_2.add((Object)_newSaveHistory);
            }
            EList _enterSequences_1 = execState.getEnterSequences();
            _enterSequences_1.add((Object)seq_1);
        }
    }

    public void defineStateExitSequences(ExecutionFlow flow, Statechart sc) {
        EList _regions = sc.getRegions();
        for (Region r : _regions) {
            this.defineStateExitSequence((NamedElement)r);
        }
    }

    protected void _defineStateExitSequence(Region r) {
        boolean _not;
        ExecutionRegion execRegion = this.mapping.create(r);
        Sequence seq = this.sexec.factory().createSequence();
        seq.setName("exitSequence");
        String _name = r.getName();
        String _plus = "Default exit sequence for region " + _name;
        seq.setComment(_plus);
        EList _vertices = r.getVertices();
        for (Vertex s : _vertices) {
            this.defineStateExitSequence((NamedElement)s);
        }
        Functions.Function1 _function = rs -> this.mapping.create((RegularState)rs);
        List childStates = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)this.sgraph.allStates((EObject)r), (Functions.Function1)_function));
        boolean _isEmpty = childStates.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            StateVector sVector = execRegion.getStateVector();
            int _offset = sVector.getOffset();
            int _offset_1 = sVector.getOffset();
            int _size = sVector.getSize();
            int _plus_1 = _offset_1 + _size;
            int _minus = _plus_1 - 1;
            IntegerRange _upTo = new IntegerRange(_offset, _minus);
            for (Integer i : _upTo) {
                StateSwitch sSwitch = this.defineExitSwitch(execRegion, childStates, i);
                seq.getSteps().add((Object)sSwitch);
            }
        }
        execRegion.setExitSequence(seq);
    }

    protected void _defineStateExitSequence(Vertex v) {
    }

    protected void _defineStateExitSequence(FinalState s) {
        ExecutionState execState = this.mapping.create((RegularState)s);
        Sequence seq = this.sexec.factory().createSequence();
        seq.setName("exitSequence");
        seq.setComment("Default exit sequence for final state.");
        EList<Step> _steps = seq.getSteps();
        ExitState _newExitStateStep = this.sexec.newExitStateStep(execState);
        _steps.add((Object)_newExitStateStep);
        this.trace._trace(seq, this.trace._traceStateExited(execState));
        execState.setExitSequence(seq);
    }

    protected void _defineStateExitSequence(State state) {
        Step _exitAction;
        boolean _tripleNotEquals;
        boolean _not;
        ExecutionState execState = this.mapping.create((RegularState)state);
        Sequence seq = this.sexec.factory().createSequence();
        seq.setName("exitSequence");
        String _name = state.getName();
        String _plus = "Default exit sequence for state " + _name;
        seq.setComment(_plus);
        EList _regions = state.getRegions();
        for (Region r : _regions) {
            boolean _tripleNotEquals2;
            this.defineStateExitSequence((NamedElement)r);
            ExecutionRegion execRegion = this.mapping.create(r);
            Sequence _exitSequence = execRegion.getExitSequence();
            boolean bl = _tripleNotEquals2 = _exitSequence != null;
            if (!_tripleNotEquals2) continue;
            seq.getSteps().add((Object)this.mapping.newCall(execRegion.getExitSequence()));
        }
        List<SubmachineReferenceExpression> _embeddedSubMachines = this._subMachine.embeddedSubMachines(state);
        for (SubmachineReferenceExpression subRef : _embeddedSubMachines) {
            ExecutionState subMachineState = this.mapping.create(subRef);
            EList<Step> _steps = seq.getSteps();
            ExitState _newExitStateStep = this.sexec.newExitStateStep(subMachineState);
            _steps.add((Object)_newExitStateStep);
        }
        boolean bl = _not = state.getOutgoingTransitions().size() != 1 || !(((Transition)IterableExtensions.head((Iterable)state.getOutgoingTransitions())).getTarget() instanceof FinalState);
        if (_not) {
            EList<Step> _steps = seq.getSteps();
            ExitState _newExitStateStep = this.sexec.newExitStateStep(execState);
            _steps.add((Object)_newExitStateStep);
        }
        boolean bl2 = _tripleNotEquals = (_exitAction = execState.getExitAction()) != null;
        if (_tripleNotEquals) {
            seq.getSteps().add((Object)this.mapping.newCall(execState.getExitAction()));
        }
        this.trace._trace(seq, this.trace._traceStateExited(execState));
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(seq.getSteps());
        if (_isNullOrEmpty) {
            execState.setExitSequence(null);
        } else {
            execState.setExitSequence(seq);
        }
    }

    public StateSwitch defineExitSwitch(ExecutionRegion region, Iterable<ExecutionState> leafStates, int pos) {
        StateSwitch sSwitch = this.sexec.factory().createStateSwitch();
        sSwitch.setStateConfigurationIdx(pos);
        String _name = region.getName();
        String _plus = "Handle exit of all possible states (of " + _name;
        String _plus_1 = _plus + ") at position ";
        int _stateConfigurationIdx = sSwitch.getStateConfigurationIdx();
        String _plus_2 = _plus_1 + String.valueOf((Object)_stateConfigurationIdx);
        String _plus_3 = _plus_2 + "...";
        sSwitch.setComment(_plus_3);
        Functions.Function1 _function = rs -> rs.getStateVector().getSize() == 1 && rs.getStateVector().getOffset() == pos;
        Iterable posStates = IterableExtensions.filter(leafStates, (Functions.Function1)_function);
        for (ExecutionState s : posStates) {
            boolean _not;
            boolean _tripleNotEquals;
            Sequence caseSeq = this.sexec.factory().createSequence();
            ArrayList<ExecutionScope> exitScopes = this.sexec.parentScopes(s);
            exitScopes.removeAll(this.sexec.parentScopes(region));
            exitScopes.remove(s);
            Sequence _exitSequence = s.getExitSequence();
            boolean bl = _tripleNotEquals = _exitSequence != null;
            if (_tripleNotEquals) {
                EList<Step> _steps = caseSeq.getSteps();
                Call _newCall = this.mapping.newCall(s.getExitSequence());
                _steps.add((Object)_newCall);
            }
            Functions.Function2 _function_1 = (cs, exitScope) -> {
                Sequence _xblockexpression = null;
                if (exitScope instanceof ExecutionState && this._stateVectorExtensions.last(this._stateVectorExtensions.impactVector(s)) == this._stateVectorExtensions.last(this._stateVectorExtensions.impactVector((ExecutionScope)exitScope))) {
                    boolean _tripleNotEquals_1;
                    ExecutionState execState = (ExecutionState)exitScope;
                    Step _exitAction = execState.getExitAction();
                    boolean bl = _tripleNotEquals_1 = _exitAction != null;
                    if (_tripleNotEquals_1) {
                        cs.getSteps().add((Object)this.mapping.newCall(execState.getExitAction()));
                    }
                    this.trace._trace((Sequence)cs, this.trace._traceStateExited(execState));
                }
                _xblockexpression = cs;
                return _xblockexpression;
            };
            IterableExtensions.fold(exitScopes, (Object)caseSeq, (Functions.Function2)_function_1);
            boolean _isEmpty = caseSeq.getSteps().isEmpty();
            boolean bl2 = _not = !_isEmpty;
            if (!_not) continue;
            sSwitch.getCases().add((Object)this.sexec.newCase(s, caseSeq));
        }
        return sSwitch;
    }

    public Sequence defineStatechartExitSequence(ExecutionFlow flow, Statechart sc) {
        boolean _tripleNotEquals;
        Sequence exitSequence = this.sexec.factory().createSequence();
        exitSequence.setName("exit");
        String _name = sc.getName();
        String _plus = "Default exit sequence for statechart " + _name;
        exitSequence.setComment(_plus);
        EList _regions = sc.getRegions();
        for (Region r : _regions) {
            ExitState execRegionNodeSeq;
            boolean _tripleNotEquals2;
            ExecutionRegion execRegion = this.mapping.create(r);
            Sequence _exitSequence = execRegion.getExitSequence();
            boolean bl = _tripleNotEquals2 = _exitSequence != null;
            if (_tripleNotEquals2) {
                exitSequence.getSteps().add((Object)this.mapping.newCall(execRegion.getExitSequence()));
            }
            ExecutionState _head = (ExecutionState)IterableExtensions.head((Iterable)Iterables.filter(execRegion.getNodes(), ExecutionState.class));
            ExitState _newExitStateStep = null;
            if (_head != null) {
                _newExitStateStep = this.sexec.newExitStateStep(_head);
            }
            if ((execRegionNodeSeq = _newExitStateStep) == null) continue;
            EList<Step> _steps = exitSequence.getSteps();
            _steps.add((Object)execRegionNodeSeq);
        }
        Step _exitAction = flow.getExitAction();
        boolean bl = _tripleNotEquals = _exitAction != null;
        if (_tripleNotEquals) {
            exitSequence.getSteps().add((Object)this.mapping.newCall(flow.getExitAction()));
        }
        flow.setExitSequence(exitSequence);
        return exitSequence;
    }

    public Sequence defineStatechartEnterSequence(ExecutionFlow flow, Statechart sc) {
        boolean _tripleNotEquals;
        Sequence enterSequence = this.sexec.factory().createSequence();
        enterSequence.setName(DEFAULT_SEQUENCE_NAME);
        String _name = sc.getName();
        String _plus = "Default enter sequence for statechart " + _name;
        enterSequence.setComment(_plus);
        Step _entryAction = flow.getEntryAction();
        boolean bl = _tripleNotEquals = _entryAction != null;
        if (_tripleNotEquals) {
            enterSequence.getSteps().add((Object)this.mapping.newCall(flow.getEntryAction()));
        }
        EList _regions = sc.getRegions();
        for (Region r : _regions) {
            boolean _tripleNotEquals_1;
            ExecutionRegion execRegion = this.mapping.create(r);
            Sequence _defaultSequence = this._sExecExtensions.defaultSequence((List<Sequence>)execRegion.getEnterSequences());
            boolean bl2 = _tripleNotEquals_1 = _defaultSequence != null;
            if (!_tripleNotEquals_1) continue;
            enterSequence.getSteps().add((Object)this.mapping.newCall(this._sExecExtensions.defaultSequence((List<Sequence>)execRegion.getEnterSequences())));
        }
        EList _enterSequences = flow.getEnterSequences();
        _enterSequences.add((Object)enterSequence);
        return enterSequence;
    }

    public Sequence defineStatechartStaticInitSequence(ExecutionFlow flow, Statechart sc) {
        Sequence initSequence = this.sexec.factory().createSequence();
        initSequence.setName("staticInit");
        String _name = sc.getName();
        String _plus = "The statecharts init sequence for constants." + _name;
        initSequence.setComment(_plus);
        Iterable<VariableDefinition> _variablesForInitSequence = this.getVariablesForInitSequence(flow, true);
        for (VariableDefinition vd : _variablesForInitSequence) {
            this.addVariableInitializationStep(initSequence, vd);
        }
        flow.setStaticInitSequence(initSequence);
        return initSequence;
    }

    public Sequence defineStatechartInitSequence(ExecutionFlow flow, Statechart sc) {
        Sequence initSequence = this.sexec.factory().createSequence();
        initSequence.setName("init");
        String _name = sc.getName();
        String _plus = "Default init sequence for statechart " + _name;
        initSequence.setComment(_plus);
        Iterable<VariableDefinition> _variablesForInitSequence = this.getVariablesForInitSequence(flow, false);
        for (VariableDefinition vd : _variablesForInitSequence) {
            this.addVariableInitializationStep(initSequence, vd);
        }
        flow.setInitSequence(initSequence);
        return initSequence;
    }

    protected Iterable<VariableDefinition> getVariablesForInitSequence(ExecutionFlow flow, boolean const_) {
        Functions.Function1 _function = s -> s.getVariables();
        Functions.Function1 _function_1 = v -> {
            boolean _isConst = v.isConst();
            return _isConst == const_;
        };
        Iterable statechartVariables = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)flow.getScopes(), (Functions.Function1)_function)), VariableDefinition.class), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = s -> s.getDeclarations();
        Functions.Function1 _function_3 = d -> d.getDeclaration();
        Iterable importedVariables = Iterables.filter((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)flow.getScopes(), (Functions.Function1)_function_2)), ImportDeclaration.class), (Functions.Function1)_function_3), VariableDefinition.class);
        return Iterables.concat((Iterable)statechartVariables, (Iterable)importedVariables);
    }

    public boolean addVariableInitializationStep(Sequence initSequence, VariableDefinition vd) {
        boolean _tripleNotEquals;
        boolean _xifexpression = false;
        Expression _effectiveInitialValue = this.effectiveInitialValue(vd);
        boolean bl = _tripleNotEquals = _effectiveInitialValue != null;
        if (_tripleNotEquals) {
            _xifexpression = initSequence.getSteps().add((Object)this.createInitialization(vd));
        }
        return _xifexpression;
    }

    public Expression effectiveInitialValue(VariableDefinition vd) {
        boolean _tripleNotEquals;
        Expression _initialValue = vd.getInitialValue();
        boolean bl = _tripleNotEquals = _initialValue != null;
        if (_tripleNotEquals) {
            return vd.getInitialValue();
        }
        boolean _isOriginStatechart = this._statechartUtil.isOriginStatechart((EObject)vd.getType());
        if (_isOriginStatechart) {
            return this.buildValue(null);
        }
        Type _type = vd.getType();
        Object _defaultValue = null;
        if (_type != null) {
            _defaultValue = this._iTypeValueProvider.defaultValue(_type);
        }
        Expression _buildValue = null;
        if (_defaultValue != null) {
            _buildValue = this.buildValue(_defaultValue);
        }
        return _buildValue;
    }

    public Execution createInitialization(VariableDefinition vd) {
        Execution execution = this.sexec.factory().createExecution();
        AssignmentExpression assignment = this.factory.createAssignmentExpression();
        ElementReferenceExpression reference = this.factory.createElementReferenceExpression();
        reference.setReference((EObject)vd);
        assignment.setVarRef((Expression)reference);
        assignment.setOperator(AssignmentOperator.ASSIGN);
        assignment.setExpression((Expression)EcoreUtil.copy((EObject)this.effectiveInitialValue(vd)));
        execution.setStatement((Expression)assignment);
        return execution;
    }

    public Expression buildValueExpression(TimeEventSpec tes) {
        Expression _xblockexpression = null;
        Expression pve = (Expression)EcoreUtil.copy((EObject)tes.getValue());
        Expression _switchResult = null;
        TimeUnit _unit = tes.getUnit();
        if (_unit != null) {
            switch (_unit) {
                case MILLISECOND: {
                    _switchResult = pve;
                    break;
                }
                case MICROSECOND: {
                    _switchResult = this.divide(pve, 1000L);
                    break;
                }
                case NANOSECOND: {
                    _switchResult = this.divide(pve, 1000000L);
                    break;
                }
                case SECOND: {
                    _switchResult = this.multiply(pve, 1000L);
                    break;
                }
                default: {
                    _switchResult = pve;
                    break;
                }
            }
        } else {
            _switchResult = pve;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public Expression divide(Expression stmnt, long divisor) {
        NumericalMultiplyDivideExpression _xblockexpression = null;
        NumericalMultiplyDivideExpression div = this.factory.createNumericalMultiplyDivideExpression();
        PrimitiveValueExpression pve = this.factory.createPrimitiveValueExpression();
        IntLiteral intLit = this.factory.createIntLiteral();
        intLit.setValue((long)Long.valueOf(divisor).intValue());
        pve.setValue((Literal)intLit);
        div.setOperator(MultiplicativeOperator.DIV);
        div.setLeftOperand(stmnt);
        div.setRightOperand((Expression)pve);
        _xblockexpression = div;
        return _xblockexpression;
    }

    public Expression multiply(Expression stmnt, long factor) {
        NumericalMultiplyDivideExpression _xblockexpression = null;
        NumericalMultiplyDivideExpression div = this.factory.createNumericalMultiplyDivideExpression();
        PrimitiveValueExpression pve = this.factory.createPrimitiveValueExpression();
        IntLiteral intLit = this.factory.createIntLiteral();
        intLit.setValue((long)Long.valueOf(factor).intValue());
        pve.setValue((Literal)intLit);
        div.setOperator(MultiplicativeOperator.MUL);
        div.setLeftOperand(stmnt);
        div.setRightOperand((Expression)pve);
        _xblockexpression = div;
        return _xblockexpression;
    }

    protected Expression _buildValue(Boolean b) {
        PrimitiveValueExpression _xblockexpression = null;
        PrimitiveValueExpression pve = this.factory.createPrimitiveValueExpression();
        BoolLiteral lit = this.factory.createBoolLiteral();
        lit.setValue(b.booleanValue());
        pve.setValue((Literal)lit);
        _xblockexpression = pve;
        return _xblockexpression;
    }

    protected Expression _buildValue(Integer i) {
        PrimitiveValueExpression _xblockexpression = null;
        PrimitiveValueExpression pve = this.factory.createPrimitiveValueExpression();
        IntLiteral lit = this.factory.createIntLiteral();
        lit.setValue((long)i.intValue());
        pve.setValue((Literal)lit);
        _xblockexpression = pve;
        return _xblockexpression;
    }

    protected Expression _buildValue(Long i) {
        PrimitiveValueExpression _xblockexpression = null;
        PrimitiveValueExpression pve = this.factory.createPrimitiveValueExpression();
        IntLiteral lit = this.factory.createIntLiteral();
        lit.setValue((long)i.intValue());
        pve.setValue((Literal)lit);
        _xblockexpression = pve;
        return _xblockexpression;
    }

    protected Expression _buildValue(Double d) {
        PrimitiveValueExpression _xblockexpression = null;
        PrimitiveValueExpression pve = this.factory.createPrimitiveValueExpression();
        DoubleLiteral lit = this.factory.createDoubleLiteral();
        lit.setValue(d.doubleValue());
        pve.setValue((Literal)lit);
        _xblockexpression = pve;
        return _xblockexpression;
    }

    protected Expression _buildValue(Float d) {
        PrimitiveValueExpression _xblockexpression = null;
        PrimitiveValueExpression pve = this.factory.createPrimitiveValueExpression();
        FloatLiteral lit = this.factory.createFloatLiteral();
        lit.setValue(d.floatValue());
        pve.setValue((Literal)lit);
        _xblockexpression = pve;
        return _xblockexpression;
    }

    protected Expression _buildValue(String i) {
        PrimitiveValueExpression _xblockexpression = null;
        PrimitiveValueExpression pve = this.factory.createPrimitiveValueExpression();
        StringLiteral lit = this.factory.createStringLiteral();
        lit.setValue(i);
        pve.setValue((Literal)lit);
        _xblockexpression = pve;
        return _xblockexpression;
    }

    protected Expression _buildValue(Void v) {
        PrimitiveValueExpression _xblockexpression = null;
        PrimitiveValueExpression pve = this.factory.createPrimitiveValueExpression();
        pve.setValue((Literal)this.factory.createNullLiteral());
        _xblockexpression = pve;
        return _xblockexpression;
    }

    protected Expression _buildValue(Object o) {
        return null;
    }

    @XbaseGenerated
    public void defineScopeEnterSequences(NamedElement state) {
        if (state instanceof FinalState) {
            this._defineScopeEnterSequences((FinalState)state);
            return;
        }
        if (state instanceof State) {
            this._defineScopeEnterSequences((State)state);
            return;
        }
        if (state instanceof Region) {
            this._defineScopeEnterSequences((Region)state);
            return;
        }
        if (state instanceof Vertex) {
            this._defineScopeEnterSequences((Vertex)state);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(state).toString());
    }

    @XbaseGenerated
    public void defineStateExitSequence(NamedElement s) {
        if (s instanceof FinalState) {
            this._defineStateExitSequence((FinalState)s);
            return;
        }
        if (s instanceof State) {
            this._defineStateExitSequence((State)s);
            return;
        }
        if (s instanceof Region) {
            this._defineStateExitSequence((Region)s);
            return;
        }
        if (s instanceof Vertex) {
            this._defineStateExitSequence((Vertex)s);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(s).toString());
    }

    @XbaseGenerated
    public Expression buildValue(Object d) {
        if (d instanceof Double) {
            return this._buildValue((Double)d);
        }
        if (d instanceof Float) {
            return this._buildValue((Float)d);
        }
        if (d instanceof Integer) {
            return this._buildValue((Integer)d);
        }
        if (d instanceof Long) {
            return this._buildValue((Long)d);
        }
        if (d instanceof Boolean) {
            return this._buildValue((Boolean)d);
        }
        if (d instanceof String) {
            return this._buildValue((String)d);
        }
        if (d == null) {
            return this._buildValue((Void)null);
        }
        return this._buildValue(d);
    }
}

