/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.types.scoping;

import com.google.common.collect.Sets;
import com.yakindu.base.types.scoping.IPackageImport2URIMapper;
import com.yakindu.sct.license.LicenseChecker;
import com.yakindu.sct.model.sgraph.util.ContextElementAdapter;
import com.yakindu.sct.model.stext.scoping.AbstractPackageImportUriMapper;
import com.yakindu.sct.runtime.ContentTypeHelper;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;

public class StatechartImport2URIMapper
extends AbstractPackageImportUriMapper
implements IPackageImport2URIMapper {
    public Optional<IPackageImport2URIMapper.PackageImport> findPackageImport(Resource context, String packageImport) {
        if (packageImport.equals("statemachine.types")) {
            return Optional.of(new IPackageImport2URIMapper.PackageImport(packageImport, URI.createURI((String)"statemachine.types"), ""));
        }
        Optional importedFile = super.getImportedFile(context, packageImport);
        if (!importedFile.isPresent()) {
            return Optional.empty();
        }
        return this.findPackageImport((IResource)importedFile.get(), (IResource)WorkspaceSynchronizer.getFile((Resource)this.getContextResource(context)));
    }

    public boolean canHandle(Resource context, String packageImport) {
        if (packageImport.equals("statemachine.types")) {
            return true;
        }
        Optional importedFile = super.getImportedFile(context, packageImport);
        if (!importedFile.isPresent()) {
            return false;
        }
        return ContentTypeHelper.isStatechart((IFile)((IFile)importedFile.get())) && this.isLicenseValid();
    }

    private boolean isLicenseValid() {
        return new LicenseChecker().checkProfessionalLicense().isValidOrTrial();
    }

    protected Optional<IPackageImport2URIMapper.PackageImport> findPackageImport(IResource resource, IResource context) {
        if (resource instanceof IFile && ContentTypeHelper.isStatechart((IFile)((IFile)resource))) {
            URI typesURI = this.createUri(resource);
            String importLiteral = resource.getFullPath().makeRelativeTo(context.getFullPath().removeLastSegments(1)).toPortableString();
            String fileExtension = typesURI.fileExtension();
            IPackageImport2URIMapper.PackageImport e = new IPackageImport2URIMapper.PackageImport(importLiteral, typesURI.trimFileExtension().appendFileExtension(fileExtension + "_types"), "");
            e.setFileURI(typesURI);
            return Optional.of(e);
        }
        return Optional.empty();
    }

    protected URI createUri(IResource resource) {
        return URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
    }

    public Set<IPackageImport2URIMapper.PackageImport> getAllImports(Resource context) {
        final IFile file = WorkspaceSynchronizer.getFile((Resource)this.getContextResource(context));
        IProject project = file.getProject();
        final HashSet result = Sets.newHashSet();
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    Optional<IPackageImport2URIMapper.PackageImport> e;
                    if (resource instanceof IFile && ContentTypeHelper.isStatechart((IFile)((IFile)resource)) && (e = StatechartImport2URIMapper.this.findPackageImport(resource, (IResource)file)).isPresent()) {
                        result.add(e.get());
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected Resource getContextResource(Resource context) {
        ContextElementAdapter provider = (ContextElementAdapter)EcoreUtil.getExistingAdapter((Notifier)context, ContextElementAdapter.class);
        if (provider != null) {
            return provider.getElement().eResource();
        }
        return context;
    }
}

