/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.types.simulation;

import com.google.inject.Inject;
import com.yakindu.base.base.NamedElement;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.model.sruntime.ExecutionSlot;
import com.yakindu.sct.simulation.core.debugmodel.SCTDebugTarget;
import com.yakindu.sct.simulation.core.engine.ISimulationEngine;
import com.yakindu.sct.simulation.core.sexec.interpreter.MultiStatechartInjector;
import com.yakindu.sct.types.simulation.SubchartSimulationFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.xtext.naming.IQualifiedNameProvider;

public class MultiStatechartSimulationDelegate
implements ILaunchConfigurationDelegate {
    @Inject
    private SubchartSimulationFactory factory;
    @Inject
    protected IQualifiedNameProvider fqnProvider;
    @Inject
    protected MultiStatechartInjector injector;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IDebugTarget mainTarget = launch.getDebugTarget();
        ExecutionContext machine = (ExecutionContext)mainTarget.getAdapter(ExecutionContext.class);
        this.injector.inject((Object)machine);
        this.setupDebugTargets(launch, machine);
    }

    protected void setupDebugTargets(ILaunch launch, ExecutionContext machineContext) {
        ExecutionContext root = (ExecutionContext)machineContext.eContainer();
        for (ExecutionSlot s : root.getSlots()) {
            if (s == machineContext || !(s instanceof ExecutionContext)) continue;
            try {
                ExecutionContext context = (ExecutionContext)s;
                Statechart statechart = this.getStatechartFrom(context);
                SCTDebugTarget machineTarget = this.createSubmachineDebugTarget(launch, statechart, context.getContextFqn());
                ISimulationEngine engine = (ISimulationEngine)machineTarget.getAdapter(ISimulationEngine.class);
                engine.setExecutionContext(context);
                machineTarget.init();
                launch.addDebugTarget((IDebugTarget)machineTarget);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected Statechart getStatechartFrom(ExecutionContext context) {
        if (context.getType() instanceof ExecutionFlow && ((ExecutionFlow)context.getType()).getSourceElement() instanceof Statechart) {
            return (Statechart)((ExecutionFlow)context.getType()).getSourceElement();
        }
        return null;
    }

    protected SCTDebugTarget createSubmachineDebugTarget(ILaunch launch, Statechart statechart, String context) throws CoreException {
        Assert.isNotNull((Object)statechart);
        ISimulationEngine engine = this.factory.createExecutionContainer(statechart, launch);
        return new SCTDebugTarget(launch, (NamedElement)statechart, context, engine);
    }
}

