/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.base.extensions;

import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.AssignmentExpression;
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import com.yakindu.sctunit.generator.base.extensions.BaseExpressionExtensions;
import com.yakindu.sctunit.inferrer.TypesProvider;
import com.yakindu.sctunit.sCTUnit.AssertionStatement;
import com.yakindu.sctunit.sCTUnit.CodeBlock;
import com.yakindu.sctunit.sCTUnit.ExpressionStatement;
import com.yakindu.sctunit.sCTUnit.IfStatement;
import com.yakindu.sctunit.sCTUnit.LoopStatement;
import com.yakindu.sctunit.sCTUnit.ProceedExpression;
import com.yakindu.sctunit.sCTUnit.ReturnStatement;
import com.yakindu.sctunit.sCTUnit.TestStatement;
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class BaseStatementExtensions {
    @Inject
    @Extension
    private BaseExpressionExtensions _baseExpressionExtensions;
    @Inject
    protected TypesProvider provider;
    @Inject
    @Extension
    private ICodegenTypeSystemAccess _iCodegenTypeSystemAccess;

    protected ITypeSystem getTypeSystem(EObject context) {
        return this.provider.getTypeSystem(context);
    }

    protected CharSequence _generate(TestStatement statement) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Error");
        return _builder;
    }

    protected CharSequence _generate(LoopStatement stm) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("while (");
        CharSequence _code = this._baseExpressionExtensions.code((EObject)stm.getGuard());
        _builder.append((Object)_code);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        EList _code_1 = stm.getBody().getCode();
        for (TestStatement statement : _code_1) {
            _builder.append("\t");
            CharSequence _generate = this.generate(statement);
            _builder.append((Object)_generate, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generate(ReturnStatement stm) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return ");
        Expression _returnValue = stm.getReturnValue();
        boolean bl = _tripleNotEquals = _returnValue != null;
        if (_tripleNotEquals) {
            CharSequence _code = this._baseExpressionExtensions.code((EObject)stm.getReturnValue());
            _builder.append((Object)_code);
        }
        _builder.append(";");
        return _builder;
    }

    protected CharSequence _generate(VariableDefinitionStatement stm) {
        boolean _tripleNotEquals;
        StringConcatenation _xifexpression = null;
        Expression _initialValue = stm.getDefinition().getInitialValue();
        boolean bl = _tripleNotEquals = _initialValue != null;
        if (_tripleNotEquals) {
            return this.generateInitialValue(stm.getDefinition(), stm.getDefinition().getInitialValue());
        }
        StringConcatenation _builder = new StringConcatenation();
        String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(stm.getDefinition().getType());
        _builder.append(_targetLanguageName);
        _builder.append(" ");
        String _name = stm.getDefinition().getName();
        _builder.append(_name);
        _builder.append(";");
        _xifexpression = _builder;
        return _xifexpression;
    }

    protected CharSequence _generate(IfStatement stm) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (");
        CharSequence _code = this._baseExpressionExtensions.code((EObject)stm.getCondition());
        _builder.append((Object)_code);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        EList _code_1 = stm.getThen().getCode();
        for (TestStatement trueExpression : _code_1) {
            _builder.append("\t");
            CharSequence _generate = this._baseExpressionExtensions.stms.generate(trueExpression);
            _builder.append((Object)_generate, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        CodeBlock _else = stm.getElse();
        boolean bl = _tripleNotEquals = _else != null;
        if (_tripleNotEquals) {
            _builder.append("else {");
            _builder.newLine();
            EList _code_2 = stm.getElse().getCode();
            for (TestStatement falseExpression : _code_2) {
                _builder.append("\t");
                CharSequence _generate_1 = this._baseExpressionExtensions.stms.generate(falseExpression);
                _builder.append((Object)_generate_1, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _generate(ExpressionStatement stm) {
        boolean _tripleNotEquals;
        Expression exp = stm.getExpression();
        if (stm.getExpression() instanceof PrimitiveValueExpression && this.contextNotAssignOrVarDef(stm)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("return ");
            CharSequence _code = this._baseExpressionExtensions.code((EObject)stm.getExpression());
            _builder.append((Object)_code);
            _builder.append(";");
            return _builder;
        }
        if (exp instanceof ProceedExpression) {
            StringConcatenation _builder_1 = new StringConcatenation();
            CharSequence _code_1 = this._baseExpressionExtensions.code((EObject)exp);
            _builder_1.append((Object)_code_1);
            return _builder_1;
        }
        AssertionStatement _containerOfType = (AssertionStatement)EcoreUtil2.getContainerOfType((EObject)stm, AssertionStatement.class);
        boolean bl = _tripleNotEquals = _containerOfType != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder_2 = new StringConcatenation();
            CharSequence _code_2 = this._baseExpressionExtensions.code((EObject)exp);
            _builder_2.append((Object)_code_2);
            return _builder_2;
        }
        StringConcatenation _builder_3 = new StringConcatenation();
        CharSequence _code_3 = this._baseExpressionExtensions.code((EObject)exp);
        _builder_3.append((Object)_code_3);
        _builder_3.append(";");
        return _builder_3;
    }

    public boolean contextNotAssignOrVarDef(ExpressionStatement stm) {
        return EcoreUtil2.getContainerOfType((EObject)stm, AssignmentExpression.class) == null && EcoreUtil2.getContainerOfType((EObject)stm, VariableDefinition.class) == null;
    }

    public CharSequence generateInitialValue(VariableDefinition it, Expression expr) {
        StringConcatenation _builder = new StringConcatenation();
        String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(it.getType());
        _builder.append(_targetLanguageName);
        _builder.append(" ");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append(" = ");
        CharSequence _code = this._baseExpressionExtensions.code((EObject)expr);
        _builder.append((Object)_code);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @XbaseGenerated
    public CharSequence generate(TestStatement stm) {
        if (stm instanceof ExpressionStatement) {
            return this._generate((ExpressionStatement)stm);
        }
        if (stm instanceof IfStatement) {
            return this._generate((IfStatement)stm);
        }
        if (stm instanceof LoopStatement) {
            return this._generate((LoopStatement)stm);
        }
        if (stm instanceof ReturnStatement) {
            return this._generate((ReturnStatement)stm);
        }
        if (stm instanceof VariableDefinitionStatement) {
            return this._generate((VariableDefinitionStatement)stm);
        }
        if (stm != null) {
            return this._generate(stm);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stm).toString());
    }
}

