/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.simulation.ui.console;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.yakindu.sctunit.simulation.ui.SimulationUIActivator;
import com.yakindu.sctunit.simulation.ui.console.SCTUnitConsole;
import com.yakindu.sctunit.ui.SCTUnitActivator;
import java.io.IOException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.scoping.impl.ResourceSetGlobalScopeProvider;

public class SCTUnitConsoleFactory
implements IConsoleFactory {
    protected static final String TITLE = "SCTUnit Interactive Console";
    protected static final String WELCOME = "SCT Unit Interactive Console started...\n";
    protected static final String ICON = "icons/SCTUnit.png";
    protected static final String TYPE = "com.yakindu.sctunit";

    public void openConsole() {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        Injector injector = SCTUnitActivator.getInstance().createInjector("com.yakindu.sctunit.SCTUnit", this.createOverrideModule());
        SCTUnitConsole console = new SCTUnitConsole(TITLE, TYPE, this.imageDescriptor());
        injector.injectMembers((Object)console);
        consoleManager.addConsoles(new IConsole[]{console});
        try {
            IOConsoleOutputStream newOutputStream = console.newOutputStream();
            newOutputStream.write(WELCOME);
            newOutputStream.flush();
            newOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected ImageDescriptor imageDescriptor() {
        SimulationUIActivator plugin = SimulationUIActivator.getDefault();
        ImageRegistry imageRegistry = plugin.getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(ICON);
        if (imageDescriptor == null) {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)plugin.getBundle().getEntry(ICON));
            plugin.getImageRegistry().put(ICON, id);
            imageDescriptor = imageRegistry.getDescriptor(ICON);
        }
        return imageDescriptor;
    }

    protected Module createOverrideModule() {
        return new Module(){

            public void configure(Binder binder) {
                binder.bind(IGlobalScopeProvider.class).to(ResourceSetGlobalScopeProvider.class);
            }
        };
    }
}

