/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.image;

import com.google.inject.Inject;
import com.yakindu.base.base.NamedElement;
import com.yakindu.sct.generator.core.ISGraphGenerator;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.naming.SGraphShortNameProvider;
import com.yakindu.sct.model.sgraph.util.SgraphExtensions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.generator.IFileSystemAccess;

public class ImageGenerator
implements ISGraphGenerator {
    @Inject
    private ICoreLibraryHelper libraryHelper;
    @Inject
    private CopyToImageUtil renderer;
    @Inject
    protected SGraphShortNameProvider fqNameProvider;
    @Inject
    protected SgraphExtensions sgraphExt;

    public void generate(Statechart statechart, GeneratorEntry entry, IFileSystemAccess fsa) {
        String format = entry.getFeatureParameterValue("Renderer", "format").getStringValue();
        String targetElementNames = entry.getFeatureParameterValue("Renderer", "generateByElementName") == null ? "" : entry.getFeatureParameterValue("Renderer", "generateByElementName").getStringValue();
        boolean useShortNames = entry.getFeatureParameterValue("Renderer", "shortNaming") == null ? false : entry.getFeatureParameterValue("Renderer", "shortNaming").getBooleanValue();
        boolean generateStateDoc = entry.getFeatureParameterValue("Renderer", "generateStateDocumentation") == null ? false : entry.getFeatureParameterValue("Renderer", "generateStateDocumentation").getBooleanValue();
        String targetProject = this.libraryHelper.getTargetProjectValue(entry).getStringValue();
        String targetfolder = this.libraryHelper.getTargetFolderValue(entry).getStringValue();
        IFolder targetFolder = this.createTargetFolder(targetProject, targetfolder);
        Collection diagrams = EcoreUtil.getObjectsByType((Collection)statechart.eResource().getContents(), (EClassifier)NotationPackage.Literals.DIAGRAM);
        LinkedHashMap<String, String> shortNameMap = new LinkedHashMap<String, String>();
        int counter = 0;
        for (Diagram diagram : diagrams) {
            String[] stringArray = targetElementNames.split("\\s*,\\s*");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String targetElementName = stringArray[n2];
                byte[] result = this.renderImage(diagram, format, targetElementName);
                ByteArrayInputStream source = new ByteArrayInputStream(result);
                String elementName = !targetElementName.isBlank() || useShortNames ? this.getFqNameFor(diagram, targetElementName, useShortNames, shortNameMap) + "_" : "";
                IFile file = targetFolder.getFile(((NamedElement)diagram.getElement()).getName() + "_" + elementName + counter++ + "." + format);
                try {
                    if (file.exists()) {
                        file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    file.create((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        if (useShortNames && !shortNameMap.isEmpty()) {
            this.createMappingCsv(targetFolder, statechart.getName(), shortNameMap);
        }
        if (generateStateDoc) {
            this.createStateDocumentationCsv(targetFolder, statechart);
        }
    }

    protected void createStateDocumentationCsv(IFolder targetFolder, Statechart statechart) {
        StringBuilder csv = new StringBuilder();
        csv.append("State,Documentation\n");
        ArrayList<State> states = new ArrayList<State>();
        TreeIterator it = statechart.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof State)) continue;
            State s = (State)obj;
            states.add(s);
        }
        for (State state : states) {
            String name = this.normalizedFullyQualifiedName((EObject)state);
            String doc = "";
            if (state.getDocumentation() != null && state.getDocumentation() != null) {
                doc = state.getDocumentation().replace(",", "','").replace("\n", "\\n").replace("\"", "\"\"");
            }
            csv.append("\"").append(name.replace("\"", "\"\"")).append("\",\"").append(doc).append("\"\n");
        }
        IFile csvFile = targetFolder.getFile(statechart.getName() + "_state_documentation.csv");
        try {
            ByteArrayInputStream source = new ByteArrayInputStream(csv.toString().getBytes(StandardCharsets.UTF_8));
            if (csvFile.exists()) {
                csvFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            csvFile.create((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void createMappingCsv(IFolder targetFolder, String statechartName, Map<String, String> map) {
        StringBuilder csvContent = new StringBuilder();
        csvContent.append("ID,FullyQualifiedName\n");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            csvContent.append(entry.getKey()).append(",").append(entry.getValue()).append("\n");
        }
        IFile csvFile = targetFolder.getFile(statechartName + "_ID_name_mapping.csv");
        try {
            ByteArrayInputStream source = new ByteArrayInputStream(csvContent.toString().getBytes(StandardCharsets.UTF_8));
            if (csvFile.exists()) {
                csvFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            csvFile.create((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected IFolder createTargetFolder(String targetProject, String targetfolder) {
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getProject(targetProject).getFolder((IPath)new Path(targetfolder));
        if (!folder.exists()) {
            try {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return folder;
    }

    protected String getFqNameFor(Diagram diagram, String targetElementName, boolean useShortNames, Map<String, String> mapping) {
        Display display = Display.getDefault();
        String[] fqName = new String[]{""};
        display.syncExec(() -> {
            Shell shell = null;
            try {
                DiagramEditPart diagramEditPart;
                shell = new Shell(display);
                if (diagram == null) {
                    return;
                }
                PreferencesHint preferencesHint = PreferencesHint.USE_DEFAULTS;
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
                if (editingDomain == null) {
                    TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(diagram.eResource().getResourceSet());
                }
                if ((diagramEditPart = this.renderer.createDiagramEditPart(diagram, shell, preferencesHint)) == null) {
                    System.err.println("[ERROR] DiagramEditPart is null! Rendering cannot proceed.");
                    return;
                }
                try {
                    EditPart targetEditPart;
                    Object editPartModel;
                    diagramEditPart.refresh();
                    diagramEditPart.getFigure().validate();
                    if (!targetElementName.isBlank() && (editPartModel = (targetEditPart = this.findEditPartByName((EditPart)diagramEditPart, targetElementName)).getModel()) instanceof Node) {
                        Node nodeModel = (Node)editPartModel;
                        EObject element = nodeModel.getElement();
                        String fullyQualifiedName = null;
                        if (element instanceof State || element instanceof Region) {
                            fullyQualifiedName = this.normalizedFullyQualifiedName(element);
                        }
                        if (useShortNames && element instanceof NamedElement) {
                            String xmiId;
                            NamedElement targetElement = (NamedElement)element;
                            stringArray[0] = xmiId = this.getXmiId((EObject)targetElement);
                            if (mapping != null && fullyQualifiedName != null) {
                                mapping.put(xmiId, fullyQualifiedName);
                            }
                        } else if (fullyQualifiedName != null) {
                            stringArray[0] = fullyQualifiedName;
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            finally {
                if (shell != null && !shell.isDisposed()) {
                    shell.dispose();
                }
            }
        });
        return fqName[0];
    }

    protected String getFqNameFor(Diagram diagram, String targetElementName, boolean useShortNames) {
        return this.getFqNameFor(diagram, targetElementName, useShortNames, null);
    }

    protected String getXmiId(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource instanceof XMLResource) {
            return ((XMLResource)resource).getID(eObject);
        }
        return null;
    }

    public byte[] renderImage(Diagram diagram, String format, String targetElementName) {
        String imageFormat = format == null || format.isEmpty() ? "PNG" : format;
        Display display = Display.getDefault();
        byte[][] resultHolder = new byte[1][];
        display.syncExec(() -> this.lambda$1(display, diagram, imageFormat, targetElementName, resultHolder));
        if (resultHolder[0] == null) {
            System.err.println("[ERROR] Final result is null, image generation failed!");
        }
        return resultHolder[0];
    }

    private EditPart findEditPartByName(EditPart root, String targetName) {
        EStructuralFeature nameFeature;
        EObject element;
        if (root instanceof IGraphicalEditPart && (element = ((IGraphicalEditPart)root).resolveSemanticElement()) != null && (nameFeature = element.eClass().getEStructuralFeature("name")) != null) {
            Region r;
            String fqName;
            State s;
            String fqName2;
            Object nameValue = element.eGet(nameFeature);
            if (targetName.equals(nameValue)) {
                return root;
            }
            if (element instanceof State ? (fqName2 = this.normalizedFullyQualifiedName((EObject)(s = (State)element))).equals(targetName) : element instanceof Region && (fqName = this.normalizedFullyQualifiedName((EObject)(r = (Region)element))).equals(targetName)) {
                return root;
            }
        }
        List children = root.getChildren();
        for (Object child : children) {
            EditPart result;
            if (!(child instanceof EditPart) || (result = this.findEditPartByName((EditPart)child, targetName)) == null) continue;
            return result;
        }
        return null;
    }

    protected String normalizedFullyQualifiedName(EObject obj) {
        return this.fqNameProvider.getFullyQualifiedName(obj).toString().replaceAll(".*" + this.sgraphExt.getStatechart(obj).getName() + "\\.", "").replaceAll("\\.", "_");
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$1(Display var1_1, Diagram var2_2, String var3_3, String var4_4, byte[][] var5_5) {
        shell = null;
        try {
            shell = new Shell(var1_1);
            if (var2_2 == null) {
                System.err.println("[ERROR] Diagram is null! Cannot render image.");
                return;
            }
            preferencesHint = PreferencesHint.USE_DEFAULTS;
            editingDomain = TransactionUtil.getEditingDomain((EObject)var2_2);
            if (editingDomain == null) {
                TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(var2_2.eResource().getResourceSet());
            }
            if ((diagramEditPart = this.renderer.createDiagramEditPart(var2_2, shell, preferencesHint)) == null) {
                System.err.println("[ERROR] DiagramEditPart is null! Rendering cannot proceed.");
                return;
            }
            diagramEditPart.refresh();
            diagramEditPart.getFigure().validate();
            resolvedFormat = ImageFileFormat.resolveImageFormat((String)var3_3.toUpperCase());
            if (var4_4.isBlank()) ** GOTO lbl27
            targetEditPart = this.findEditPartByName((EditPart)diagramEditPart, var4_4);
            if (targetEditPart == null) {
                System.err.println("[ERROR] Could not find an EditPart representing state " + var4_4 + "\"");
                return;
            }
            try {
                block15: {
                    partsToRender = Collections.singletonList(targetEditPart);
                    var5_5[0] = this.renderer.copyToImageByteArray(diagramEditPart, partsToRender, -1, -1, resolvedFormat, (IProgressMonitor)new NullProgressMonitor(), false);
                    break block15;
lbl27:
                    // 1 sources

                    var5_5[0] = this.renderer.copyToImageByteArray(diagramEditPart, null, -1, -1, resolvedFormat, (IProgressMonitor)new NullProgressMonitor(), false);
                }
                if (var5_5[0] == null) {
                    System.err.println("[ERROR] copyToImageByteArray returned null!");
                }
            }
            catch (Throwable t) {
                System.err.println("[ERROR] Exception during renderImage: " + t.getMessage());
                t.printStackTrace();
            }
        }
        finally {
            if (shell != null && !shell.isDisposed()) {
                shell.dispose();
            }
        }
    }
}

