/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.builder;

import com.google.inject.Singleton;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgen.GeneratorModel;
import com.yakindu.sct.model.sgraph.Statechart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

@Singleton
public class GenmodelIndex {
    private static final Map<URI, Set<IResource>> index = new HashMap<URI, Set<IResource>>();

    public static void addMapping(Statechart sc, IResource genmodel) {
        URI scUri = EcoreUtil.getURI((EObject)sc);
        index.computeIfAbsent(scUri, k -> new HashSet()).add(genmodel);
    }

    public static void removeMapping(IResource genmodel) {
        for (Set<IResource> genmodels : index.values()) {
            genmodels.remove(genmodel);
        }
    }

    public static Collection<IResource> findGenmodelsReferencing(Statechart sc) {
        URI scUri = EcoreUtil.getURI((EObject)sc);
        return index.getOrDefault(scUri, Collections.emptySet());
    }

    public static void rebuildIndex(Collection<IResource> genmodels) {
        index.clear();
        for (IResource res : genmodels) {
            if (res.getType() != 1 || !"sgen".equals(res.getFileExtension())) continue;
            Statechart[] statechartArray = GenmodelIndex.loadReferencedStatecharts((IFile)res);
            int n = statechartArray.length;
            int n2 = 0;
            while (n2 < n) {
                Statechart sc = statechartArray[n2];
                GenmodelIndex.addMapping(sc, res);
                ++n2;
            }
        }
    }

    public static void updateMappingFor(IFile genmodelFile) {
        GenmodelIndex.removeMapping((IResource)genmodelFile);
        Statechart[] statechartArray = GenmodelIndex.loadReferencedStatecharts(genmodelFile);
        int n = statechartArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statechart sc = statechartArray[n2];
            GenmodelIndex.addMapping(sc, (IResource)genmodelFile);
            ++n2;
        }
    }

    private static Statechart[] loadReferencedStatecharts(IFile genmodelFile) {
        ArrayList<Statechart> result = new ArrayList<Statechart>();
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI uri = URI.createPlatformResourceURI((String)genmodelFile.getFullPath().toString(), (boolean)true);
            Resource resource = resourceSet.getResource(uri, true);
            if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof GeneratorModel) {
                GeneratorModel genModel = (GeneratorModel)resource.getContents().get(0);
                for (GeneratorEntry entry : genModel.getEntries()) {
                    EObject elementRef = entry.getElementRef();
                    if (!(elementRef instanceof Statechart)) continue;
                    result.add((Statechart)elementRef);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toArray(new Statechart[0]);
    }
}

