/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.builder.resources;

import com.yakindu.sct.generator.builder.BuilderActivator;
import com.yakindu.sct.generator.builder.resources.DefaultResourceBlacklist;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class BuilderPropertyPage
extends PropertyPage {
    private DefaultResourceBlacklist blacklist = new DefaultResourceBlacklist();
    private TableViewer blackListViewer;
    private List<IResource> values;

    protected Control createContents(Composite parent) {
        Group group = this.createGroup(parent);
        this.createBlacklist((Composite)group);
        return group;
    }

    protected void createBlacklist(Composite parent) {
        this.blackListViewer = this.createBlackListViewer(parent);
        Composite btnComposite = new Composite(parent, 0);
        btnComposite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(false, true).align(2, 1).applyTo((Control)btnComposite);
        this.addAddBtn(btnComposite);
        this.addRemoveBtn(btnComposite);
    }

    protected Group createGroup(Composite blacklistComposite) {
        Group group = new Group(blacklistComposite, 0);
        group.setText("Exclude generator models");
        group.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)group);
        return group;
    }

    protected TableViewer createBlackListViewer(Composite group) {
        TableViewer result = new TableViewer(group, 2562);
        result.getTable().setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(result.getControl());
        result.setContentProvider((IContentProvider)new ArrayContentProvider());
        result.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.values = this.blacklist.getValues(this.getActualProject());
        result.setInput(this.values);
        return result;
    }

    protected void addAddBtn(final Composite btnComposite) {
        Button add = new Button(btnComposite, 0x800000);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).applyTo((Control)add);
        add.setText("Add...");
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(btnComposite.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
                dialog.setValidator((ISelectionStatusValidator)new CheaderBlacklistSelectionStatusValidator());
                dialog.setTitle("Add blacklist item");
                dialog.setMessage("Select a blacklist item:");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.addFilter((ViewerFilter)new CHeaderViewerFilter((IResource)BuilderPropertyPage.this.getActualProject()));
                if (!BuilderPropertyPage.this.values.isEmpty()) {
                    dialog.setInitialSelection((Object)BuilderPropertyPage.this.values.get(BuilderPropertyPage.this.values.size() - 1));
                }
                dialog.setDialogBoundsSettings(BuilderActivator.getDefault().getDialogSettings(), 1);
                dialog.open();
                Object[] result = dialog.getResult();
                if (result != null) {
                    Object[] objectArray = result;
                    int n = result.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object selection = objectArray[n2];
                        if (selection instanceof IResource) {
                            BuilderPropertyPage.this.values.add((IResource)selection);
                        }
                        ++n2;
                    }
                    BuilderPropertyPage.this.blackListViewer.refresh();
                }
            }
        });
    }

    protected void addRemoveBtn(Composite btnComposite) {
        Button remove = new Button(btnComposite, 0x800000);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).applyTo((Control)remove);
        remove.setText("Remove");
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ISelection selection = BuilderPropertyPage.this.blackListViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (IResource object : (IStructuredSelection)selection) {
                        BuilderPropertyPage.this.values.remove(object);
                    }
                    BuilderPropertyPage.this.blackListViewer.refresh();
                }
            }
        });
    }

    protected void performDefaults() {
        super.performDefaults();
        this.values.clear();
        this.blackListViewer.refresh();
    }

    public boolean performOk() {
        IProject project = this.getActualProject();
        List input = (List)this.blackListViewer.getInput();
        boolean save = this.blacklist.save(project, input);
        return save;
    }

    private IProject getActualProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }

    protected String getFileExtension() {
        return "sgen";
    }

    protected final class CHeaderViewerFilter
    extends ViewerFilter {
        private IResource actualProject;

        public CHeaderViewerFilter(IResource project) {
            this.actualProject = project;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IResource resource;
            IProject projectOfResource;
            if (element instanceof IResource && !(projectOfResource = (resource = (IResource)element).getProject()).equals((Object)this.actualProject)) {
                return false;
            }
            if (element instanceof IFile) {
                IFile iFile = (IFile)element;
                if (!BuilderPropertyPage.this.getFileExtension().equals(iFile.getFileExtension())) {
                    return false;
                }
            }
            return true;
        }
    }

    protected final class CheaderBlacklistSelectionStatusValidator
    implements ISelectionStatusValidator {
        protected CheaderBlacklistSelectionStatusValidator() {
        }

        public IStatus validate(Object[] selection) {
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IProject) {
                    return new Status(4, "com.yakindu.sct.builder", "Project can not be selected.");
                }
                if (BuilderPropertyPage.this.values.contains(object)) {
                    return new Status(4, "com.yakindu.sct.builder", "Can not add duplicate.");
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }

    protected static class ResourceLabelProvider
    extends LabelProvider {
        protected ResourceLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IResource) {
                IResource iResource = (IResource)element;
                return iResource.getFullPath().toPortableString();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            return element instanceof IFile ? sharedImages.getImage("IMG_OBJ_FILE") : sharedImages.getImage("IMG_OBJ_FOLDER");
        }
    }
}

