/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.builder.resources;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class DefaultResourceBlacklist {
    private static final String SCT_BLACKLIST_DEFAULT = "";
    public static final String SCT_RESOURCE_NODE = "sct.resource";
    public static final String SCT_BLACKLIST_KEY = "blacklist";
    public static final String SCT_BLACKLIST_SEPERATOR = ",";

    public List<IResource> getValues(IProject project) {
        String[] segments;
        ArrayList result = Lists.newArrayList();
        String string = this.getPersistentValues(project);
        String[] stringArray = segments = string.split(SCT_BLACKLIST_SEPERATOR);
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource;
            String segment = stringArray[n2];
            if (!segment.isEmpty() && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(Path.fromPortableString((String)segment), true)) != null && resource.exists()) {
                result.add(resource);
            }
            ++n2;
        }
        return result;
    }

    protected String getPersistentValues(IProject project) {
        ProjectScope projectScope = this.getPreferenceScope(project);
        IEclipsePreferences node = projectScope.getNode(SCT_RESOURCE_NODE);
        String string = node.get(SCT_BLACKLIST_KEY, SCT_BLACKLIST_DEFAULT);
        return string;
    }

    protected ProjectScope getPreferenceScope(IProject project) {
        return new ProjectScope(project);
    }

    public boolean violates(IResource resource, IProject project) {
        for (IResource blacklistItem : this.getValues(project)) {
            String fileName = resource.getFullPath().toString();
            if (!fileName.contains(blacklistItem.getFullPath().toPortableString())) continue;
            return true;
        }
        return false;
    }

    public boolean save(IProject project, List<IResource> items) {
        ProjectScope projectScope = this.getPreferenceScope(project);
        IEclipsePreferences node = projectScope.getNode(SCT_RESOURCE_NODE);
        String blacklist = this.getBlacklistValue(items);
        node.put(SCT_BLACKLIST_KEY, blacklist);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected String getBlacklistValue(List<IResource> items) {
        Object blacklist = SCT_BLACKLIST_DEFAULT;
        for (IResource item : items) {
            blacklist = (String)blacklist + item.getFullPath().toPortableString() + SCT_BLACKLIST_SEPERATOR;
        }
        return blacklist;
    }
}

