/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.java.files;

import com.google.inject.Inject;
import com.yakindu.sct.generator.core.extensions.StringHelper;
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.generator.java.GenmodelEntries;
import com.yakindu.sct.generator.java.Naming;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TimerService {
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    private ICoreLibraryHelper _iCoreLibraryHelper;
    @Inject
    @Extension
    private OutputConfigProvider _outputConfigProvider;
    @Inject
    @Extension
    private StringHelper _stringHelper;

    public void generateTimerService(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
        boolean _skipLibraryFiles = this._iCoreLibraryHelper.getSkipLibraryFiles(entry);
        if (_skipLibraryFiles) {
            return;
        }
        String _path = this._stringHelper.toPath(this._genmodelEntries.getLibraryPackage(entry));
        String _plus = _path + "/";
        String _java = this._naming.java(this._naming.timerServiceClass());
        String fileName = _plus + _java;
        fsa.generateFile(fileName, this._outputConfigProvider.getLibraryOutputConfig(entry), this.content(entry));
    }

    private CharSequence content(GeneratorEntry it) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._genmodelEntries.getLicenseText(it);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this._genmodelEntries.getLibraryPackage(it));
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("package ");
            String _libraryPackage = this._genmodelEntries.getLibraryPackage(it);
            _builder.append(_libraryPackage);
            _builder.append(";");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.ArrayList;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.append("import java.util.Timer;");
        _builder.newLine();
        _builder.append("import java.util.TimerTask;");
        _builder.newLine();
        _builder.append("import java.util.concurrent.locks.Lock;");
        _builder.newLine();
        _builder.append("import java.util.concurrent.locks.ReentrantLock;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Default timer service implementation.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public class ");
        String _timerServiceClass = this._naming.timerServiceClass();
        _builder.append(_timerServiceClass);
        _builder.append(" implements ");
        String _iTimerService = this._naming.iTimerService();
        _builder.append(_iTimerService);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private final Timer timer = new Timer();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private final List<TimeEventTask> timerTaskList = new ArrayList<TimeEventTask>();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private final Lock lock = new ReentrantLock();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Timer task that reflects a time event. It's internally used by");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* {@link ");
        String _timerServiceClass_1 = this._naming.timerServiceClass();
        _builder.append(_timerServiceClass_1, "\t ");
        _builder.append("}.");
        _builder.newLineIfNotEmpty();
        _builder.append("\t ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private class TimeEventTask extends TimerTask {");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("private ");
        String _iTimed = this._naming.iTimed();
        _builder.append(_iTimed, "\t\t");
        _builder.append(" callback;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("int eventID;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* Constructor for a time event.");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* @param callback\tan ");
        String _iTimed_1 = this._naming.iTimed();
        _builder.append(_iTimed_1, "\t\t ");
        _builder.append(" object that is called when the timer expires");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t ");
        _builder.append("* @param eventID\tthe id of the state machine's time event");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public TimeEventTask(");
        String _iTimed_2 = this._naming.iTimed();
        _builder.append(_iTimed_2, "\t\t");
        _builder.append(" callback, int eventID) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("this.callback = callback;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("this.eventID = eventID;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public void run() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("callback.raiseTimeEvent(eventID);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public boolean equals(Object obj) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (obj instanceof TimeEventTask) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return ((TimeEventTask) obj).callback.equals(callback)");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("&& ((TimeEventTask) obj).eventID == eventID;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return super.equals(obj);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public int hashCode() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("int prime = 37;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("int result = 1;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("int c = (int) this.eventID;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("result = prime * result + c;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("c = this.callback.hashCode();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("result = prime * result + c;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setTimer(final ");
        String _iTimed_3 = this._naming.iTimed();
        _builder.append(_iTimed_3, "\t");
        _builder.append(" callback, final int eventID,");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("long time, boolean isPeriodic) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// Create a new TimerTask for given event and store it.");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("TimeEventTask timerTask = new TimeEventTask(callback, eventID);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("lock.lock();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("timerTaskList.add(timerTask);");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// start scheduling the timer");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (isPeriodic) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timer.scheduleAtFixedRate(timerTask, time, time);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timer.schedule(timerTask, time);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("lock.unlock();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void unsetTimer(");
        String _iTimed_4 = this._naming.iTimed();
        _builder.append(_iTimed_4, "\t");
        _builder.append(" callback, int eventID) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("lock.lock();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("int index = timerTaskList.indexOf(new TimeEventTask(callback, eventID));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (index != -1) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timerTaskList.get(index).cancel();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timer.purge();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timerTaskList.remove(index);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("lock.unlock();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Cancel timer service. Use this to end possible timing threads and free");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* memory resources.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void cancel() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("lock.lock();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("timer.cancel();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("timer.purge();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("lock.unlock();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

